
<%
'================== The GNU General Public License ================

'ImageIsle - An Image Management Web Application created by
'White Pacific Software. Copyright (C) 2005 White Pacific Software

'This program is free software; you can redistribute it and/or modify
'it under the terms of the GNU General Public License as published by
'the Free Software Foundation using version 2 of the License
'or any later version.

'This license must remain intact inside all distributions and/or
'copies of this application.

'www.whitepacificsoftware.com

'======================================================================




'...............................................
On Error Resume Next
'...............................................

'-----------------------------------------------------------------------------------
'WEB SITE CONSTANTS: Controls global funtionality used in the system and allows you to manually restart your web site.
'-----------------------------------------------------------------------------------
'Note: If you change the variables below, you must restart the web site/server or change the global.asa file to restart the web site for these changes to take affect! Try opening and saving the global.asa file in the main folder of this web app and uploading to your web server to restart the web site and reset all the application and session scoped variables in the site!
'------------------------------------------------------------------------------------
Const RESTART_APPLICATION = "no" '*** We recommend you set this to "no" unless you need to modify any of the application variables listed down below, unless you are still setting up your web site and testing variables values. Normally, those variables will not be read until you set this to "yes" or restart your web application on the server, as they are cached. For performance reason, always set to "no" when you are done, otherwise system will contantly clear out values every user clik of a web page, your site will be very slow, and performance will suffer over time.
Const CHECK_FOR_NEW_MODULES = "yes" '*** We recommend you set this to "yes" until you are done installing all new and modules/skins, then set to "no"! This will improve performance as the site doesnt have to check for new module/skin subfolders every page view by your users!
Const CHECK_FOR_NEW_SKINS = "yes" '*** same as above...set to no when you are done installing all new skins.

'EXPLANATION of constants listed above...
'These constants above allow you to quickly update or modify values and features that affect every page and module used in the system. Even though application scope values below are like global constants used here, application variables are stored once only when the web site starts up and seen when by the first visitor to that site. These global constants however are read and used EVERY TIME A USER CLICKS A WEB PAGE, so allow you to manually change how things like application and session storage and functionality within the site. For example, even though the "SITE_URL application variable stores your web site url permanently when the web site is first started, you can still reset that by changing that application variable value, then below, changing the RESTART_APPLICATION value to "yes". This will force a restart of the web application in the sense, all application variables below will be forced to restore their values. Be sure to turn that constant value to "no" when you are done!
'Note: All the CONSTANTS listed below affect slow performance if set to "yes", but enable special functionality, like new module detection. You may safely turn all these to "no" once the web application first starts (after first visit to web site), and the program will run fine.

'"Const RESTART_APPLICATION" : *** RESET ALL APPLICATION VARIABLES USING THIS CONSTANT : Use this variables to force the system to recheck values you set for the application variables below. When set to "yes", always destroys all application scope variable values and resets them. Helpful for testing, when changing values on a live site and wanting to see immediate changes in the site. Otherwise, they are cached for the lifecycle of the web site for all users until the web site is restarted or a fresh copy of global.asa is uploaded to the server. If you change an application level variable below, that will NOT BE STORED, unless you either restart the web server/machine manually, or you turn this variable ON by settings to "yes".
'Note: Be sure to set your CHECK_FOR_MODULES and skins constants above to yes, if you do that, otherwise, when resetting the MODULE_ARRAY application variable, it will not go in and compile your module and skin folder list!
'Best to set this to "no" UNLESS you change one of the application variables below...

'"Const CHECK_FOR_NEW_MODULES" or "Const CHECK_FOR_NEW_SKINS": Allows the system to dynamically check for new module folders added into the Module system. The system checks to see if new module or skin folders have been added every click of the site. This variable allows that on every web page, but also slows performance, as the system.asp file has to run folder inventories for every page visit. If you want faster site preformance, set this to "no" AFTER adding your new module folder and refreshing browser. That stores the new module in the application array used by the web site.
'Note: If you restart the web application variables by setting RESTART_APPLICATION to "yes", make sure this variable below is set to "yes" as well, else NO MODULES or SKINS will be detected by the system!


'-----------------------------------------------------------------------------------
'WEB APPLICATION VARIABLES: Controls application level variables in the system.
'-----------------------------------------------------------------------------------
'These values are assigned to all links, images, and url's in the system, and used for storing application scoped variables in the system that are used over and over. They are very useful when you need to move or change the top level folders in your web site that contain this web application. When you change the name of a folder that contains other web pages that use that folder name in their path, you can simply change that here in one location and it affects all values in the system. Also useful for setting absolute paths (http://) to make the site available via an email referencing the sites images from an HTML eflyer, setting up SSL paths for all images in the ssystem when needing extra security, setting up new locations for uploaded file paths stored in the database but which you have physically moved to a different folder, or when managing paths when a copy of the site has been migrated to a new server.
'Note: Keep in mind, that these will NOT RESET, if changed, unless you either restart the web application server (not possible if you are hosting with your ISP in most cases) or you turn on the "RESTART_APPLICATION" constant above. If you change the RESTART_APPLICATION constant above, hit refresh on your browser, and all application variables should check for fresh data and restart/reset themselves.
'Note: If you do the above, BE SURE TO THEN SET RESTART_APPLICATION TO "no", otherwise your application will contantly be strating the variables below and be much slower!
'-----------------------------------------------------------------------------------



'IMAGE ISLE VERSION
'Note: Dont change this, as it helps determine what version you have, and which module are compatible in future versions
'************************* SYSTEM SETTINGS ************************
'Program Version: 1.0000
'--------------------
'Prior Versions: -none-
'--------------------
'SystemDatabases.asp version: 1.0000
'--------------------
'******************************************************************
if RESTART_APPLICATION = "yes" or IsNull(Application("II_VERSION")) or Application("II_VERSION") = "" then
    Application.Lock
    Application("II_VERSION") = "1.01 (freeware)"
    Application.Unlock
end if


' Absolute Domain Paths used by the Web Application
'This is the url of your website.
'(used for marketing purposes only and not required for the web site to run)
if RESTART_APPLICATION = "yes" or IsNull(Application("II_SITE_URL")) or Application("II_SITE_URL") = "" then
    Application.Lock
    Application("II_SITE_URL") = "http://www.whitepacificsoftware.com/"
    Application.Unlock
end if

'This is the url of the company that has built the product and used in places like the footer
'and other areas, so users can visit the company for more modules, or to download the software
'(used for marketing purposes only and not required for the web site to run)
if RESTART_APPLICATION = "yes" or IsNull(Application("II_COMPANY_URL")) or Application("II_COMPANY_URL") = "" then
    Application.Lock
    Application("II_COMPANY_URL") = "http://www.whitepacificsoftware.com/"
    Application.Unlock
end if


'Absolute and Relative Paths used in the Web Application
'Note: Only paths NOT controlled by these variables are INCLUDE PATHS, which
'must be manually changed within module pages if your "WEBROOT_PATH" changes
'from whats indicated below.

'This is really the path to the main ImageIsle folder starting from the web root of the web site
'This path should be in the format: "/ImageIsleFolderName" or "/SomeFolderName/ImageIsleFolderName" etc.
'Note: All "/" are added dynamically before and after the folder path when paths are dynamically built using this name in the web site.
'ALERT! Note about Includes in the site: You will STILL HAVE TO MANUALLY CHANGE INCLUDE paths in all modules that use includes their their pages if you change this path below! Because paths assume parent paths on your server are not allowed, and that most of your includes therefore have to use hard-coded paths, your site pages and module will most likely cause 500 ASP errors through all site pages until you manually change each pages include paths. This is by design, simply because include asp files must use absolute virtual paths to reference the system asp file found in this folder. If you later choose to enable parent paths, we recommend you go in and use "file=yourrelativeincludepath" rather than what most include calls use, which is "virtual=yourabsolutevirtualincludepath".
if RESTART_APPLICATION = "yes" or IsNull(Application("II_WEBROOT_PATH")) or Application("II_WEBROOT_PATH") = "" then
'Its recommended that you let the system "dynamically build" this value, so if you decide to embedd the root web site product deeper in your web site directory structure, the system will change the path as needed. It can be overriden if necessary below and setup manually, though.
'GET SERVER ROOT PATH
'...........................................
dim serverRootPath,webApplicationRootPath,theWebRootPath,theLen1,theLen2
theLen1 = 0
theLen2 = 0
theWebRootPath = ""
webApplicationRootPath = server.mappath("/")
serverRootPath = server.mappath(".")

'serverRootPath = Request.ServerVariables("APPL_PHYSICAL_PATH")
'if (isEmpty(serverRootPath) or isNull(serverRootPath) or serverRootPath = "") then
	'This path should match exactly what the ServerVariables("APPL_PHYSICAL_PATH") variable would have returned
	'serverRootPath = server.mappath("/") & "\"
'end if
'Set the current application folder path
'webApplicationRootPath = server.mappath(".")
'Check if the server root path is a part of the web app path before setting variables
'if InStr(webApplicationRootPath,serverRootPath) then

if InStr(serverRootPath,webApplicationRootPath) then
	theLen1 = Len(serverRootPath)
	theLen2 = Len(webApplicationRootPath)
	webApplicationRootPath = Replace(Right(serverRootPath,theLen1-theLen2),"\","/")
	if (IsEmpty(webApplicationRootPath) or webApplicationRootPath = "") then
		'optional root level pathing here...
		'webApplicationRootPath = "/"
		webApplicationRootPath = ""
	end if
	theWebRootPath = webApplicationRootPath
	'response.write "<br />test1: " & serverRootPath
	'response.write "<br />test2: " & server.mappath("/") & "\"
	'response.write "<br />test3: " & theWebRootPath
	'response.write "<br />theLen1: " & theLen1
	'response.write "<br />theLen2: " & theLen2
	'response.write "<br />webApplicationRootPath: " & webApplicationRootPath
else
	'Try and use the default path, which assumes the user dragged the web app into the root web folder of their site,
	'and, did not change the name of the web app folder.
	theWebRootPath = "/ImageIsle"
end if
'...........................................
    Application.Lock
    Application("II_WEBROOT_PATH") = theWebRootPath 'here, the product's web site root folder path is set
    'Application("II_WEBROOT_PATH") = "/ImageIsle" 'can manually set the path here if needed
    Application.Unlock
end if

'Turn on/off the message system, including error alerts that may appear at the top of the application interface
'Note: Leave "on" unless you want to shield your users from error message you know exist, but do not affect your system
if RESTART_APPLICATION = "yes" or IsNull(Application("II_MESSAGE_ONOFF")) or Application("II_MESSAGE_ONOFF") = "" then
    Application.Lock
    Application("II_MESSAGE_ONOFF") = "on"
    Application.Unlock
end if


'This is the default web page the system should use when users first come to a folder in your web application.
'In general this is the same as that page thats setup on the web server for your site by your ISP and is usually default.htm, index.html, etc.
'The default page you set up here should match that server default page, so when users link to your ImageIsle folder,
'the page that appears is the same as the default page the ImageIsle system routes to when users click home (but doesnt have to).
'For this reason, you can use 'either a blank value ("") below, which means go to the ImageIsle or "WEBROOT_PATH" folder
'and let the server choose the default page, or better, hard code that page below.
'Note: This default page is the page the ImageIsle system routes to inside the "WEBROOT_PATH" (or ImageIsle web folder)
'when the user clicks "home" or system/server is reset, etc.
'Note: This usually is the same as the default web page for your server (default.asp), but can be whatever you like!
'Note: Keep in mind, that "default.asp" is ImageIsle's default homepage, and is the best choice, as it has the module/skin dropdowns
'built in and default.asp (like default.htm) is setup by default on most IIs web server 5.0 machines when first installed.
if RESTART_APPLICATION = "yes" or IsNull(Application("II_HOMEPAGE")) or Application("II_HOMEPAGE") = "" then
    Application.Lock
    Application("II_HOMEPAGE") = "default.asp"
    Application.Unlock
end if

'Default module folder
'This is the location of the default module folder in the system (optional as default modules may not be used here)
if RESTART_APPLICATION = "yes" or IsNull(Application("II_MODULE_DEFAULT_FOLDER")) or Application("II_MODULE_DEFAULT_FOLDER") = "" then
    Application.Lock
    Application("II_MODULE_DEFAULT_FOLDER") = "ImageManager"
    Application.Unlock
end if

'Default skin folder
'This is the location of the default style set in the system when none are chosen, or when first coming to the web site
'This sets the "skin" that will be used and the interface design and colors chosen when the application is reset
'Note: The settings module may later override this value when configuring the system using the settings module and its database.
if RESTART_APPLICATION = "yes" or IsNull(Application("II_SKIN_DEFAULT_FOLDER")) or Application("II_SKIN_DEFAULT_FOLDER") = "" then
    Application.Lock
    Application("II_SKIN_DEFAULT_FOLDER") = "WhitePacific"
    Application.Unlock
end if

'This path should be in the format: "ModuleFolderName" or "SomeParentFolderName/ModuleFolderName"
'Note: Do not change this path, unless absolutely necessary, as it is related to module-level redirect scripts and access to modules in the system. Changing this path could cause system level errors.
'Note: This path is relative to the WEBROOT_PATH above.
'Note: All "/" are added dynamically before and after the folder path when paths are dynamically built using this name in the web site.
if RESTART_APPLICATION = "yes" or IsNull(Application("II_MODULE_PATH")) or Application("II_MODULE_PATH") = "" then
    Application.Lock
    Application("II_MODULE_PATH") = "Modules"
    Application.Unlock
end if

'Same as above for modules...
if RESTART_APPLICATION = "yes" or IsNull(Application("II_SKIN_PATH")) or Application("II_SKIN_PATH") = "" then
    Application.Lock
    Application("II_SKIN_PATH") = "Skins"
    Application.Unlock
end if

'Same as above for modules...
if RESTART_APPLICATION = "yes" or IsNull(Application("II_STORAGE_PATH")) or Application("II_STORAGE_PATH") = "" then
    Application.Lock
    Application("II_STORAGE_PATH") = "Storage"
    Application.Unlock
end if

'Not used but would need to be an absolute url with the ssl protocol: example "https://www.whitepacificsoftware.com/"
if RESTART_APPLICATION = "yes" or IsNull(Application("II_SSL_PATH")) or Application("II_SSL_PATH") = "" then
    Application.Lock
    Application("II_SSL_PATH") = empty
    Application.Unlock
end if

'Titles and Names useed in the Web Application
if RESTART_APPLICATION = "yes" or IsNull(Application("II_COMPANY_NAME")) or Application("II_COMPANY_NAME") = "" then
    Application.Lock
    Application("II_COMPANY_NAME") = "White Pacific Software"
    Application.Unlock
end if

if RESTART_APPLICATION = "yes" or IsNull(Application("II_PRODUCT_NAME")) or Application("II_PRODUCT_NAME") = "" then
    Application.Lock
    Application("II_PRODUCT_NAME") = "ImageIsle&copy; Freeware"
    Application.Unlock
end if

if RESTART_APPLICATION = "yes" or IsNull(Application("II_SITE_COPYRIGHT")) or Application("II_SITE_COPYRIGHT") = "" then
    Application.Lock
    Application("II_SITE_COPYRIGHT") = "White Pacific Software, copyright 2005"
    Application.Unlock
end if

if RESTART_APPLICATION = "yes" or IsNull(Application("II_WEBMASTER_EMAIL")) or Application("II_WEBMASTER_EMAIL") = "" then
    Application.Lock
    Application("II_WEBMASTER_EMAIL") = "sales@whitepacificsoftware.com"
    Application.Unlock
end if

'Master Array that stores all Security status information for modules in the system (the "Security" module manages this)
'Note: keep this empty here as will be built dynamically elsewhere, unless you need to hard code the system.
if RESTART_APPLICATION = "yes" or IsNull(Application("II_SECURITY_ARRAY")) or IsEmpty(Application("II_SECURITY_ARRAY")) then
    'Application.Lock
    'Application("II_SECURITY_ARRAY") = null
    'Application.Unlock
end if

'Master Array that stores all Module data and used to get location of module, its database, and other items
'Note: keep this empty here as will be built dynamically elsewhere, unless you need to hard code the system.
if RESTART_APPLICATION = "yes" or IsNull(Application("II_MODULE_ARRAY")) or IsEmpty(Application("II_MODULE_ARRAY")) then
    'Application.Lock
    'Application("II_MODULE_ARRAY") = null
    'Application.Unlock
end if

'Holds the final name/value pair for every module detected in the system and
'used to build the final dropdown list shown at teh top of the web application interface
'Note: keep this empty here as will be built dynamically elsewhere, unless you need to hard code the system.
if RESTART_APPLICATION = "yes" or IsNull(Application("II_MODULE_MENU")) or IsEmpty(Application("II_MODULE_MENU")) then
    'Application.Lock
    'Application("II_MODULE_MENU") = null
    'Application.Unlock
end if

'Master Array that stores all Skin data and used to get location of module, its database, and other items
'Note: keep this empty here as will be built dynamically elsewhere, unless you need to hard code the system.
if RESTART_APPLICATION = "yes" or IsNull(Application("II_SKIN_ARRAY")) or IsEmpty(Application("II_SKIN_ARRAY")) then
    'Application.Lock
    'Application("II_SKIN_ARRAY") = null
    'Application.Unlock
end if

'Holds the final name/value pair for every skin detected in the system and
'used to build the final dropdown list shown at teh top of the web application interface
'Note: keep this empty here as will be built dynamically elsewhere, unless you need to hard code the system.
if RESTART_APPLICATION = "yes" or IsNull(Application("II_SKIN_MENU")) or IsEmpty(Application("II_SKIN_MENU")) then
    'Application.Lock
    'Application("II_SKIN_MENU") = null
    'Application.Unlock
end if




'CONFIGURATION.XML DATA ACCESS VARIABLES
'-----------------------------------------------------------------------------
'CONFIGUREATION.XML: This sets the number of allowed "items" or nodes values allowed or stored in each of
'the module and skin folder's configuration.xml files. Sets number of items allowed to be stored.
'Arrays in system.asp use this number to redim arrays and set up exact number of values stored
'Note: This should be some value equal to or larger than the total number of items in "CONFIGURATION_XML_VALUES" below,
'in order to accomodate extra values added in the system and to avoid chopping off the last values listed in the array.
if RESTART_APPLICATION = "yes" or IsNull(Application("II_CONFIGURATION_XML_NUMBER")) or IsEmpty(Application("II_CONFIGURATION_XML_NUMBER")) then
    Application.Lock
    Application("II_CONFIGURATION_XML_NUMBER") = 11
    Application.Unlock
end if

'CONFIGUREATION.XML: This variable creates an array representing the EXACT attribute xml node NAMES and ORDER
'needed from every module/skins configuration.xml file. This allows you to pick out on the name/value pairs
'of data needed from these config files no matter what order they are in or how many. You can access these as well
'from the Application("II_MODULE_ARRAY") and Application("II_SKIN_ARRAY") variables. This variable and the one above
'that sets the number allowed, you can decide the exact variables you need to share between modules and
'which index/order in the array you may access them.
'Set the list of named items you accept below. These names must match "item" node attribute "name" values
'found in the configuration.xml files found in modules and skin folders
'Note: Because the system requires some values to work, like database paths and module names, its best
'to leave these values as is, unless you are wanting to store new configuration.xml file values used
'in custom modules you are building.
'Note: the "split" creates a 1-d array for use later as an array. Again, the values and order you set below determine
'what every module and skin in the system uses when accessing their own databases and paths, as well as those
'of other modules and skins. Unless you need to ADD new values to your configuration.xml files, it is
'recommended that the list below remain as is, unless the software is updated with a newer version.
'note: Two array values are always stored in the final Application("II_MODULE_ARRAY"):foldername and datetime_modified
'These are added dynamically by system.asp based on the actual name of the folder holding the module/skin
'and also getting the actual modified date/time of configuration.xml. So you cannot modify or change their inclusion
'in the final array. Be sure you include them if you access the application array and are trying to extract your values
'from the array.
if RESTART_APPLICATION = "yes" or IsNull(Application("II_CONFIGURATION_XML_VALUES")) or IsEmpty(Application("II_CONFIGURATION_XML_VALUES")) then
    dim presetArrayValues,optionalArrayValues
    'These two values are NOT set in the configuration.xml files inside of modules, but are generated dnamically by the system from the existing folder or directory name assigned to the module as well as the modified date the operating system assigns to your configuration.xml file. The array values below these CAN be set in the configuration.xml file and controlled by you.....but these two may not. They are provided by the system by default and are always built into the array in the first two indexes (cannot remove). Please do not change these two presets below. Additional: "folder_path" may be substituted here for "folder_name" if you like.
    presetArrayValues = "folder_name,datetime_modified,"
    'You may modify/customize/add to this list. Sum of all array names/indexes in the final list includes the two values above
    'note: "module_name" may be substituted here for "name"
    optionalArrayValues = "name,description,author,author_url,status,datetime_created,database_path,license,icon_path"
    Application.Lock
    Application("II_CONFIGURATION_XML_VALUES") = split((presetArrayValues & optionalArrayValues),",")
    Application.Unlock
end if

' Misc Database Connections Strings (optional - not used)
'-----------------------------------------------------------------------------------
'if RESTART_APPLICATION = "yes" or IsNull(Application("II_DATABASE_ACCESS_CONNECTION_STRING")) or Application("II_DATABASE_ACCESS_CONNECTION_STRING") = "" then
    'Application.Lock
    'Application("II_DATABASE_ACCESS_CONNECTION_STRING") = "Provider=Microsoft.Jet.OLEDB.4.0;Persist Security Info=False;Data Source=" & Server.MapPath("/ImageIsle/Data/Access/ImageIsle.mdb")
    'Application.Unlock
'end if

'if RESTART_APPLICATION = "yes" or IsNull(Application("II_DATABASE_SQLSERVER_CONNECTION_STRING")) or Application("II_DATABASE_SQLSERVER_CONNECTION_STRING") = "" then
    'Application.Lock
    'Application("II_DATABASE_SQLSERVER_CONNECTION_STRING") = empty
    'Application.Unlock
'end if

'if RESTART_APPLICATION = "yes" or IsNull(Application("II_DATABASE_MYSQL_CONNECTION_STRING")) or Application("II_DATABASE_MYSQL_CONNECTION_STRING") = "" then
    'Application.Lock
    'Application("II_DATABASE_MYSQL_CONNECTION_STRING") = empty
    'Application.Unlock
'end if

'if RESTART_APPLICATION = "yes" or IsNull(Application("II_DATABASE_ORACLE_CONNECTION_STRING")) or Application("II_DATABASE_ORACLE_CONNECTION_STRING") = "" then
    'Application.Lock
    'Application("II_DATABASE_ORACLE_CONNECTION_STRING") = empty
    'Application.Unlock
'end if
'-----------------------------------------------------------------------------------
' Sample Database Connection Strings
' "Provider=Microsoft.Jet.OLEDB.4.0;Persist Security Info=False;Data Source=" & Server.MapPath("/ImageIsle/Data/Access/ImageIsle.mdb")
' "DRIVER={Microsoft Access Driver (*.mdb)};DBQ=" & Server.MapPath("/ImageIsle/Data/Access/ImageIsle.mdb")
' "Provider=SQLOLEDB;Data Source=(local);Initial Catalog=ImageIsle;User Id=yourusername;Password=yourpassword;Persist Security Info=False"
'-----------------------------------------------------------------------------------







'-----------------------------------------------------------------------------------
' WEB SESSION VARIABLES
'-----------------------------------------------------------------------------------
'Session level variables here apply to indivisual users only, and begin when a new user enters the web site. Because some things, like open/close panels in the interface, login id's and messages are globally found throughout tyhe system and all modules in the system, those variables are set below. In general, most of the session level variables change when the user does something, like click to open a panel, or an error message displays in the message session variable. Those are triggered by querystrings and set in the session so throughout the lifecycle of the web app for that user, he/she sees information specific just to them. Application scope variables above, on the other hand, affect everyone in the system.
'-----------------------------------------------------------------------------------
if IsNull(request.querystring("message")) or IsEmpty(request.querystring("message")) or request.querystring("message") = "" then
	if IsNull(Session("II_MESSAGE")) or IsEmpty(Session("II_MESSAGE")) then
    ' Only clear the session message if its empty to begin with
    Session("II_MESSAGE") = ""
    end if
else
    Session("II_MESSAGE") = request.querystring("message")
end if

'Dont use this for now...
'if Session("II_LOGIN") = null then
    'Session("II_LOGIN") = 0 ' this session object represents the id of the user. 0 means no user id is set and current user is logged out
'end if

'-----------------------------------------------------------------------------------
' GET/SET THE PANEL'S OPEN/CLOSE FEATURES
'The PANEL session controls the open/close feature for all the panels. A specific value is given to each panel section session variable, and its open close status is toggled on/off. The panel querystring is in turn passed to other session variables listed below...
'-----------------------------------------------------------------------------------
if IsNull(Request.QueryString("panel")) or IsEmpty(Request.QueryString("panel")) or Request.QueryString("panel") = "" then
	if IsNull(Session("II_PANEL")) or IsEmpty(Session("II_PANEL")) then
    'Example of how to turn on module menu panel manually by default...so its flipped open and shows drop down menus (also allows footer to show up in older browsers by default)
	Session("II_PANELMODULE") = "moduleon"
	'Session("II_PANEL") = ""
	end if
else
	Session("II_PANEL") = Request.QueryString("panel")
end if
'-----------------------------------------------------------------------------------
'All system errors are stored as a string inside this variable and spit out at the bottom of the page.
'This session is created and controlled via methods found in the "System/ErrorMessageHeader.asp" file.
if IsNull(Session("II_ERRORS")) or IsEmpty(Session("II_ERRORS")) then
' Only clear the session if its empty to begin with and set to empty string
Session("II_ERRORS") = ""
end if
'-----------------------------------------------------------------------------------









'********************** SYSTEM VARIABLES CLASS **********************
'Use this class object to return a list of all the built in variables for the server and its systems.
'Includes things like VBScript version running, server variables, software version, etc.
'Great for troubleshooting issues that go beyond the ASP files and software, and which
'might be causing the system to fail. Those might be server/platform related.


Class SystemInformation

Private Sub Class_Initialize()
    '(optional) reset session message object
    'Session("II_MESSAGE") = ""
End Sub

Private Sub Class_Terminate()
    '(optional) reset session message object
    'Session("II_MESSAGE") = ""
End Sub


'GET SCRIPT ENGINE VERSION
Public Function ScriptVersion
   Dim x
   x = ""
   x = x & "<strong style='color:#333;'>" & ScriptEngine & " Version</strong> "
   x = x & "<strong style='color:#cc0066;'>" & ScriptEngineMajorVersion & "."
   x = x & ScriptEngineMinorVersion & "."
   x = x & ScriptEngineBuildVersion & "</strong>"
   ScriptVersion = x
End Function


'GET SCRIPT ENGINE VERSION
Public Function SoftwareVersion
   Dim x
   x = ""
   x = x & "Program Version: <strong style='color:#cc0000;'>1.0000</strong><br />"
   x = x & "--------------------<br />"
   x = x & "Prior Versions: <strong style='color:#cc0000;'>-none-</strong><br />"
   x = x & "--------------------<br />"
   x = x & "SystemSettings.asp version: <strong style='color:#cc0000;'>1.01</strong><br />"
   x = x & "--------------------<br />"
   SoftwareVersion = x
End Function




'DETECT MSXML PARSER VERSIONS INSTALLED ON YOUR SERVER - (Microsoft.MSDOM is used by this program)
Public Function MSXMLVersion

dim x,XMLDoc,domDoc
x = ""
x = x & "<strong>List of MSXML Parsers On Your Local Server:</strong> MSXML provides access to your module's databases, and is required for the program to load dynamic content. (note: some older versions may be mapped to later versions on install)<br />" 'IE Version

XMLDoc = "<?xml version='1.0'?><Test>XML TEST</Test>" 'Build test XML Document

'"Microsoft.XMLDOM"
On Error Resume Next
set domDoc = Server.CreateObject("Microsoft.XMLDOM")
domDoc.async=false
domDoc.loadXML(XMLDoc)
If Err.number <> 0 then
    x = x & "<input type='checkbox' disabled='disabled' />Microsoft.XMLDOM may be missing | <em>" &  Err.description & "</em><br />"
    Err.Clear
else
    x = x & "<input type='checkbox' readonly='readonly' checked='checked' style='background:#ccc;border:1px solid #000;margin:5px;' />Microsoft.XMLDOM Found!<br />"
End If

'Msxml2.DOMDocument
On Error Resume Next
set domDoc = Server.CreateObject("Msxml2.DOMDocument")
domDoc.async=false
domDoc.loadXML(XMLDoc)
If Err.number <> 0 then
    x = x & "<input type='checkbox' disabled='disabled' />Msxml2.DOMDocument may be missing | <em>" &  Err.description & "</em><br />"
    Err.Clear
else
    x = x & "<input type='checkbox' readonly='readonly' checked='checked' style='background:#ccc;border:1px solid #000;margin:5px;' />Msxml2.DOMDocument Found!<br />"
End If

'Msxml2.FreethreadedDomDocument
On Error Resume Next
set domDoc = Server.CreateObject("Msxml2.FreethreadedDomDocument")
domDoc.async=false
domDoc.loadXML(XMLDoc)
If Err.number <> 0 then
    x = x & "<input type='checkbox' disabled='disabled' />Msxml2.FreethreadedDomDocument may be missing | <em>" &  Err.description & "</em><br />"
    Err.Clear
else
    x = x & "<input type='checkbox' readonly='readonly' checked='checked' style='background:#ccc;border:1px solid #000;margin:5px;' />Msxml2.FreethreadedDomDocument Found!<br />"
End If

'Msxml2.DOMDocument.2.6
On Error Resume Next
set domDoc = Server.CreateObject("Msxml2.DOMDocument.2.6")
domDoc.async=false
domDoc.loadXML(XMLDoc)
If Err.number <> 0 then
    x = x & "<input type='checkbox' disabled='disabled' />Msxml2.DOMDocument.2.6 may be missing | <em>" &  Err.description & "</em><br />"
    Err.Clear
else
    x = x & "<input type='checkbox' readonly='readonly' checked='checked' style='background:#ccc;border:1px solid #000;margin:5px;' />Msxml2.DOMDocument.2.6 Found!<br />"
End If

'Msxml2.DOMDocument.3.0
On Error Resume Next
set domDoc = Server.CreateObject("Msxml2.DOMDocument.3.0")
domDoc.async=false
domDoc.loadXML(XMLDoc)
If Err.number <> 0 then
    x = x & "<input type='checkbox' disabled='disabled' />Msxml2.DOMDocument.3.0 may be missing | <em>" &  Err.description & "</em><br />"
    Err.Clear
else
    x = x & "<input type='checkbox' readonly='readonly' checked='checked' style='background:#ccc;border:1px solid #000;margin:5px;' />Msxml2.DOMDocument.3.0 Found!<br />"
End If

'Msxml2.FreethreadedDomDocument.3.0
On Error Resume Next
set domDoc = Server.CreateObject("Msxml2.FreethreadedDomDocument.3.0")
domDoc.async=false
domDoc.loadXML(XMLDoc)
If Err.number <> 0 then
    x = x & "<input type='checkbox' disabled='disabled' />Msxml2.FreethreadedDomDocument.3.0 may be missing | <em>" &  Err.description & "</em><br />"
    Err.Clear
else
    x = x & "<input type='checkbox' readonly='readonly' checked='checked' style='background:#ccc;border:1px solid #000;margin:5px;' />Msxml2.FreethreadedDomDocument.3.0 Found!<br />"
End If

'Msxml2.DOMDocument.4.0
On Error Resume Next
set domDoc = Server.CreateObject("Msxml2.DOMDocument.4.0")
domDoc.async=false
domDoc.loadXML(XMLDoc)
If Err.number <> 0 then
    x = x & "<input type='checkbox' disabled='disabled' />Msxml2.DOMDocument.4.0 may be missing | <em>" &  Err.description & "</em><br />"
    Err.Clear
else
    x = x & "<input type='checkbox' readonly='readonly' checked='checked' style='background:#ccc;border:1px solid #000;margin:5px;' />Msxml2.DOMDocument.4.0 Found!<br />"
End If

'Msxml2.DOMDocument.5.0
On Error Resume Next
set domDoc = Server.CreateObject("Msxml2.DOMDocument.5.0")
domDoc.async=false
domDoc.loadXML(XMLDoc)
If Err.number <> 0 then
    x = x & "<input type='checkbox' disabled='disabled' />Msxml2.DOMDocument.5.0 may be missing | <em>" &  Err.description & "</em><br />"
    Err.Clear
else
    x = x & "<input type='checkbox' readonly='readonly' checked='checked' style='background:#ccc;border:1px solid #000;margin:5px;' />Msxml2.DOMDocument.5.0 Found!<br />"
End If

'Msxml2.DOMDocument.6.0
On Error Resume Next
set domDoc = Server.CreateObject("Msxml2.DOMDocument.6.0")
domDoc.async=false
domDoc.loadXML(XMLDoc)
If Err.number <> 0 then
    x = x & "<input type='checkbox' disabled='disabled' />Msxml2.DOMDocument.6.0 may be missing | <em>" &  Err.description & "</em><br />"
    Err.Clear
else
    x = x & "<input type='checkbox' readonly='readonly' checked='checked' style='background:#ccc;border:1px solid #000;margin:5px;' />Msxml2.DOMDocument.6.0 Found!<br />"
End If

x = x & "If only one check box is selected, then your MSXML parser is in 'Replace' mode, meaning older older versions may be mapped to the newer versions (example: calls to Microsoft.XMLDOM is reregistered to use Msxml2.DOMDocument.3.0 in some installations.<br />"
x = x & "If more than one check box appears selected, your MSXML parsers are in 'Side-by-Side' mode. In this mode, your original installations of older parsers may be intact and each may be used separately.<br />Note: This software product is designed by default to use the 'older parsers' for backwards compatibility. If you customize this product, get a later version or download a modified version that either does not work or needs to use functions in later parsers of MSXML, then you may need to change the MXSML call in the Database Class inside SystemDatabase.asp to point to a newer version of MSXML. (example: Msxml2.DOMDocument.4.0)"

MSXMLVersion = x

End Function


'SERVER VARIABLES LIST
'Note: Server variables are NOTORIOUSLY SLOW, so do use, or save to variable before using.
'SERVER VARIABLE TESTING : Run server variables listing below to test server variables if needed.
'Uncomment all code below to get your server's variables list printed out onto the screen for you.
Public Function ServerVariables
Dim x
   x = ""
   x = x & "<strong style='color:#cc0000;'>Your Server Variable Listing:</strong><table>"
   for each y in Request.ServerVariables
    x = x & "<tr><td align='right' valign='top'>" & y & "</td><td>&nbsp;&nbsp;</td>"
    x = x & "<td align='left' valign='top'><strong>" & Request.ServerVariables(y) & "</strong></td></tr>"
   next
   x = x & "</table>"
ServerVariables = x
End Function


'................... PRINT ALL FUNCTIONS IN CLASS ...............
'Use to send all output to your calling function using a response.write (manual)
Public Function WriteAllInformation()
    'call all of the classes routines and set session message object values...
    Dim x
    x = ""
    x = x + "<hr />" + ScriptVersion()
    x = x + "<hr />" + SoftwareVersion()
    x = x + "<hr />" + MSXMLVersion()
    x = x + "<hr />" + ServerVariables() & "<hr />"
    WriteAllInformation = x
End Function
'Use if you want all output returned via the Session("II_MESSAGE") or message bar at the top of the page
Public Sub AllInformation()
    'call all of the classes routines and set session message object values...
    Dim x
    x = ""
    x = x + "<hr />" + ScriptVersion()
    x = x + "<hr />" + SoftwareVersion()
    x = x + "<hr />" + MSXMLVersion()
    x = x + "<hr />" + ServerVariables() & "<hr />"
    Session("II_MESSAGE") = x
End Sub
'.................................................................

End Class
'************************************************************





'********************* TEST PRINT SYSTEM INFO **********************
'Shows how to call System Info and manually write single function of info to the browser...
'Dim SystemInfo,writeInfo
'Set SystemInfo = new SystemInformation
'Response.Write("<br />SystemInfo.ScriptVersion: " & SystemInfo.ScriptVersion())

'Shows how to call System Info and manually write to browser...
'Dim SystemInfo,writeInfo
'Set SystemInfo = new SystemInformation
'Response.Write("<br />SystemInfo.WriteAllInformation: " & SystemInfo.WriteAllInformation())

'Shows how to call System Info using SESSION message bar system thats built in...
'+++++++ SYSTEM INFORMATION +++++++
    'Dim SystemInfo
    'Set SystemInfo = new SystemInformation
    'Call SystemInfo.AllInformation
'++++++++++++++++++++++++++++++++++

'************************************************************







'...............................................
'check for errors
If Err.number <> 0 then
    Call CaptureThisError("SystemSettings.asp:check this file for the error")
    Err.Clear
End If
'...............................................
%>
