<%
Sub CalculateTax (subtotal, total, shippingcost, tax)
'****************************************************************
' This routine calculates tax fo VP-ASP
' Inputs are
' Code for State  xtaxstatename, xtaxstaterates
'  Code for country  xtaxcountryname, xtaxcountryrates
' Code by product  xtaxbyproduct
' VP-ASP 6.0 
' May 14, 2004   Fix EU Vat
' Dec 31, 2005   Add xfactor, xnet to taxeu subroutine
' 3 March 2006   Check if customer has tax exempt flag
'****************************************************************
'VP-ASP 6.08 Check if customer has tax exempt flag
if getsess("CustomerID") > "" then
	dim custdbc, custsql, custrs
	
	OpenCustomerDB custdbc
	
	custsql = "select taxexempt from customers where contactid = " & getsess("CustomerID")
	set custrs = custdbc.execute(custsql)
	
	if not custrs.eof then
		if lcase(custrs("taxexempt")) = "yes" OR lcase(custrs("taxexempt")) = "true" then
			closerecordset custrs
			shopclosedatabase custdbc
			exit sub
		end if
	end if
	
	closerecordset custrs
	shopclosedatabase custdbc
end if

dim taxdone,taxprice
Tax=0
taxdone=false
If getconfig("xtaxincludeshipping")="Yes" then 
   taxprice=subtotal+shippingcost
else   
  If getconfig("xtaxincludediscount")="No" then
    taxprice=total
  Else
    taxprice=subtotal
  End If
end if  
If getconfig("xtaxexcludeproducts")<>""  or getconfig("xtaxexcludeproductsdb")<>"" or getconfig("xtaxfreeproducts")="Yes" then
   taxCalculatenewsubtotal taxprice
   If getconfig("xtaxincludeshipping")="Yes"  then
      taxprice=taxprice+shippingcost
   end if   
end if   
'debugwrite "taxprice=" & taxprice
TaxbyState taxprice, tax, taxdone
if taxdone=True then exit sub
Taxbycountry taxprice, tax, taxdone
if taxdone=true then exit sub
TaxbyProduct taxprice, tax, taxdone
if taxdone=True then exit sub
TaxforEU taxprice, tax, taxdone
end sub
'
' Handle By State/Province
Sub TaxbyState (price, tax, taxdone)
dim state, words(100),wordcount, staterates, i
dim rates(100),ratecount, rate
If getconfig("xtaxStatename")="" then
   exit sub
end if
staterates=getconfig("xtaxstaterates")
if staterates="" then exit sub
parserecord getconfig("xtaxstatename"),words,wordcount,","
If getconfig("xtaxshippingstate")="Yes" then
   state=getsess("shipstate")
   if state="" then
      state=getsess("state")
   end if   
else
     state=getsess("state")
end if
for i = 0 to wordcount-1
  'VP-ASP 6.09 - add UCASE to STATE so that IF statement balances out
  if ucase(words(i))=UCASE(State) then
       parserecord staterates, rates,ratecount, ","
      if  i> ratecount then exit sub
      rate=rates(i)            ' get rate
      rate=csng(rate)          ' convert to number
'=================================
'YourVirtualStore code - fixes tax included in price calculation error
'Cam Flanigan
'16/06/2003
'=================================
dim xfactor, xnet
	if getconfig("xtaxincludedinprice") = "Yes" then
		xfactor = (rate * 100) + 100
		xnet = (price/xfactor) * 100
		tax = price - xnet
	else
		tax=rate*price
	end if   
	'tax=xtaxrate*taxprice
'=================================
'      tax=rate*price           ' tax
      taxdone=true             'finished 
      exit sub
   end if
next   
end sub
'
Sub TaxbyCountry (price, tax, taxdone)
dim country, words(100),wordcount, countryrates, i
dim rates(100),ratecount, rate
If getconfig("xtaxcountryname")="" then
   exit sub
end if
countryrates=getconfig("xtaxcountryrates")
if countryrates="" then exit sub
parserecord getconfig("xtaxcountryname"),words,wordcount,","
country=ucase(Getsess("country"))
for i = 0 to wordcount-1
  if ucase(words(i))=country then
     parserecord countryrates, rates,ratecount, ","
      if  i> ratecount then exit sub
      rate=rates(i)            ' get rate
      rate=csng(rate)          ' convert to number
'=================================
'YourVirtualStore code - fixes tax included in price calculation error
'Cam Flanigan
'16/06/2003
'=================================
dim xfactor, xnet
	if getconfig("xtaxincludedinprice") = "Yes" then
		xfactor = (rate * 100) + 100
		xnet = (price/xfactor) * 100
		tax = price - xnet
	else
		tax=rate*price
	end if   
	'tax=xtaxrate*taxprice
'=================================
'      tax=rate*price           ' tax
      taxdone=true             'finished 
      exit sub
   end if
next   
end sub
'
Sub TaxbyProduct (iprice, tax, taxdone)
dim taxfield
taxfield=getconfig("xtaxbyproduct")
if taxfield="" then exit sub
Dim productname, quantity, price, taxdbc
dim scartitem, arrcart, productid, productcode, taxforitem
dim taxamount
Dim i
dim productql
dim rsitem  
'
ShopOpenDatabaseP taxDbc
scartItem = getsess("CartCount")         ' number of products
arrCart = getsessa("CartArray")
For i = 1 to scartItem
    productid=arrCart(cProductid,i)
    productcode=arrCart(cProductCode,i)
    productname= arrCart(cProductname,i)
    quantity=arrCart(cQuantity,i)
    Price=arrCart(cUnitPrice, i)
    productql="select * from products where catalogid=" & productid
    Set rsItem = taxdbc.execute(Productql)
    taxforitem=0
    If Not rsItem.EOF Then
       if not isnull(rsitem(taxfield)) then
          taxamount=rsitem(taxfield)
          taxamount=csng(taxamount)
          TaxforItem=Quantity*Price*taxamount   
       end if   
    end if
    Tax=Tax+TaxForItem   
    closeRecordset rsitem
Next
ShopCloseDatabase taxdbc
taxdone=true
end sub
'
sub TaxforEU (taxprice, tax, taxdone)
'****************************************************************
' This routine calculates tax foe EU countries
' If the order is for anyone in the country list above, set tax at 17.5%
' Inputs are
'****************************************************************
dim xcountryname, xtaxrate
dim xfactor, xnet
If Getconfig("xTaxEu")<>"Yes" then exit sub
taxdone=true
' No tax if valid vat number
If getsess("vatnumbertax")<>"" then exit sub
xcountryname=getconfig("xtaxeucountries")
xtaxrate=getconfig("xtaxeurate")
dim country, words(100),wordcount,i
parserecord xcountryname,words,wordcount,","
' the country is  avalid EU country do the tax rate
country=ucase(Getsess("country"))
for i = 0 to wordcount-1
  if words(i)=country then
'=================================
'YourVirtualStore code - fixes tax included in price calculation error
'Cam Flanigan
'19/07/2003
'=================================
	if getconfig("xtaxincludedinprice") = "Yes" then
		xfactor = (xtaxrate * 100) + 100
		xnet = (taxprice/xfactor) * 100
		tax = taxprice - xnet
	else
		tax=xtaxrate*taxprice
	end if   
	'tax=xtaxrate*taxprice
'=================================
      exit sub
   end if
next   
end sub
'********************************************************
' Exclude some products such as gift certificates
'********************************************************
Sub TaxCalculatenewsubtotal (newsubtotal)
Dim scartItem, giftproductid, taxDbc
Dim arrCart
Dim i
Dim ProdQuantity, prodprice
dim foundproduct, productid
dim products(100), productcount
dim dbfield
dbfield=getconfig("xtaxexcludeproductsdb")
if getconfig("xtaxexcludeproductsdb")<>"" or getconfig("xtaxfreeproducts")="Yes" then
	ShopOpenDatabaseP taxDbc
end if
If getconfig("xtaxexcludeproducts")<>"" then 
  parserecord getconfig("xtaxexcludeproducts"),products,productcount,","
   For i=0 to productcount-1
    Products(i)=clng(products(i))
   next  
else
   productcount=0
end if      
scartItem = getsess("cartcount")
arrCart = getsessa("cartarray")

'VP-ASP 6.09 - fix for tax calculation when a discount is used
dim oldsubtotal
oldsubtotal = newsubtotal

newsubtotal=0
' go through all products and add up the quantities
For i = 1 to scartItem
  productid=arrCart(cProductid,i)
  if isnumeric(productid) then
     productid=clng(productid)
  else 
     productid=0
  end if      
  ProdQuantity= arrCart(cQuantity,i)
  ProdPrice= arrCart(cUnitPrice,i)
  foundproduct=false
  if productcount>0 then 
    foundproduct=taxFindproduct(productid, products, productcount)
  end if  
  if foundproduct=false then
  	if dbfield<>""  or getconfig("xtaxfreeproducts")="Yes" then
  	   foundproduct=taxFindProductdb(productid, taxdbc, dbfield)
  	end if
  end if
  if foundproduct=false then        
	'VP-ASP 6.09 - fix for tax calculation when a discount is used
    'Newsubtotal=newsubtotal + ProdQuantity* ProdPrice
	Newsubtotal=oldsubtotal
  end if  
Next
'debugwrite "newsubtotal="& newsubtotal
if dbfield<>"" then
	ShopCloseDatabase taxdbc
end if
end sub
Function TaxFindProduct (productid, products, productcount)
dim i
for i = 0 to productcount-1
  if productid=products(i) then
     taxfindproduct=true
     exit function
  end if
next
taxfindproduct=false     
end function
'******************************************************************
' Find product in database
' if field in taxexemptfieldd is not null it is taxexempt
' or in 5.50 it can be marked taxfree in the product record
'********************************************************************
Function TaxFindProductDB (productid, taxDbc, taxfield)
dim  productsql, rsItem,  taxvalue, found
found=false
productsql="select * from products where catalogid=" & productid
Set rsItem = taxdbc.execute(Productsql)
If Not rsItem.EOF Then
   If taxfield<>"" then  
     taxvalue=rsitem(taxfield)
     if not isnull(taxvalue) then
        found=true 
     end if
   end if
   if getconfig("Xtaxfreeproducts")="Yes" then 
       taxvalue=rsitem("taxfree")
       if isnull(taxvalue) then 
          taxvalue=0
        end if   
       if taxvalue<>0 then
           found=true
       end if
   end if          
end if
closerecordset rsitem
TaxFindProductdb=found
end function
%>