#!PERL

#	$RCSfile: newdb.pl,v $
#	$Revision: 0.14 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 14:43:00 $

# This is a little tool to generate an empty database which just contains
# the generation date, and the COPYRIGHT notice as defined in the config
# file. Mainly used for testing purposes.
# One should be careful with this, since it will simply overwrite existing
# database files if the -f flag is given. No Mercy.

USE_DBM

@INC = ("LIBDIR", @INC);

require "rconf.pl";
require "getopts.pl";

&Getopts('fh');

# You need help or have no command line arguments ?

if ($opt_h || !$ARGV[0]) {
	print <<"EOF";
Usage: $0 [-f] [-h] file

-f		Force new database even if file exists
-h		This help message
filename	The name of the new database file to be generated
EOF

	exit;
}

# Check to see if file exists, and if the force overwrite flag is set

if (-e $ARGV[0] && !$opt_f) {
	print STDERR "File exists, will not overwrite\n";
	exit;
}

# Read the conf, for the COPYRIGHT notice

$conffile=$ENV{"RIPEDBCNF"};
$conffile= "DEFCONFIG" unless $conffile;
&rconf($conffile);

# Here we go ...

open(NEWDB, ">$ARGV[0]") || die "Cannot open $ARGV[0]: $!";

# Print generation date and copyright to the database

&printrights(NEWDB);

# And that was it ...

close(NEWDB);

# Delete indexes in case they happen to exist ...

&delormoveindices($ARGV[0]);
&delormoveindices($ARGV[0].".".$CLASSLESSEXT);

# end of script