#
#	syslog - simplified syslog "type" routine.
#
#	$RCSfile: syslog.pl,v $
#	$Revision: 0.15 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 14:43:00 $
#
#	It allows you to write to various logfiles defined in general config
#	
require	"defines.pl";
require "misc.pl";

sub syslog {
    local($log, $string) = @_;

    # Get the time

    local($s, $m, $h, $md, $mo, $y, $wd, $yd, $is) = localtime(time);
    local($thismonth) = (Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec)[$mo];

    $s = "0".$s unless $s > 9;
    $m = "0".$m unless $m > 9;
    $h = "0".$h unless $h > 9;

    local($date) = sprintf("%3s %2d %2s:%2s:%2s", $thismonth,$md,$h,$m,$s);

    # Now we got a date let's open the logfile
    # If we cant try to open the errorlog or failing that write to the console

    if (!(open (LOG, ">>$LOGFILE{$log}")))  {
	if (!(open (LOG, ">>$LOGFILE{ERRLOG}"))) {
	    if (!(open (LOG, "+>/dev/console"))) {
		return;
	    }
	}
    }
    # 
    # So we assume we can write the string
    # Attempt to lock the log as well
    # 
    &appendlock(LOG);
    $date=~ s/\n*$//g;
    print LOG "$date $string\n";
    &unlock(LOG);
    close(LOG);
    return;
}
1;
