#
#	syslog - simplified syslog "type" routine.
#
#	$RCSfile: syslog.pl,v $
#	$Revision: 2.0 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 10:47:30 $
#
#	It allows you to write to various logfiles defined in general config
#	

require	"defines.pl";
require "misc.pl";

#
# use this routine for fatal errors
# it tries to log the problem in as many places as possible

sub fatalerror {

   # log in as many places as possible...

   local($error)="Fatal error: ".join("", @_)."\n";

   if (&syslog("ERRLOG", $error)) {
      
      print STDERR $error;
      
      if (open(CONSOLE, ">>/dev/console")) {
         &appendlock(CONSOLE);
         print CONSOLE $error;
         close(CONSOLE);
      }
   
   }
   
   exit 1;

}

sub syslog {
    local($log, $string) = @_;

    # Get the time

    local($s, $m, $h, $md, $mo, $y, $wd, $yd, $is) = localtime(time);
    local($thismonth) = (Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec)[$mo];

    $s = "0".$s unless $s > 9;
    $m = "0".$m unless $m > 9;
    $h = "0".$h unless $h > 9;

    local($date) = sprintf("%3s %2d %2s:%2s:%2s", $thismonth,$md,$h,$m,$s);

    #
    # Now we got a date let's open the logfile
    # If we cant try to open the errorlog or failing that write to the console

    if (!open(LOG, ">>".$LOGFILE{$log}))  {
	
	if (($log ne "ERRLOG") && (!open (LOG,">>".$LOGFILE{"ERRLOG"}))) {
	
	    if (!open (LOG, ">>/dev/console")) {
	       
	       print STDERR $date, " ", $string, "\n";
	       
	       return 0;
	       
	    }
	    
	}
	
    }
    
    # 
    # So we assume we can write the string
    # Attempt to lock the log as well
     
    &appendlock(LOG);
    # we want to use only one \n add the end of the line
    $string=~ s/\s+$//;
    print LOG $date, " ", $string, "\n";
    close(LOG);

    return 1;
    
}

1;
