#       nrofobj - count number of object in the RIPE database
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: nrofobj.pl,v 2.3 1997/10/02 15:26:01 chris Exp $
#
#	$RCSfile: nrofobj.pl,v $
#	$Revision: 2.3 $
#	$Author: chris $
#	$Date: 1997/10/02 15:26:01 $

#
# nrofobj /ncc/dbase/data/ripe/ripe.db.?? [date]
#
# is probably the most common use ;-)

require "rconf.pl";

local($conffile) = $ENV{"RIPEDBCNF"};
$conffile = $RIPEConfig{DEFCONFIG} unless $conffile;
&rconf($conffile);

$totalnrofobj=0;

if ((scalar(@ARGV)>1) && ($ARGV[$#ARGV]=~ /^\d\d[\d\.\:]+$/)) {
   $DATE=pop(@ARGV);
   print "\nNumber of objects in the RIPE database (".$DATE."):\n\n";
}
else {
   print "\nNumber of objects in the RIPE database ($DATE $TIME):\n\n";
}

while ($file=shift(@ARGV)) {
      
      if (($file=~ /\.(\S\S)\s*$/) &&
          ($OBJATSQ{$1})) {
         
         $type=$1;
         
         # print STDERR "type: $type\n";
         
         $nrofobj=`grep \\\*$type\\\: $file\|wc -l`;

         printf("Number of objects \'%-15s %7d\n", $ATTL{$type}."\':", $nrofobj);
               
         $totalnrofobj+=$nrofobj;
      
      }
}

printf("\nTotal number of objects: %17d\n\n", $totalnrofobj);
