# networkupdate.pl
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
# Copyright (c) 1998                              RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: networkupdate.pl,v 2.4 1998/07/15 18:01:34 joao Exp $
#
#	$RCSfile: networkupdate.pl,v $
#	$Revision: 2.4 $
#	$Author: joao $
#	$Date: 1998/07/15 18:01:34 $

# This is a very simple whois client, but it knows the new server arguments
# No support yet, use if you wish

require "getopts.pl";

&Getopts('h:p:');

if (@ARGV) {

    print <<"EOF";

Usage: networkupdate [-h hostname] [-p port]

where:

-h hostname           which server do we want to update
-p port               which port to connect to

Please note that most of these flags are NOT understood by
non RIPE whois servers
EOF
	exit(0);
}

# try to construct something that looks like an E-mail address
# for logging purposes... 


# find the log name of the user

local($logname)="";

if ($ENV{'USERNAME'}) {
   $logname=$ENV{'USERNAME'};
}
elsif ($ENV{'LOGNAME'}) {
   $logname=$ENV{'LOGNAME'};
}
elsif ($ENV{'USER'}) {
   $logname=$ENV{'USER'};
}
elsif ($ENV{'WHOAMI'}) {
   $logname=$ENV{'WHOAMI'};
} 
else {
   
   local(@others);
   
   ($logname,@others)=getpwuid($<);
   
} 

# try find the domain name of the current host

local($domainname)="";

if ($ENV{'LOCALDOMAIN'}) {
   $domainname=$ENV{'LOCALDOMAIN'};
}
elsif ($ENV{'DOMAIN'}) {
   $domainname=$ENV{'DOMAIN'};
}
elsif ($ENV{'HOST'}) {
   $domainname=$ENV{'HOST'};
}
elsif ($ENV{'HOSTNAME'}) {
   $domainname=$ENV{'HOSTNAME'};
}

$logname="nobody" if ($logname=~ /^\s*$/);
$domainname="localhost" if ($domainname=~ /^\s*$/);

# print STDERR $logname, "@", $domainname, "\n";

# and now we are ready to connect

# returning sockets doesn't work so we use the global one ;-(

local($msg);

if ($msg=&initwhoisqry($opt_h?$opt_h: $RIPEConfig{WHOISHOST},
                       $opt_p?$opt_p:"",
                       "-Vnp2.0 -U ".$logname." ".$domainname )) {
    
    print STDERR $msg;
    exit 1; 
                       
}                       



sub quitconnection {
   
    close(WHOIS_S);
    print "\nConnection closed.\n";
    
    exit;

}


local($child);

if (($child = fork()) == 0) {

   while ((-S WHOIS_S) && ($towhois=<STDIN>)) {
   
      # print STDERR "To whois: ", $towhois, "\n";
      
      print WHOIS_S $towhois;
   
      &quitconnection() if ($towhois=~ /^\s*\.\s*$/);
   
   }
   
   exit;
   
}

$SIG{'HUP'}='quitconnection';
$SIG{'INT'}='quitconnection';
$SIG{'KILL'}='quitconnection';
$SIG{'TERM'}='quitconnection';
   
while ((-S WHOIS_S) && ($fromwhois=<WHOIS_S>)) {
   
   # print STDERR "From whois: ", $fromwhois, "\n";
      
   print STDOUT $fromwhois;   
   
}

# end of program
