#       internicstats2inetnum - generate inetnum objects from the InterNIC
#                               statistics files
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997, 1998, 1999 by RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: internicstats2inetnums.pl,v 2.7 1999/10/06 16:41:12 marek Exp $
#
#
#	$RCSfile: internicstats2inetnums.pl,v $
#	$Revision: 2.7 $
#	$Author: marek $
#	$Date: 1999/10/06 16:41:12 $


require "defines.pl";
require "rconf.pl";
require "misc.pl";
require "net2net.pl";


local($conffile) = $ENV{"RIPEDBCNF"};
$conffile = $RIPEConfig{DEFCONFIG} unless $conffile;

&rconf($conffile);


local($value, $code, $day, $month);

local($remark)="
*rm: this network is assigned by the InterNIC
*rm: please query whois.internic.net for more information.
*ch: hostmaster\@internic.net ";

local($trailer)="
*ch: ripe-dbm\@ripe.net ".$DATE."
*so: INTERNIC\n";

&printrights(STDOUT);

my($line);

while ($line=<>) {
   

   while ($line =~ /IP-Network:(\d+\.\d+\.\d+\.\d+\/\d+)/) {
      
      ($value, $code)=&normalizerange($1, "in");
      
      push @value,$value if ($code==$O_OK);
     
      $line=<>;
   }

   if ($line =~ /Created\:(\d+)/i) {
         
#         $day=substr ($1,6,2);
#         $month=substr($1,4,2);
#	 $year=substr($1,2,2);
	$date=substr($1,0,8);
         
     foreach (@value) {
#       print STDOUT "\n*in: ", shift @value, $remark, $year, $month, $day, $trailer;
       print STDOUT "\n*in: ", shift @value, $remark, $date, $trailer;
     }

   }
      
}
