/***************************************
  $Revision: 2.3 $

  Error reporting (er) er.c - er_RX_errors.h - definition of errors for the 
                              error reporting module (used in test only).

  Status: NOT COMPLETE, NOT REVUED, NOT TESTED, 

  Design and implementation by: daniele@ripe.net

  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* I see no way of automating things here... Maybe with a perl script.

   There are three things to do:
   1. Get a new integer number from the enum 
	(using a ??_LOW_<mnem> symbol)
   2.  a new error code (??_<mnem>) by adding the facility and
	severity codes.
   3. put the symbol (using macro ERDUP) and text of the message into the
	array. Should fit in one line with the macro.

   The order of codes in enum does NOT have to match the order of texts.
   The last in the texts array must be the ER_LASTTXT constant.

   Sounds familiar ? That's because facilities and errors are parts
   of the error reporting fractal :-)
*/

/* use m4 macros to keep stuff in sync */




     /******************************************/
     /* ***** DEFINE THE CURRENT FACILITY **** */
     /* * make sure no whitespaces are inside! */
     /* */               /* */
     /* ************************************** */
     /******************************************/

/* last thing: disable processing of commented text (this allows to comment
   out some macro entries. Alas, the #%$@&* designers screwed up, so now we
   have to manually disable messing with C preprocessor commands */





typedef enum {
  /*  fac  code    sev  descr
      
      current facility specified inside the line below as CFAC
   */

   LOW_MM_OK ,
   LOW_MM_CANTOPEN ,
   LOW_MM_LINETOOLONG ,
   LOW_MM_INVMBX ,
   LOW_MM_WARNCCL ,
   LOW_MM_ERRCCL ,
   LOW_MM_FATCCL 
} MM_err_code_t;

/* paste the #define'd codes */
#define MM_OK  (ER_SEV_I + (FAC_MM<<16) + LOW_MM_OK)
#define MM_CANTOPEN  (ER_SEV_F + (FAC_MM<<16) + LOW_MM_CANTOPEN)
#define MM_LINETOOLONG  (ER_SEV_F + (FAC_MM<<16) + LOW_MM_LINETOOLONG)
#define MM_INVMBX  (ER_SEV_F + (FAC_MM<<16) + LOW_MM_INVMBX)
#define MM_WARNCCL  (ER_SEV_W + (FAC_MM<<16) + LOW_MM_WARNCCL)
#define MM_ERRCCL  (ER_SEV_E + (FAC_MM<<16) + LOW_MM_ERRCCL)
#define MM_FATCCL  (ER_SEV_F + (FAC_MM<<16) + LOW_MM_FATCCL)
 

#ifdef ER_IMPL
er_list_t MM_mod_err[]={

  /* paste the ERDUP's */
    { ERDUP(MM_OK),"OK" },
  { ERDUP(MM_CANTOPEN),"Cannot open file" },
  { ERDUP(MM_LINETOOLONG),"Line too long: line number" },
  { ERDUP(MM_INVMBX),"Invalid mailbox:" },
  { ERDUP(MM_WARNCCL),"Warning from c-client:" },
  { ERDUP(MM_ERRCCL),"Error from c-client:" },
  { ERDUP(MM_FATCCL),"Fatal error from c-client:" },
 
  
  ER_LASTTXT
};
#endif /* ER_IMPL */
