/***************************************
  $Revision: 1.5 $

  Error reporting (er) er_print.c - routines to print the currently registered
                                    paths and filters in a syntax compliant 
				    to the one of the interpreter.

  Status: NOT REVUED, PARTLY TESTED

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999,2000,2001,2002                   RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#include "rip.h"

/**************** PRINTING PATHS ********************************************/
static
void er_print_format(int format, GString *g_reply )
{
  int i;

  for(i=0;  er_formarr[i].n != NULL; i++) {
    if( format & er_formarr[i].v ) {
      g_string_sprintfa(g_reply, "%s|",er_formarr[i].n);
    }
  }
  /* cut the last "|" */
  g_string_truncate(g_reply, (int) strlen(g_reply->str)-1);
}


static
void er_print_one_path_descr(er_path_t *pathptr, GString *g_reply )
{
  er_path_descr_t *d = &(pathptr->descr);

  switch(pathptr->type) {
  case  ER_PATH_NAME:
    g_string_sprintfa(g_reply, "NAME %s%s", d->name.filename, 
		      d->name.date ? " DATE" : ""
		      );
    break;
  case  ER_PATH_SOCK:
    g_string_sprintfa(g_reply, "SOCK %d", d->sock.fd );

    break;

  case  ER_PATH_EXEC:
    g_string_sprintfa(g_reply, "EXEC ");
    if( d->exec.usepath ) {
      g_string_sprintfa(g_reply, "PATH ");
    }
    {
      char **argv = d->exec.argv;
      int len=0;
  
      if( argv != NULL ) {
	while( argv[len] != NULL ) {
	  g_string_sprintfa(g_reply, "%s ", argv[len]);
	  len++;
	}
      }
    }
    break;

  default:
    /* XXX other path descriptions missing */
    break;
  }
}

static
void er_print_aspmask(mask_t facmask, unsigned aspmask, GString *g_reply)
{
  int i = 31;

  while(i >= 0) {
    if( aspmask & (1<<i) ) {
      er_getaspsym(facmask, 1<<i, g_reply);
      g_string_append(g_reply, "|");
    }
    
    i--;
  }
  /* cut the last "|" */
  g_string_truncate(g_reply, (int) strlen(g_reply->str)-1);
}

static
void er_print_facmask(mask_t facmask, GString *g_reply)
{
  int i = FAC_NONE;
  
  while( ++i != FAC_LAST ) {
    if( MA_isset(facmask, er_fac_err[i].code) ) {
      g_string_sprintfa(g_reply, "%s|", er_fac_err[i].name);
    }
  }
  /* cut the last "|" */
  g_string_truncate(g_reply, (int) strlen(g_reply->str)-1);

}

static
void er_print_one_filter(er_filter_t *filtptr, GString *g_reply )
{ 
  g_string_sprintfa(g_reply, "( FAC ");
  er_print_facmask( filtptr->fac_mask, g_reply);
  
  if( filtptr->asp_mask != 0 ) {
    g_string_sprintfa(g_reply, "  ASP ");
    er_print_aspmask(  filtptr->fac_mask, filtptr->asp_mask, g_reply);
  }

  g_string_sprintfa(g_reply, "  SEV %s-%s ",
		    er_getsevsym( filtptr->sev_min, ER_M_SEVCHAR),
		    er_getsevsym( filtptr->sev_max, ER_M_SEVCHAR)
		    );
  if( filtptr->thr_id != 0 ) {
    g_string_sprintfa(g_reply, "   THR %lu ", (long unsigned)filtptr->thr_id);
  }
  g_string_sprintfa(g_reply, " )" );
}

static
void er_print_one_path(er_path_t *pathptr, GString *g_reply )
{
  GList   *qitem;
  int f=1;
  
  g_string_sprintfa(g_reply,"%s { ", pathptr->name );
  g_string_sprintfa(g_reply," FORMAT ");
  er_print_format(pathptr->format, g_reply ); 
  g_string_sprintfa(g_reply,"  ");

  er_print_one_path_descr(pathptr, g_reply);
  g_string_sprintfa(g_reply," }\n");

  for(qitem = g_list_first(pathptr->filters);
      qitem != NULL;
      qitem = g_list_next(qitem)) {
    er_filter_t *filtptr = (er_filter_t *) qitem -> data;
    
    g_string_sprintfa(g_reply,"\t");
    er_print_one_filter(filtptr, g_reply) ;
    g_string_sprintfa(g_reply,"\n");
    f++;
  }

}

void er_print_paths(char **retbuf)
{
  GList   *qitem;
  GString *g_reply = g_string_sized_new(2048); /* initial size */

  for( qitem = g_list_first(er_pathlist);
       qitem != NULL;
       qitem = g_list_next(qitem)) {
    er_path_t *pathptr = qitem -> data;

    /*   g_string_sprintfa(g_reply, "path type %d (%s) with %d filters\n",
	   pathptr->type, er_pathtypes[pathptr->type],
	   g_list_length(pathptr->filters));
    */
    er_print_one_path(pathptr, g_reply);

  }

  *retbuf = g_reply->str;  

  g_string_free( g_reply, /* CONSTCOND */ FALSE);
}
