/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CDATASectionImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CommentImpl;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DocumentFragmentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeIteratorImpl;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.dom.ProcessingInstructionImpl;
import org.apache.xerces.dom.RangeImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.dom.TreeWalkerImpl;
import org.apache.xerces.dom.events.EventImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class DocumentImpl
extends ParentNode
implements Document,
DocumentTraversal,
DocumentEvent,
DocumentRange {
    static final long serialVersionUID = 515687835542616694L;
    protected DocumentTypeImpl docType;
    protected ElementImpl docElement;
    protected String encoding;
    protected String version;
    protected boolean standalone;
    protected Hashtable identifiers;
    protected Vector iterators;
    protected Vector ranges;
    protected static int[] kidOK = new int[13];
    protected Hashtable userData;
    protected Hashtable eventListeners;
    protected int changes = 0;
    protected boolean allowGrammarAccess;
    protected boolean errorChecking = true;
    protected boolean mutationEvents = false;

    static {
        DocumentImpl.kidOK[9] = 1410;
        DocumentImpl.kidOK[1] = 442;
        DocumentImpl.kidOK[5] = 442;
        DocumentImpl.kidOK[6] = 442;
        DocumentImpl.kidOK[11] = 442;
        DocumentImpl.kidOK[2] = 40;
        DocumentImpl.kidOK[12] = 0;
        DocumentImpl.kidOK[4] = 0;
        DocumentImpl.kidOK[3] = 0;
        DocumentImpl.kidOK[8] = 0;
        DocumentImpl.kidOK[7] = 0;
        DocumentImpl.kidOK[10] = 0;
    }

    public DocumentImpl() {
        this(false);
        XMLCharacterProperties.initCharFlags();
    }

    public DocumentImpl(DocumentType documentType) {
        this(documentType, false);
        XMLCharacterProperties.initCharFlags();
    }

    public DocumentImpl(DocumentType documentType, boolean bl) {
        this(bl);
        if (documentType != null) {
            try {
                DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)documentType;
            }
            catch (ClassCastException classCastException) {
                throw new DOMException(4, "DOM005 Wrong document");
            }
            documentTypeImpl.ownerDocument = this;
            this.appendChild(documentType);
        }
        XMLCharacterProperties.initCharFlags();
    }

    public DocumentImpl(boolean bl) {
        super(null);
        this.ownerDocument = this;
        this.allowGrammarAccess = bl;
        XMLCharacterProperties.initCharFlags();
    }

    public Node adoptNode(Node node) {
        NodeImpl nodeImpl;
        try {
            nodeImpl = (NodeImpl)node;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        switch (nodeImpl.getNodeType()) {
            case 2: {
                AttrImpl attrImpl = (AttrImpl)nodeImpl;
                attrImpl.getOwnerElement().removeAttributeNode(attrImpl);
                attrImpl.isSpecified(true);
                attrImpl.setOwnerDocument(this);
                break;
            }
            case 9: 
            case 10: {
                throw new DOMException(9, "cannot adopt this type of node.");
            }
            case 5: {
                NamedNodeMap namedNodeMap;
                Node node2;
                Node node3;
                Node node4 = nodeImpl.getParentNode();
                if (node4 != null) {
                    node4.removeChild(node);
                }
                while ((node3 = nodeImpl.getFirstChild()) != null) {
                    nodeImpl.removeChild(node3);
                }
                nodeImpl.setOwnerDocument(this);
                if (this.docType == null || (node2 = (namedNodeMap = this.docType.getEntities()).getNamedItem(nodeImpl.getNodeName())) == null) break;
                EntityImpl entityImpl = (EntityImpl)node2;
                node3 = node2.getFirstChild();
                while (node3 != null) {
                    Node node5 = node3.cloneNode(true);
                    nodeImpl.appendChild(node5);
                    node3 = node3.getNextSibling();
                }
                break;
            }
            case 1: {
                Node node6 = nodeImpl.getParentNode();
                if (node6 != null) {
                    node6.removeChild(node);
                }
                nodeImpl.setOwnerDocument(this);
                ((ElementImpl)nodeImpl).reconcileDefaultAttributes();
                break;
            }
            default: {
                Node node7 = nodeImpl.getParentNode();
                if (node7 != null) {
                    node7.removeChild(node);
                }
                nodeImpl.setOwnerDocument(this);
            }
        }
        return nodeImpl;
    }

    protected void changed() {
        ++this.changes;
    }

    protected int changes() {
        return this.changes;
    }

    public Object clone() throws CloneNotSupportedException {
        DocumentImpl documentImpl = (DocumentImpl)super.clone();
        documentImpl.docType = null;
        documentImpl.docElement = null;
        return documentImpl;
    }

    public Node cloneNode(boolean bl) {
        DocumentImpl documentImpl = new DocumentImpl();
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (bl) {
            Object object;
            Hashtable hashtable = null;
            if (this.identifiers != null) {
                hashtable = new Hashtable();
                object = this.identifiers.keys();
                while (object.hasMoreElements()) {
                    Object e = object.nextElement();
                    hashtable.put(this.identifiers.get(e), e);
                }
            }
            object = this.firstChild;
            while (object != null) {
                documentImpl.appendChild(documentImpl.importNode((Node)object, true, hashtable));
                object = ((ChildNode)object).nextSibling;
            }
        }
        documentImpl.allowGrammarAccess = this.allowGrammarAccess;
        documentImpl.errorChecking = this.errorChecking;
        documentImpl.mutationEvents = this.mutationEvents;
        return documentImpl;
    }

    public Attr createAttribute(String string) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new AttrImpl(this, string);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string2)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new AttrNSImpl(this, string, string2);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    public Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new DocumentTypeImpl(this, string, string2, string3);
    }

    public Element createElement(String string) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ElementImpl(this, string);
    }

    public ElementDefinitionImpl createElementDefinition(String string) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ElementDefinitionImpl(this, string);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string2)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ElementNSImpl(this, string, string2);
    }

    public Entity createEntity(String string) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new EntityImpl(this, string);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new EntityReferenceImpl(this, string);
    }

    public Event createEvent(String string) throws DOMException {
        if (string.equalsIgnoreCase("Events") || "Event".equals(string)) {
            return new EventImpl();
        }
        if (string.equalsIgnoreCase("MutationEvents") || "MutationEvent".equals(string)) {
            return new MutationEventImpl();
        }
        throw new DOMException(9, "DOM007 Not supported");
    }

    public NodeIterator createNodeIterator(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        NodeIteratorImpl nodeIteratorImpl = new NodeIteratorImpl(this, node, n, nodeFilter, bl);
        if (this.iterators == null) {
            this.iterators = new Vector();
        }
        this.iterators.addElement(nodeIteratorImpl);
        return nodeIteratorImpl;
    }

    public NodeIterator createNodeIterator(Node node, short s, NodeFilter nodeFilter) {
        return this.createNodeIterator(node, s, nodeFilter, true);
    }

    public Notation createNotation(String string) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new NotationImpl(this, string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public Range createRange() {
        if (this.ranges == null) {
            this.ranges = new Vector();
        }
        RangeImpl rangeImpl = new RangeImpl(this);
        this.ranges.addElement(rangeImpl);
        return rangeImpl;
    }

    public Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    public TreeWalker createTreeWalker(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        if (node == null) {
            throw new DOMException(9, "DOM007 Not supported");
        }
        return new TreeWalkerImpl(node, n, nodeFilter, bl);
    }

    public TreeWalker createTreeWalker(Node node, short s, NodeFilter nodeFilter) {
        return this.createTreeWalker(node, s, nodeFilter, true);
    }

    void deletedText(Node node, int n, int n2) {
        if (this.ranges != null) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).receiveDeletedText(node, n, n2);
            }
        }
    }

    public DocumentType getDoctype() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    public Element getDocumentElement() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    public Element getElementById(String string) {
        return this.getIdentifier(string);
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new DeepNodeListImpl(this, string, string2);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean getErrorChecking() {
        return this.errorChecking;
    }

    protected Vector getEventListeners(NodeImpl nodeImpl) {
        if (this.eventListeners == null) {
            return null;
        }
        return (Vector)this.eventListeners.get(nodeImpl);
    }

    public Element getIdentifier(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return null;
        }
        return (Element)this.identifiers.get(string);
    }

    public Enumeration getIdentifiers() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        return this.identifiers.keys();
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public boolean getMutationEvents() {
        return this.mutationEvents;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public final Document getOwnerDocument() {
        return null;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public boolean getStrictErrorChecking() {
        return this.errorChecking;
    }

    protected Object getUserData(NodeImpl nodeImpl) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(nodeImpl);
    }

    public String getVersion() {
        return this.version;
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        return this.importNode(node, bl, null);
    }

    private Node importNode(Node node, boolean bl, Hashtable hashtable) throws DOMException {
        Node node2;
        Object object = null;
        DOMImplementation dOMImplementation = node.getOwnerDocument().getImplementation();
        boolean bl2 = dOMImplementation.hasFeature("XML", "2.0");
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                Object v;
                node2 = !bl2 || node.getLocalName() == null ? this.createElement(node.getNodeName()) : this.createElementNS(node.getNamespaceURI(), node.getNodeName());
                Object object2 = node.getAttributes();
                if (object2 != null) {
                    int n = object2.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        Attr attr = (Attr)object2.item(n2);
                        if (attr.getSpecified()) {
                            Attr attr2 = (Attr)this.importNode(attr, true, hashtable);
                            if (!bl2 || attr.getLocalName() == null) {
                                node2.setAttributeNode(attr2);
                            } else {
                                node2.setAttributeNodeNS(attr2);
                            }
                        }
                        ++n2;
                    }
                }
                if (hashtable != null && (v = hashtable.get(node)) != null) {
                    if (this.identifiers == null) {
                        this.identifiers = new Hashtable();
                    }
                    this.identifiers.put(v, node2);
                }
                object = node2;
                break;
            }
            case 2: {
                Object object2;
                object = bl2 ? (node.getLocalName() == null ? this.createAttribute(node.getNodeName()) : this.createAttributeNS(node.getNamespaceURI(), node.getNodeName())) : this.createAttribute(node.getNodeName());
                if (node instanceof AttrImpl) {
                    node2 = (AttrImpl)node;
                    if (((NodeImpl)node2).hasStringValue()) {
                        object2 = (AttrImpl)object;
                        ((AttrImpl)object2).setValue(((AttrImpl)node2).getValue());
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                if (node.getFirstChild() == null) {
                    object.setNodeValue(node.getNodeValue());
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 3: {
                object = this.createTextNode(node.getNodeValue());
                break;
            }
            case 4: {
                object = this.createCDATASection(node.getNodeValue());
                break;
            }
            case 5: {
                object = this.createEntityReference(node.getNodeName());
                ((EntityReferenceImpl)object).isReadOnly(false);
                break;
            }
            case 6: {
                node2 = (Entity)node;
                Object object2 = (EntityImpl)this.createEntity(node.getNodeName());
                ((EntityImpl)object2).setPublicId(node2.getPublicId());
                ((EntityImpl)object2).setSystemId(node2.getSystemId());
                ((EntityImpl)object2).setNotationName(node2.getNotationName());
                ((NodeImpl)object2).isReadOnly(false);
                object = object2;
                break;
            }
            case 7: {
                object = this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                object = this.createComment(node.getNodeValue());
                break;
            }
            case 10: {
                int n;
                node2 = (DocumentType)node;
                Object object2 = (DocumentTypeImpl)this.createDocumentType(node2.getNodeName(), node2.getPublicId(), node2.getSystemId());
                NamedNodeMap namedNodeMap = node2.getEntities();
                NamedNodeMap namedNodeMap2 = ((DocumentTypeImpl)object2).getEntities();
                if (namedNodeMap != null) {
                    n = 0;
                    while (n < namedNodeMap.getLength()) {
                        namedNodeMap2.setNamedItem(this.importNode(namedNodeMap.item(n), true, hashtable));
                        ++n;
                    }
                }
                namedNodeMap = node2.getNotations();
                namedNodeMap2 = ((DocumentTypeImpl)object2).getNotations();
                if (namedNodeMap != null) {
                    n = 0;
                    while (n < namedNodeMap.getLength()) {
                        namedNodeMap2.setNamedItem(this.importNode(namedNodeMap.item(n), true, hashtable));
                        ++n;
                    }
                }
                object = object2;
                break;
            }
            case 11: {
                object = this.createDocumentFragment();
                break;
            }
            case 12: {
                node2 = (Notation)node;
                Object object2 = (NotationImpl)this.createNotation(node.getNodeName());
                ((NotationImpl)object2).setPublicId(node2.getPublicId());
                ((NotationImpl)object2).setSystemId(node2.getSystemId());
                object = object2;
                break;
            }
            default: {
                throw new DOMException(9, "Node type being imported is not supported");
            }
        }
        if (bl) {
            node2 = node.getFirstChild();
            while (node2 != null) {
                object.appendChild(this.importNode(node2, true, hashtable));
                node2 = node2.getNextSibling();
            }
        }
        if (object.getNodeType() == 5 || object.getNodeType() == 6) {
            ((NodeImpl)object).setReadOnly(true, true);
        }
        return object;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        short s = node.getNodeType();
        if (this.errorChecking && (s == 1 && this.docElement != null || s == 10 && this.docType != null)) {
            throw new DOMException(3, "DOM006 Hierarchy request error");
        }
        super.insertBefore(node, node2);
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node;
    }

    void insertedText(Node node, int n, int n2) {
        if (this.ranges != null) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).receiveInsertedText(node, n, n2);
            }
        }
    }

    protected boolean isKidOK(Node node, Node node2) {
        if (this.allowGrammarAccess && node.getNodeType() == 10) {
            return node2.getNodeType() == 1;
        }
        return (kidOK[node.getNodeType()] & 1 << node2.getNodeType()) != 0;
    }

    public static boolean isXMLName(String string) {
        if (string == null) {
            return false;
        }
        return XMLCharacterProperties.validName(string);
    }

    public void putIdentifier(String string, Element element) {
        if (element == null) {
            this.removeIdentifier(string);
            return;
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(string, element);
    }

    public Node removeChild(Node node) throws DOMException {
        super.removeChild(node);
        short s = node.getNodeType();
        if (s == 1) {
            this.docElement = null;
        } else if (s == 10) {
            this.docType = null;
        }
        return node;
    }

    public void removeIdentifier(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return;
        }
        this.identifiers.remove(string);
    }

    void removeNodeIterator(NodeIterator nodeIterator) {
        if (nodeIterator == null) {
            return;
        }
        if (this.iterators == null) {
            return;
        }
        this.iterators.removeElement(nodeIterator);
    }

    void removeRange(Range range) {
        if (range == null) {
            return;
        }
        if (this.ranges == null) {
            return;
        }
        this.ranges.removeElement(range);
    }

    void removedChildNode(Node node) {
        Enumeration enumeration;
        if (this.iterators != null) {
            enumeration = this.iterators.elements();
            while (enumeration.hasMoreElements()) {
                ((NodeIteratorImpl)enumeration.nextElement()).removeNode(node);
            }
        }
        if (this.ranges != null) {
            enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).removeNode(node);
            }
        }
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        super.replaceChild(node, node2);
        short s = node2.getNodeType();
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node2;
    }

    void replacedText(Node node) {
        if (this.ranges != null) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).receiveReplacedText(node);
            }
        }
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setErrorChecking(boolean bl) {
        this.errorChecking = bl;
    }

    protected void setEventListeners(NodeImpl nodeImpl, Vector vector) {
        if (this.eventListeners == null) {
            this.eventListeners = new Hashtable();
        }
        if (vector == null) {
            this.eventListeners.remove(nodeImpl);
            if (this.eventListeners.isEmpty()) {
                this.mutationEvents = false;
            }
        } else {
            this.eventListeners.put(nodeImpl, vector);
            this.mutationEvents = true;
        }
    }

    public void setMutationEvents(boolean bl) {
        this.mutationEvents = bl;
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
    }

    public void setStrictErrorChecking(boolean bl) {
        this.errorChecking = bl;
    }

    protected void setUserData(NodeImpl nodeImpl, Object object) {
        if (this.userData == null) {
            this.userData = new Hashtable();
        }
        if (object == null) {
            this.userData.remove(nodeImpl);
        } else {
            this.userData.put(nodeImpl, object);
        }
    }

    public void setVersion(String string) {
        this.version = string;
    }

    void splitData(Node node, Node node2, int n) {
        if (this.ranges != null) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).receiveSplitData(node, node2, n);
            }
        }
    }
}

