/*
 * ppp_dial.c - Dialup support for Streams PPP.
 *
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 *
 */
#if NDP > 0

#include "dp.h"

#define	DEBUGS	1

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stream.h>
#include <sys/stropts.h>

#include <sys/user.h>
#include <sys/systm.h>
#include <sys/mbuf.h>
#include <sys/socket.h>
#include <sys/errno.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <sys/uio.h>
#include <net/if.h>
#include <net/netisr.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>

#ifdef DEBUGS
#include <sys/syslog.h>
#endif DEBUGS

#ifdef LOADABLE
#include <sys/conf.h>
#include <sys/buf.h>
#include <sundev/mbvar.h>
#include <sun/autoconf.h>
#include <sun/vddrv.h>
#ifdef VJC
#include "slcompress.h"
#endif VJC
#include "if_ppp.h"
#include "dp_str.h"
#else !LOADABLE
#ifdef VJC
#include <net/slcompress.h>
#endif VJC
#include <sys/if_ppp.h>
#include <sys/dp_str.h>
#endif LOADABLE

/*
 * This code implements the streams device for communicating connect requests
 * to user-land.
 */
#undef	DLOG
#ifdef	DEBUGS
#define	DLOG(s,a)	if(ppp_dial_debug) log(LOG_INFO, s, a)
int	ppp_dial_debug=0;
#else
#define	DLOG(s,a)	{}
#endif

int ppp_dial_open(), ppp_dial_close();

static int ppp_dial_rsrv(), ppp_dial_wput();

static struct module_info ppp_dial_minfo = {
    0xbae,"pppdial",0, INFPSZ, DP_HIWAT, DP_LOWAT
};

static struct qinit ppp_dial_rinit = {
    NULL, ppp_dial_rsrv, ppp_dial_open, ppp_dial_close, NULL,
    &ppp_dial_minfo, NULL
};

static struct qinit ppp_dial_winit = {
    ppp_dial_wput, NULL, NULL, NULL, NULL,
    &ppp_dial_minfo, NULL
};
struct streamtab ppp_dialinfo = {
    &ppp_dial_rinit, &ppp_dial_winit, NULL, NULL, NULL
};

static queue_t *req_q;
static struct fmodsw *fmod_ppp_dial;

struct cdevsw ppp_cdevsw = {
 	0, 0, 0, 0, 0, 0, 0, 0, &ppp_dialinfo, 0
};

static struct vdldrv ppp_dial_vd = {
	VDMAGIC_PSEUDO,
	"Dialup PPP Interface",
#if	defined(sun4c) || defined(sun4m)
	NULL,
#else
	(struct mb_ctlr *)NULL,
	(struct mb_driver *)NULL,
	(struct mb_device *)NULL,
	NULL,
	NULL,
#endif
	NULL,
	&ppp_cdevsw,
	0,
	0,
};

#define	LOG_INUSE	1
static struct log { 
	char flags;
	char nr;
} ppp_dial_log[NDP];

int
ppp_dial_open(q, dev, flag, sflag)
queue_t	*q;
dev_t	dev;
int	flag,
	sflag;
{
    if (!suser()) {
	u.u_error = EPERM;
	return(OPENFAIL);
    }
    /*
     * Insure this is a normal driver open..
     */
    if (sflag)
	return (OPENFAIL);

    /*
     * Insure exclusive access.
     */
    if (q->q_ptr) {
	u.u_error = EBUSY;
	return(OPENFAIL);
    }

    q->q_ptr = "ppp daemon running";
    req_q = q;
    DLOG("ppp_dial%d: open\n", minor(dev));
    return dev;
}

int
ppp_dial_close(q)
queue_t	*q;			/* queue info */
{
    req_q = (queue_t *)0;
    q->q_ptr = (char *)0;
    DLOG("ppp_dial: close\n", 0);
    return 0;
}

static int
ppp_dial_wput(q, mp)
queue_t  *q;
register mblk_t *mp;
{
    switch (mp->b_datap->db_type) {
     case  M_FLUSH:
	if (*mp->b_rptr & FLUSHW)
	    flushq(q, FLUSHDATA);
	if (*mp->b_rptr & FLUSHR) {
	    flushq(RD(q), FLUSHDATA);
	    *mp->b_rptr &= ~FLUSHW;
	    qreply(q, mp);
	}
	else 
	    freemsg(mp);
	break;
     case M_DATA:
     case M_IOCTL:
     default:
	/*
	 * For now, do nothing with stuff written to the stream.
	 * Later on, support returning status of dial
	 * operations.
	 */
	freemsg(mp);
	break;
    }

}

static int
ppp_dial_rsrv(q)
queue_t *q;
{
    register mblk_t *mp;

    while ((mp = getq(q)) != NULL) {
	switch (mp->b_datap->db_type) {
	 case M_FLUSH:
	    if(*mp->b_rptr & FLUSHR)
		flushq(q, FLUSHDATA);
	    DLOG("ppp_dial_rsrv: M_FLUSH\n", 0);
	    putnext(q, mp);		/* send it along too */
	    break;
	 case M_DATA:
	    if (!canput(q->q_next)) {
#define	DISCARD_OLDEST
#ifdef	DISCARD_OLDEST
		register mblk_t *omp;
		/*
		 * Throw away something..
		 */
		omp = getq(q->q_next);
		freemsg(omp);
#endif
#ifdef	DISCARD_NEWEST
		freemsg(mp);
		break;
#endif
	    }
	    /*
	     * Just send this along..
	     */
	 default:
	    DLOG("ppp_dial_rsrv: M_DATA\n", 0);
	    putnext(q, mp);
	}
    }
}

duipreq(m0, dst, ifp, checkit)
struct mbuf *m0;
struct sockaddr *dst;
struct ifnet *ifp;
int checkit;
{
    register mblk_t *mp;
    struct dp_req *req;
    struct mbuf *m;
    int s;
    int i;
    int len;
    queue_t *q;

    /*
     * If no program is accepting requests, return immediate failure.
     */
    if (!(q = req_q))
	return -1;
    /*
     * Check how much header we have and arrange to send at least
     * DR_MINHDRLEN but not more than DR_MAXHDRLEN to the program
     * handling calls (dpd).
     */
    for (len = 0, m = m0 ; m && len <= DR_MAXHDRLEN ; m = m->m_next)
	len += m->m_len;
    if (len < DR_MINHDRLEN)
	return -1;
    if (len > DR_MAXHDRLEN)
	len = DR_MAXHDRLEN;

    /*
     * Allocate the appropriate stream data structure for this request.
     */
    s = splstr();
    mp = allocb(sizeof(struct dp_reqinfo) + len, BPRI_MED);
    if (!mp) {
	splx(s);
	return -1;
    }

    /*
     * Fill in the request info.
     */
    req = (struct dp_req *)mp->b_wptr;
    mp->b_wptr += sizeof (struct dp_reqinfo);
    for (i = 0 ; i < sizeof(req->dr_ifname) ; i++)
	if (!(req->dr_ifname[i] = ifp->if_name[i]))
	    break;
    for ( i++ ; i < sizeof(req->dr_ifname) ; i++)
	req->dr_ifname[i] = '\0';
    req->dr_ifunit = ifp->if_unit;
    req->dr_flag = checkit ? DP_REQ_CHECKIT : 0;
    bcopy(dst, &req->dr_sin, sizeof(struct sockaddr_in));
    req->dr_hdrlen = len;
    /*
     * Copy the header data, in chunks if necessary.
     */
    for (m = m0 ; len > 0 && m ; m = m->m_next) {
	i = MIN(len, m->m_len);
	bcopy(mtod(m, char *), mp->b_wptr, i);
	len -= i;
	mp->b_wptr += i;
    }
    /*
     * Send this stream stuff to the program.
     */
    putq(q, mp);
    splx(s);
    DLOG("duipreq\n", 0);
    return 0;
}

ppp_dial_init(fc,vdp,vdi,vds)
unsigned int fc;
struct vddrv *vdp;
addr_t vdi;
struct vdstat *vds;
{
	register int i;
	switch(fc) {
		case VDLOAD:
		{
			for(i=0; i < fmodcnt; i++) {
				if(fmodsw[i].f_str == NULL)
					break;
			}
			if(i == fmodcnt)
				return(ENODEV);
			fmod_ppp_dial = &fmodsw[i];
			fmod_ppp_dial->f_str = &ppp_dialinfo;
			bcopy(ppp_dial_minfo.mi_idname, fmod_ppp_dial->f_name, FMNAMESZ);
			vdp->vdd_vdtab = (struct vdlinkage *) &ppp_dial_vd;
			return 0;
		}
		case VDUNLOAD:
		{
			for (i = 0; i < NDP; i++) 
				if (ppp_dial_log[i].flags & LOG_INUSE)
					return (EIO);
			fmod_ppp_dial->f_name[0] = '\0';
			fmod_ppp_dial->f_str = NULL;
			return 0;
		}
		case VDSTAT:
			return 0;
		default:
			return EIO;
	}
}

#endif /* NDP > 0 */

