/*
**  Dialup IP header file.
**
**  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
**  All rights reserved.
**
**  Redistribution and use in source and binary forms are permitted
**  provided that: (1) source distributions retain this entire copyright
**  notice and comment, and (2) distributions including binaries display
**  the following acknowledgement:  ``This product includes software
**  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
**  documentation or other materials provided with the distribution and in
**  all advertising materials mentioning features or use of this software.
**  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
**  to endorse or promote products derived from this software without
**  specific prior written permission.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
**  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/
/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */


/*
 * Files in $DPCONF_DIR (/etc/dp)
 */
#define DP_CONFIG		"conf"

/*
 * Files in $DPLOG_DIR (/var/adm/dp)
 */
#define CALL_LOG		"call.log"
#define LOG_FILE		"dp.log"
#define TRACE_FILE		"req.trace"

/*
 * Files in $DPBIN_DIR (/usr/dp/bin)
 */
#define	PPP_PROG		"dp"

char *expand_path(),
     *expand_dir_file(),
     *expand_dirs_file();

/*
 * Other system files
 */
#define	DEVDIAL			"/dev/dp0"


/*
**  How often to log line as up, in minutes.
*/
#define UPTIME_INTERVAL		5


/*
**  Get or set data from the interface.
*/
#ifdef	sun
#define GETDATAVAL(ifr)		(*(int *)ifr.ifr_data)
#define SETDATAVAL(ifr, i)	(*(int *)(ifr).ifr_data = (i))
#else
#define GETDATAVAL(ifr)		((int)ifr.ifr_data)
#define SETDATAVAL(ifr, i)	((ifr).ifr_data = (caddr_t)(i))
#endif	/* sun */


/*
**  Logging levels.
*/
#define DLOG_GENERAL		0	/* Routine log messages		*/
#define DLOG_INFO		1	/* Informational messages	*/
#define DLOG_DIAG		2	/* Diagnostic messages		*/
#define DLOG_ALL		3	/* Verbose			*/


/*
**  Logging variables and functions.
*/
extern int	log_level;		/* Current logging level	*/
extern char	*progname;		/* Program name			*/
extern void	d_log();		/* Write a log entry		*/
extern char	*dp_release();		/* Release string		*/
