/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The benchmark control protocol
 */

#ifdef DNIX
#include <ethman.h>
#endif DNIX

typedef struct {
    int		ba_addr;	/* see below */
    long	ba_index;	/* for BA_CLIENT, BA_SERVER & BA_SYSTEM
				   addresses */
} bcpaddr_t;

/*
 * BCP addresses
 * The index when a single process is specified is the index into
 * the procs set by bcp_set_local_procs()
 */
#define BA_BENCH	0x1		/* controlling process */
#define BA_CLIENTS	0x2		/* all processes */
#define BA_CLIENT	0x4		/* a single process */
#define BA_SERVERS 	0x20
#define BA_SERVER	0x40
#define BA_SYSTEMS	0x100		/* all systems */
#define BA_SYSTEM	0x200

#define BA_ALL		(BA_CLIENTS | BA_SERVERS)

#define BA_ANY		(BA_BENCH | BA_CLIENT | BA_SERVER | BA_SYSTEM)

#define BA_STAR		(BA_ALL | BA_ANY)

#define BA_FORWARDER	(BA_BENCH | BA_SYSTEM)	/* only these forward messages */

/*  */

/*
 * An ipc message
 * Data is represented according to the presentation protocol which
 * may be different for different message codes.
 */
typedef struct {
    bcpaddr_t	msg_to,
    		msg_from;
    int		msg_code;	/* See below */
    int		msg_datalen;
    char 	*msg_data;
} msg_t;


/*
 * Message codes
 * Only the second group (SPEC thru FAILURE) have data fields. The other
 * can have a null-terminated ascii string as data. This string will
 * contain some internal diagnostic information for debugging.
 */
#define MSG_NOTOK	-1
#define MSG_OK		0

#define MSG_CREATE	1

#define MSG_SPEC	5	/* data is a benchmark specification */
#define MSG_ADDR	6	/* data is one server address */

#define MSG_FAILURE	9	/* data is a diagnosis string */

#define MSG_TIMEOUT	10	/* await_recv timed out */
#define MSG_ALARM	15	/* signal-pseudo message - SIGALRM */


#define MSG_PROERROR	20	/* BCP protocol error */
#define MSG_FATAL	21	/* fatal error - SIGKILL */

#define MSG_START	40	/* start running the benchmarks */
#define MSG_STARTED	41	/* the sender has stated executing the bm */
#define MSG_STOP	42
#define MSG_STOPPED	43	/* the sender has stopped running the bm */

#define MSG_ABORT	50	/* abort benchmark execution (due to failure)*/
#define MSG_ABORTED	51
#define MSG_TERMINATE	52	/* stop execution due to expired timelimit */
#define MSG_TERMINATED	53

#define MSG_DESTROY	60	/* child processes terminates, parents reset */
#define MSG_RESET	61	/* reset parent and child processes */

#define MSG_CLOSED	70	/* the channel from msg_from has closed. */
#define MSG_CLOSE	71	/* Sending this closes the msg_to channel(s) */
#define MSG_INTERNAL_CLOSED 72

#define MSG_TIMEQ	80	/* ask for local time */
#define MSG_TIME	81	/* followed by "<sec> <usec>" since epoch */

#define SYSTEM_CODE(code)	((code) == MSG_CREATE \
				 || (code) == MSG_DESTROY \
				 || (code) == MSG_TIMEQ)

/*  */

typedef struct {
    int		c_pid;		/* process id */
    int		c_pgrp;
    int		c_read;	/* control read end */
    int		c_write;	/* procedure write end */
} commstate_t;

#define NULLC (commstate_t *)NULL

/*  */
    
/*
 * Exported:
 * 	ipc.c
 */
int	bcp_init();
int	send_msg();
int	bcp_send_msg();
int	await_recv_msg();
int	bcp_await_recv_msg();
char	*code2str();
char	*bcpaddr2str();
int	printmyname();
int	printmynameerr();
int	reset_myaddr();
bcpaddr_t	get_myaddr();
/*
 * 	ipc_remote.c
 */
int	hostname2addr();
int	host_add_connect();
int	host_close_all();
int	host_mask();
int	*host_mask2sock();
bcpaddr_t	host_mask2addr();
int	host_clearclockdiff();
int	host_getclockdiff();
double	host_clockdiff();
int	*host_lookup();
int	host_namelookup();
int	host_enter();
int	host_remove();
/*
 * 	ipc_route.c
 */
int	route_enter();
int	route_remove();
int	route_remove_dest();
int	route_remove_all();
int	route_lookup();
int	route_multicast_lookup();





