/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The Message Control Protocol - delivery using signals
 */

/*
 * Signals used when (true) asynchroneous communication is used. Only
 * used when terminating or aborting the benchmark or demon children.
 */
#ifndef ULTRIX
#define SIG_TERMINATE	SIGUSR1		/* corresponds to MSG_TERMINATE */
#define SIG_START	SIGUSR2		/* corresponds to MSG_START */
#define SIG_ABORT	SIGQUIT		/* corresponds to MSG_ABORT */
#define SIG_FATAL	SIGKILL		/* last resert before signal handlers
					are set up */
#else ULTIRX					
#define SIG_TERMINATE	SIGTTIN
#define SIG_START	SIGTTOU
#define SIG_ABORT	SIGQUIT
#define SIG_FATAL	SIGKILL
#endif ULTRIX

#define MSG_ASYNC(c) ((c) == MSG_TERMINATE \
		      || (c) == MSG_ABORT \
		      || (c) == MSG_FATAL \
		      || (c) == MSG_START)

/*
 * Locking and unlocking the local message queue by blocking signals
 */
#ifdef BSD
#define LOCAL_MSG_LOCK	\
	sigblock(sigmask(SIGALRM) \
		 | sigmask(SIGHUP) \
    		 | sigmask(SIGINT) \
    		 | sigmask(SIGQUIT) \
    		 | sigmask(SIGTERM) \
		 | sigmask(SIG_TERMINATE) \
		 | sigmask(SIG_ABORT))

#define LOCAL_MSG_UNLOCK(old) 	\
    	(void)sigsetmask(old)
#endif BSD

#ifdef SYSV	/* too lazy to do it correctly */
#define LOCAL_MSG_LOCK		0
#define LOCAL_MSG_UNLOCK(old)	{;}
#endif SYSV

#ifdef ULTRIX
#ifndef sigmask
#define sigmask(sig)	(1 << ((sig) - 1))
#endif
#endif

/*  */

/*
 * Exports
 */
extern int sigunblock();;
extern void setup_bench_sighdl();
extern void setup_demon_sighdl();
extern void setup_child_sighdl();
extern int sig_send_msg();

