/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * A benchmark for measuring connection setup and taredown
 * The connections are idle and are not closed until 
 * an interupting signal is received (interupted is set).
 * 
 * The connections are setup before INITIATOR_AFTER_START i.e.
 * this only serves as a background "load" measurement procedure.
 *
 * Parameters:
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>

#define allocchannels(num)	(channel_t *)malloc(sizeof(channel_t)*num)


int idle_conn(be, addr, srchdl, dsthdl, mt)
    struct bench 	*be;
    struct address_t 	*addr;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    INITIATOR_VARIABLES;
    TIMING_VARIABLES(0);
    TIMING_VARIABLES(1);
    channel_t 		*chs;

    TIMING_INITIATE(0);
    TIMING_INITIATE(1);

    mprintf("idle_conn(src 0x%x, dst 0x%x, mt 0x%x)\n",
		srchdl, dsthdl, mt);

    INITIATOR_BEFORE_START;
    
    chs = allocchannels(iterations);
    if (chs == NULL) {
	report_error(NULL, "Resource shortage (allocchannels)");
    }

    StartMeasurements(mt);

    for (i = 0; i < iterations; i++) {
	if (interupted)
	    break;
	ConnRequest(addr, &chs[i], &error);
	if (failed(&error) && !interupted) {
	    report_error(&error, "ConnRequest");
	    return NOTOK;
	}

	if (interupted)
	    continue;	/* increase i one more step */
	TIMING_DELAY(0);
    }

    INITIATOR_AFTER_START;

    /* wait forever */
    if (select(0, NULL, NULL, NULL, NULL) == NOTOK) {
      if (errno  != EINTR) {
	eprintf(EF_SYSCALL, INTERNAL, "select", "idle_conn",
		getsyserr());
      }
    }
    
    iterations = i;	/* if terminated */
    interupted = 0;

    for (i = 0; i < iterations; i++) {
	if (interupted)
	    break;
	DiscRequest(chs[i], &error);
	if (failed(&error) && !interupted) {
	    report_error(&error, "DiscRequest");
	    return NOTOK;
	}
	if (interupted)
	    break;
	TIMING_DELAY(1);
    }
	
    StopMeasurements(mt);
    if (interupted)
	mt->mt_exit = MT_EXIT_INT;

    return OK;
} /* idle_conn */



