/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * PSAP address maniplulation
 */

/*
 * TODO
 *	check storage allocation - struct address_t contains pointers:
 *		address_copy  SHOULD copy complete structure! 
 */

#include <general.h>
#include <protospec.h>
#include "../protoaddrs/psapaddr.h"

#if !(defined(DNIX) || defined(ULTRIX)) /* have version 3.0 */
#define str2taddr asn2taddr
#define taddr2str taddr2asn
#endif

/*  */

struct address_t *str2address(str, a_len)
    char *str;
    int *a_len;
{
    int inlen = *a_len;	/* total length */
    int used;		/* used (read) length */
    int len;
    struct address_t *res;
    struct TSAPaddr *ta;
    char *this, *next;

    pprintf("str2address(0x%x, 0x%x, len %d)\n",
	    str, a_len, inlen);

    this = str;
    len = strtol(this, &next, 10);
    if (next == this)
	goto err;
    this = next;
    used = next - str + 1;
    this++;		/* skip the exactly-one space */

    pprintf("str2address: len = %d\n", len);
    ta = str2taddr(this, len);
    if (ta == NULLTA) {
	pprintf(EF_IN3, PROTOCOL, "str2taddr", "str2address");
	goto err;
    }
	
    next = this + len;

    used = next - str;

    res = (struct address_t *)malloc(sizeof(struct address_t));
    if (res == NULL) {
	pprintf(EF_IN4X, INTERNAL, RESOURCE, "str2address",
		"malloc failed");
	return NULL;
    }
    res->pa_addr.sa_addr = *ta; 
    res->pa_addr.sa_selectlen = 0;
    res->pa_selectlen = 0;
    
    *a_len = used;
    return res;
    
err:
    pprintf(EF_IN3, INTERNAL, PROTOCOL, "tcp_str2address");
    return NULL;
} /* str2address */

/*  */

#define BUFSIZE 1024

char *address2str(addr, a_len)
    struct address_t *addr;
    int *a_len;
{
    char *str, *res;
    int len;
    char *base;
    static char buf[BUFSIZE];
    
    pprintf("address2str(0x%x, 0x%x)\n",
		addr, a_len);;
    str = buf;
    base = taddr2str(&addr->pa_addr.sa_addr, &len);
    if (base == NULLCP) {
	pprintf(EF_IN3, INTERNAL, "taddr2str", "str2address");
	return NULL;
    }
    sprintf(str, "%d ", len); 	/* NOTE: exactly one space */
    str += strlen(str);
    
    if (len + (str-buf)>= BUFSIZE) {
	pprintf("str2address: to long address - %d bytes left\n",
		    len + (str-buf) - BUFSIZE);
	str = NULL;
	return NULLCP;
    }

    bcopy(base, str, len);
    str[len] = '\0';

    str += len;

    len = str - buf;
    
    pprintf("address2str: wrote %s\n", buf);

    len++;	/* include NULL char */
    res = (char *)malloc(len);
    if (res == NULL) {
	pprintf(EF_IN4X, INTERNAL, RESOURCE, "address2str",
		"malloc failed");
	return NULL;
    }

    bcopy(buf, res, len);

    *a_len = len;

    return res;
} /* address2str */

/*  */

void address_free(addr)
    struct address_t *addr;
{
    pprintf("address_free(0x%x)\n", addr);

    free((char *)addr);
} /* address_free */

/*  */

/* SHOULD copy complete structure! */
struct address_t *address_copy(addr)
    struct address_t *addr;
{
    struct address_t *res;

    pprintf("address_copy(0x%x)\n", addr);
    res = (struct address_t *)malloc(sizeof(struct address_t));
    if (res == NULL) {
	pprintf(EF_IN4X, INTERNAL, RESOURCE, "address_copy",
		"malloc failed");
	return NULL;
    }

    *res = *addr;
    return res;
} /* address_copy */

/*  */

/* VARARGS3 */

void	advise (what, fmt, a, b, c, d, e, f, g, h, i, j)
char   *what,
       *fmt,
       *a,
       *b,
       *c,
       *d,
       *e,
       *f,
       *g,
       *h,
       *i,
       *j;
{
    
    (void) fflush (stdout);

    eprintf(fmt, a, b, c, d, e, f, g, h, i, j);
    if (what)
	(void) fputc (' ', stderr), perror (what);
    else
	(void) fputc ('\n', stderr);
    (void) fflush (stderr);
}

