/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */

/* Some parts of this code has been derived from the ISODE 4.0
 * Distribution Package, from Northrop. The software development
 * was initially supervised by  Rose and Cass. It has the following
 * notice:
 */

/*
 *                                NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */

#include <general.h>
#include <protospec.h>

#ifndef IPPORT_RESERVED
#include <netinet/in.h>
#endif

#define MYservice "spims"
#define MYcontext "isode isoros spims"
#define MYpci "isode isoros spims pci"

struct SSAPref sfs, *sf;
OID ctx, pci;
int RPCid;

isoros_init_client()
{

  if ((sf = addr2ref(PLocalHostName())) == NULL) {
    sf = &sfs;
    bzero((char *) sf, sizeof(*sf));
  }
  if ((ctx = ode2oid(MYcontext)) == NULLOID) {
    eprintf("isoros_init_client: ode2oid failed, unknown (context) object descriptor\n");
    exit(2);
  }
  if ((ctx = oid_cpy(ctx)) == NULLOID) {
    eprintf("isoros_init_client: oid_cpy failed\n");
    exit(2);
  }
  if ((pci = ode2oid(MYpci)) == NULLOID) {
    eprintf("isoros_init_client: ode2oid failed, unknown (pci) object descriptor\n");
    exit(2);
  }
  if ((pci = oid_cpy(pci)) == NULLOID) {
    eprintf("isoros_init_client: oid_cpy failed\n");
    exit(2);
  }
} /* isoros_init_client */

/*  */

isoros_conn_request(addrp, a_ch, errind)
    struct address_t *addrp;
    channel_t *a_ch;
    error_t   *errind;
{
  struct AcSAPconnect accs;
  int sd;
  struct PSAPctxlist pls;
  register struct PSAPctxlist *pl = &pls;
  OID oid;
  
  pprintf("isoros_conn_request(??, 0x%x, 0x%x)\n", a_ch, errind);

  pl -> pc_nctx = 1;
  pl -> pc_ctx[0].pc_id = 1;
  if ((oid = ode2oid ("iso asn.1 abstract syntax")) == NULLOID) {
      eprintf("ConnectRequest: iso asn.1 abstract syntax: unknown");
      errind->ret = NOTOK;
      errind->tag = ERT_NONE;
      return;
  }
  pl -> pc_ctx[0].pc_asn = oid_cpy (oid);
  pl -> pc_ctx[0].pc_atn = NULLOID;
  
  errind->ret = AcAssocRequest(ctx, NULLAEI, NULLAEI, NULLPA, addrp,
			       pl, pci, 0, ROS_MYREQUIRE, SERIAL_NONE,
			       0, sf, NULLPEP, 0, NULL,
			       &accs, Aci(errind));
  if (errind->ret == NOTOK) {
    eprintf("isoros_conn_request: AcAssocRequest failed: %s\n",
	    AcErrString(Aca_reason(errind)));
    errind->tag = ERT_ACI;
    return;
  }

  if (accs.acc_result != ACS_ACCEPT) {
    eprintf("isoros_conn_request: AcAssocRequest not accepted: %s\n",
	    AcErrString(Aca_reason(errind)));
    errind->ret = NOTOK;
    errind->tag = ERT_ACI;
    return;
  }

  sd = accs.acc_sd;		/* Descriptor */

  ACCFREE(&accs);

  if (RoSetService(sd, RoPService, Roi(errind)) == NOTOK) {
    eprintf("isoros_conn_request: RoSetService failed: %s\n",
	    RoErrString(Rop_reason(errind)));
    errind->ret = NOTOK;
    errind->tag = ERT_ROI;
    return;
  }
  *a_ch = sd;

  pprintf("<isoros_conn_request\n");
} /* isoros_conn_request */

/*  */

isoros_await_conn_ind(server, a_ch, errind)
    struct server_t *server;	
    channel_t *a_ch;
    error_t *errind;
{
  struct AcSAPstart acss;
  int veclen;
  char *vec[5];

  pprintf("isoros_await_conn_ind(??, 0x%x, 0x%x)\n", a_ch, errind);

  /* Wait for incoming connections */
  for (;;) {
      errind->ret = TNetAccept (&veclen, vec, 0, NULLIP, NULLIP, NULLIP,
				INF_WAIT, Td(errind));
      if (errind->ret == NOTOK) {
	  eprintf(EF_IN3, COMMUNICATION, "TNetAccept",
		 "isoros_await_conn_ind");
	  errind->tag = ERT_TD;
	  return;
      }

      if (veclen > 0)
	  break;
  }

  errind->ret = AcInit (veclen, vec, &acss, Aci(errind));
  if (errind->ret == NOTOK) {
      eprintf(EF_IN3, COMMUNICATION, "AcInit", "isoros_await_conn_ind");
      errind->tag = ERT_ACI;
      return;
  }

  *a_ch = acss.acs_sd;
  ACSFREE(&acss);
#define Pss acss.acs_start
  errind->ret = AcAssocResponse(*a_ch, ACS_ACCEPT, ACS_USER_NULL, NULLOID,
				NULLAEI, &Pss.ps_called, NULLPC,
				Pss.ps_defctxresult, Pss.ps_prequirements,
				ROS_MYREQUIRE, SERIAL_NONE,
				Pss.ps_settings, &Pss.ps_connect, NULLPEP,
				0, Aci(errind));
  if (errind->ret == NOTOK) {
    eprintf("isoros_await_conn_ind: AcAssocResponse failed: %s\n",
	    AcErrString(Aca_reason(errind)));
    errind->tag = ERT_ACI;
    return;
  }

  if (RoSetService(*a_ch, RoPService, Roi(errind)) == NOTOK) {
    eprintf("isoros_await_conn_ind: RoSetService failed: %s\n",
	    AcErrString(Rop_reason(errind)));
    errind->ret = NOTOK;
    errind->tag = ERT_ROI;
    return;
  }
} /* isoros_await_conn_ind */

/*  */

isoros_disc_request(ch, errind)
    channel_t ch;
    error_t   *errind;
{
  struct AcSAPrelease acrs;

  pprintf("isoros_disc_request(%d, 0x%x)\n", ch, errind);
    
  errind->ret = AcRelRequest(ch, ACF_NORMAL, NULLPEP, 0,
			     &acrs, Aci(errind));

  if (errind->ret == NOTOK) {
    eprintf(EF_IN3, COMMUNICATION, "AcRelRequest",
	    "isoros_disc_request");
    errind->tag = ERT_ACI;
    return;
  }

  pprintf("<isoros_disc_request: %d\n", acrs.acr_affirmative);

  ACRFREE(&acrs);    
} /* isoros_disc_request */

/*  */

isoros_await_disc_ind(ch, errind)
    channel_t ch;
    error_t *errind;
{
  pprintf("isoros_await_disc_ind(ch %d, 0x%x)\n", ch, errind);

  errind->ret = isoros_wait_request(ch, ROI_FINISH, INF_WAIT, Roi(errind));
  if (errind->ret == NOTOK) {
    errind->tag = ERT_ROI;
    eprintf(EF_IN3, COMMUNICATION, "isoros_wait_request",
	    "isoros_await_disc_ind");
    return;
  }

  errind->ret = AcRelResponse(ch, ACS_ACCEPT, ACR_NORMAL,
			      NULLPEP, 0, Aci(errind));
  if (errind->ret == NOTOK) {
    eprintf(EF_IN3, COMMUNICATION, "AcRelResponse",
	    "isoros_await_disc_ind");
    errind->tag = ERT_ACI;
  }

  pprintf("isoros_await_disc_ind\n");
} /* isoros_await_disc_ind */

/*  */

isoros_data_request(ch, buffer, amount, errind)
    channel_t ch;
    char *buffer;
    int amount;
    error_t *errind;
{
  PE pe;

  pprintf("isoros_data_request(%d, %#x:%d, %#x)\n",
	  ch, buffer, amount, errind);

  pe = oct2prim(buffer, amount);
  if (pe == NULLPE) {
    eprintf("isoros_data_request: PE allocation failed\n");
    errind->ret = NOTOK;
    errind->tag = ERT_NONE;
    return;
  }

  errind->ret = RoInvokeRequest(ch, ISOROS_Data, ROS_SYNC, pe, ISOROS_Data,
				NULLIP, ROS_NOPRIO, Roi(errind));
  if (errind->ret == NOTOK) {
    eprintf(EF_IN3, COMMUNICATION, "RoInvokeRequest",
	    "isoros_data_request");
    errind->tag = ERT_ROI;
    return;
  }

  if (Roi(errind)->roi_type != ROI_RESULT) {
    eprintf(EF_IN3, COMMUNICATION, "RoInvokeRequest",
	    "isoros_data_request");
    errind->ret = NOTOK;
    errind->tag = ERT_ROI;
    return;
  }

  pe_free(pe);

  RORFREE(&Roi(errind)->roi_result);

  pprintf("<isoros_data_request\n");
} /* isoros_data_request */

/*  */

isoros_rpc_call(ch, src, slen, dst, dlen, errind)
    channel_t ch;
    char *src, *dst;
    int slen, dlen;
    error_t *errind;
{
  struct RoSAPresult *res;
  PE pe;
  int length;

  pprintf("isoros_rpc_call(%d, %#x:%d, %#x:%d, %#x)\n",
	  ch, src, slen, dst, dlen, errind);

  pe = oct2prim(src, slen);
  if (pe == NULLPE) {
    eprintf("isoros_rpc_call: PE allocation failed\n");
    errind->ret = NOTOK;
    errind->tag = ERT_NONE;
    return;
  }

  errind->ret = RoInvokeRequest(ch, ISOROS_RPC, ROS_SYNC, pe, ISOROS_RPC,
				NULLIP, ROS_NOPRIO, Roi(errind));
  if (errind->ret == NOTOK) {
    eprintf(EF_IN3, COMMUNICATION, "RoInvokeRequest",
	    "isoros_rpc_call");
    errind->tag = ERT_ROI;
    return;
  }

  if (Roi(errind)->roi_type != ROI_RESULT) {
    eprintf(EF_IN3, COMMUNICATION, "RoInvokeRequest",
	    "isoros_rpc_call");
    errind->ret = NOTOK;
    errind->tag = ERT_ROI;
    RORFREE(res);
    return;
  }

  res = &Roi(errind)->roi_result;

  bcopy(prim2str(res->ror_result, &length), dst, dlen);

  pe_free(pe);

  RORFREE(res);

  pprintf("<isoros_rpc_call\n");
} /* isoros_rpc_call */

/*  */

void isoros_await_operation_call(opcode, name, ch, errind, invp)
     int opcode;
     char *name;
     channel_t ch;
     error_t *errind;
     struct RoSAPinvoke **invp;
{
  errind->ret = isoros_wait_request(ch, ROI_INVOKE, INF_WAIT, Roi(errind));
  if (errind->ret == NOTOK) {
    errind->tag = ERT_ROI;
    return;
  }

  *invp = &Roi(errind)->roi_invoke;

  if ((*invp)->rox_op != opcode) {
    errind->ret = NOTOK;
    errind->tag = ERT_NONE;
    eprintf("Wrong operation received: op = %d\n", (*invp)->rox_op);
    ROXFREE(*invp);
  }
} /* isoros_await_operation_call */


isoros_await_data_ind(ch, buffer, amount, errind)
    channel_t ch;
    char *buffer;
    int amount;
    error_t *errind;
{
  struct RoSAPinvoke *res;
  char *str;
  int length;
    
  pprintf("isoros_await_data_ind()\n");

  isoros_await_operation_call(ISOROS_Data, "isoros_await_data_ind",
			      ch, errind, &res);

  if (errind->ret == NOTOK) return;

  isoros_do_operation_reply(ch, res->rox_id, NULLPE, "isoros_await_data_ind",
			    errind);

  str = prim2str(res->rox_args, &length);

  if (length != amount) {
    errind->ret = NOTOK;
    errind->tag = ERT_NONE;
    eprintf("Wrong data received: length = %d, first byte = %d\n",
	    length, *str);
  } else
    bcopy(str, buffer, amount);

  if (str)
    free(str);

  ROXFREE(res);

  pprintf("<isoros_await_data_ind\n");
} /* isoros_await_data_ind */

/*  */

isoros_create_server(aa_server, aa_addr, errind)
    struct server_t **aa_server;
    struct address_t **aa_addr;
    error_t   *errind;
{

  struct address_t myaddr;
  struct PSAPaddr *pa = &myaddr;
  struct NSAPaddr   *na;
  int n;
#define HOSTNAMELEN 64
  char LocalHost[HOSTNAMELEN];

  pprintf("isoros_create_server(0x%x, 0x%x, 0x%x)\n",
		aa_server, aa_addr, errind);

  if (gethostname(LocalHost, HOSTNAMELEN) == NOTOK) {
    eprintf(EF_SYSCALL, COMMUNICATION, "gethostname",
	    "isoros_create_server", getsyserr());
    errind->ret = NOTOK;
    errind->tag = ERT_NONE;
    return;
  }

  pprintf("isoros_create_server: LocalHost %s\n", LocalHost);

  myaddr.pa_selectlen = 0;
  myaddr.pa_addr.sa_selectlen = 0;

#ifdef ADDR_SELECT
  myaddr.pa_addr.sa_addr.ta_selectlen =
      sizeof myaddr.pa_addr.sa_addr.ta_port;
  myaddr.pa_addr.sa_addr.ta_port =
      htons((u_short)(0x8000 | (getpid() & 0x7fff)));
#else
  myaddr.pa_addr.sa_addr.ta_selectlen = 0;
#endif

  myaddr.pa_addr.sa_addr.ta_naddr = 1;

  /* first NSAP address */
  myaddr.pa_addr.sa_addr.ta_addrs[0].na_type = NA_TCP;
  strcpy(myaddr.pa_addr.sa_addr.ta_addrs[0].na_domain, LocalHost);

  myaddr.pa_addr.sa_addr.ta_addrs[0].na_port =
      htons((u_short)(0x8000 | (getpid() & 0x7fff)));

  if ((n = pa->pa_addr.sa_addr.ta_naddr) <= 0) {
    eprintf(EF_IN3, INTERNAL, "no NSAP addresses present",
	    "isoros_create_server");
    errind->ret = NOTOK;
    errind->tag = ERT_NONE;
    return;
  }

  /* Listen on each given Network Address */
  for (na = pa->pa_addr.sa_addr.ta_addrs; n > 0; na++, n--) {
    pprintf("TNetListen: port %d, domain %s\n",
	    na->na_port, na->na_domain);

    errind->ret = TNetListen (na, Td(errind));
    if (errind->ret == NOTOK) {
      eprintf(EF_SYSCALL, COMMUNICATION, "TNetListen", "isoros_create_server",
	      getsyserr());
      errind->tag = ERT_TD;
      return;
    }
  }

  *aa_server = (struct server_t *)malloc(sizeof(struct server_t));
  if (*aa_server == NULL) {
      eprintf(EF_IN3, INTERNAL, RESOURCE, "CreateServer");
      errind->ret = NOTOK;
      return;
  }
  *aa_addr = (struct address_t *)malloc(sizeof(struct address_t));
  if (*aa_addr == NULL) {
      eprintf(EF_IN3, INTERNAL, RESOURCE, "CreateServer");
      errind->ret = NOTOK;
      free((char *)*aa_server);
      return;
  }
  **aa_server = myaddr;
  **aa_addr = myaddr;
  errind->ret = OK;

  pprintf("<isoros_create_server\n");
} /* isoros_create_server */

/*  */

isoros_destroy_server(a_server, errind)
    struct server_t	*a_server;
    error_t   *errind;
{
  pprintf("isoros_destroy_server(0x%x, 0x%x)\n", a_server, errind);

  /* stop listening */
  free((char *)a_server);

  errind->ret = TNetClose (NULLNA, Td(errind));
  if (errind->ret == NOTOK) {
    eprintf(EF_IN3, COMMUNICATION, "TNetClose", "isoros_destroy_server");
    errind->tag = ERT_TD;
    return;
  }

  errind->ret = OK;
} /* isoros_destroy_server */

/*  */

isoros_report_error(err, str)
    error_t *err;
    char *str;
{
  struct AcSAPabort *aca;
  struct RoSAPindication *roip;
  int i;

  pprintf("isoros_report_error(0x%x)\n", err);

  if (err == NULL) {
    eprintf(EF_SYSCALL, COMMUNICATION, "Error", str,
	    getsyserr());
    return;
  } 

  if (errno > 0) {
    eprintf(EF_SYSCALL, COMMUNICATION, "ROS protocol", str,
	    getsyserr());
  }
  
  switch (err->tag) {
  case ERT_NONE:
    /* error already reported */
    break;

  case ERT_ROI:
    roip = &err->roi;	    
    eprintf("%s: ROS protocol in %s: RoSAPindication type ",
	    COMMUNICATION, str);
    switch (roip->roi_type) {
    case ROI_ERROR:
      {
	register struct RoSAPerror *roe = &roip->roi_error;

	eprintf("error: id = %d, error = %d, error_as_string = %s.\n",
	       roe->roe_id, roe->roe_error, RoErrString(roe->roe_error));
	break;
      }
    case ROI_UREJECT:
      {
	register struct RoSAPureject *rou = &roip->roi_ureject;

	eprintf("ureject: id = %d, noid = %d, reason = %s.\n",
	       rou->rou_id, rou->rou_noid, RoErrString(rou->rou_reason));
	break;
      }
    case ROI_PREJECT:
      {
	register struct RoSAPpreject *rop = &roip->roi_preject;

	eprintf("preject: id = %d, reason = %s.\n",
	       rop->rop_id, RoErrString(rop->rop_reason));
	eprintf("diagnostic:%*.*s.\n", rop->rop_cc,
		rop->rop_cc, rop->rop_data);
	ROPFREE(rop);
	break;
      }
    default:
      eprintf("%d: first entry = %d\n", roip->roi_type,
	     *(int *)&roip->roi_error);
    }
    break;

  case ERT_ACI:
    aca = &err->aci.aci_abort;	    
    ACAFREE(aca);
    if (err->aci.aci_type != ACI_ABORT) {
      eprintf(EF_IN4X, INTERNAL, "tag", "AcSAPindication",
	     "Doesn't contain ACI_ABORT on failure");
      eprintf("\tIndication type: %d from %s\n",
	      err->aci.aci_type, str);
      return;
    }
    eprintf(EF_IN4X, COMMUNICATION, "ISOROS protocol", str,
	    (aca->aca_source == ACA_USER) ? "User-initiated abort" :
	    "Provider-initiated abort");
    if (aca->aca_source != ACA_USER)
      eprintf("Diagnostic: %*.*s.\n", aca->aca_cc, aca->aca_cc, aca->aca_data);
    eprintf("Diagnostic: %s.\n", AcErrString(Aca_reason(err)));
    break;

  case ERT_TD:
    eprintf(EF_IN4X, COMMUNICATION, "ISOROS", str,
	    TErrString(Td_reason(err)));
    eprintf("\tData: %*.*s.\n", err->td.td_cc,
	    err->td.td_cc, err->td.td_data);
    break;

  default:
    eprintf(EF_IN4, INTERNAL, PARAMETER, "isoros_report_error",
	    "Unknow tag in error_t structure");
    return;
  }

} /* isoros_report_error */

/*  */

/* ARGSUSED */

static isoros_finishindication (ch, acf)
     channel_t ch;
     struct AcSAPfinish *acf;
{
  struct AcSAPindication   acis;

  ACFFREE(acf);

  if (AcRelResponse(ch, ACS_ACCEPT, ACR_NORMAL, NULLPEP, 0, &acis) == NOTOK)
    pprintf(EF_IN3, COMMUNICATION, "AcRelResponse",
	    "isoros_finishindication");
} /* isoros_finishindication */

/*  */

int isoros_wait_request(ch, expected, secs, roip)
    channel_t ch;
    int expected;	/* indication type */
    int secs;		/* INF_WAIT => forever */
    struct RoSAPindication *roip;
{
  pprintf("isoros_wait_request(%d, %d, %d, 0x%x)\n", ch, expected, secs, roip);

  if (RoWaitRequest(ch, secs, roip) == NOTOK) {
    eprintf(EF_IN3, COMMUNICATION, "RoWaitRequest",
	    "isoros_wait_request");
    return NOTOK;
  }

  if (roip->roi_type == expected)
    return OK;

  switch (roip->roi_type) {
  case ROI_FINISH:
    pprintf(EF_IN3, COMMUNICATION, "RoWaitRequest",
	   "isoros_wait_request");
    pprintf("\tBad indication type: ROI_FINISH\n");
    (void)isoros_finishindication(ch, roip->roi_finish);
    return NOTOK;

  case ROI_UREJECT:
    pprintf(EF_IN3, COMMUNICATION, "RoWaitRequest",
	    "isoros_wait_request");
    pprintf("\tBad indication type: ROI_UREJECT\n");
    pprintf("Ro-UREJECT.INDICATION: %d, %s.\n", roip->roi_ureject.rou_id,
	    RoErrString(roip->roi_ureject.rou_reason));
    return NOTOK;

  default:
    pprintf(EF_IN3, COMMUNICATION, "RoWaitRequest",
	    "isoros_wait_request");
    pprintf("\tBad indication type: %d\n", roip->roi_type);
    return NOTOK;
  }
  /* NOTREACHED */
} /* isoros_wait_request */


