/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * NULL level specific code
 */

#include <general.h>
#include <protospec.h>

null_report_error(err, str)
    error_t *err;
    char *str;
{
    pprintf("null_report_error(0x%x)\n", err);
    
    if (err == NULL) {
	eprintf(EF_IN4X, COMMUNICATION, "Error", str,
	       getsyserr());
    } else {
	eprintf(EF_IN4X, COMMUNICATION, "NULL protocol", str,
	       getsyserr());
    }
} /* null_report_error */

