/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * TSAP protocol specific code
 */

#include <general.h>
#include <protospec.h>

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#ifndef IPPORT_RESERVED
#include <netinet/in.h>
#endif
#include <netinet/if_ether.h>
#include <sys/ieee802.h>    
#include <netosi/osi.h>    
#include <netosi/osi_addr.h>    
#include <sys/errno.h>
#include <netosi/osi_error.h>    
#include <sunosi/ses_user.h>
#include <sys/uio.h>
#include <netosi/tp_event.h>
#include <netosi/osi_layer.h>

#define INF_WAIT NOTOK

/*  */

tsap_init_client()
{
    pprintf("tsap_init_client()\n");
    

} /* tsap_init_client */

/*  */

tsap_conn_request(addr, a_ch, errind)
    struct address_t *addr;
    channel_t *a_ch;
    error_t   *errind;
{
    struct TSAPconnect  tcs;
    register struct TSAPconnect *tc = &tcs;
    register struct TSAPdisconnect *td = &errind->er_td;
    OSI_ADDR oa;
    
    pprintf("tsap_conn_request(0x%x, 0x%x, 0x%x)\n", addr, a_ch, errind);

    if (TConnRequest (NULLTA, addr, 1, NULLCP, 0, NULLQOS, tc, td) == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "TConnRequest",
	       "tsap_conn_request");
	errind->er_ret = NOTOK;
	return;
    }

    if (ProtoDebug) {
	struct TSAPaddr *ta;
	struct NSAPaddr *na;

	ta = &tc -> tc_responding;
	na = ta -> ta_addrs;
	
	pprintf("ConnRequest: responding TSAP address: <%s, %s>",
		na2str (na),
		sel2str (ta -> ta_selector, ta -> ta_selectlen, 1));
	
	if (tc -> tc_cc > 0)
	    pprintf("ConnRequest: greetings: %*.*s",
		    tc -> tc_cc, tc -> tc_cc, tc -> tc_data);
    }
	
    pprintf("tsap_conn_request: channel %d\n",	tc->tc_sd);

    *a_ch = tc -> tc_sd;

    errind->er_ret = OK;
} /* tsap_conn_request */

/*  */

tsap_await_conn_ind(server, a_ch, errind)
    struct server_t *server;	
    channel_t *a_ch;
    error_t *errind;
{
    struct TSAPaddr *ta = server;
    int	    n,
	    secs,
	    vecp;
    char   *vec[4];
    register struct dispatch *ds;
    struct TSAPstart    tss;
    register struct TSAPstart  *ts = &tss;
    struct TSAPdata txs;
    register struct TSAPdata   *tx = &txs;
    register struct TSAPdisconnect *td = &errind->er_td;

    pprintf("tsap_await_conn_ind(??, 0x%x, 0x%x)\n", a_ch, errind);

    /* Wait for incoming connections */
    for (;;) {
	errind->er_ret = TNetAccept (&vecp, vec, 0, NULLIP, NULLIP, NULLIP,
				     INF_WAIT, td);
	if (errind->er_ret == NOTOK) {
	    eprintf(EF_IN3, COMMUNICATION, "TNetAccept",
		   "tsap_await_conn_ind");
	    return;
	}

	if (vecp > 0)
	    break;
    }

    errind->er_ret = TInit (vecp, vec, ts, td);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "TInit", "AwaitConnInd");
	return;
    }

    if (ProtoDebug) {
	pprintf("AwaitConnInd: T-CONNECT.INDICATION: <%d, <%s, %s>, <%s, %s>, %d, %d>",
	    ts -> ts_sd,
	    na2str (ts -> ts_calling.ta_addrs),
	    sel2str (ts -> ts_calling.ta_selector,
		     ts -> ts_calling.ta_selectlen, 1),
	    na2str (ts -> ts_called.ta_addrs),
	    sel2str (ts -> ts_called.ta_selector,
		     ts -> ts_called.ta_selectlen, 1),
	    ts -> ts_expedited, ts -> ts_tsdusize);
	if (ts -> ts_cc > 0)
	    pprintf("AwaitConnInd: greetings: %*.*s",
		    ts -> ts_cc, ts -> ts_cc, ts -> ts_data);
    }

    *a_ch = ts -> ts_sd;
    pprintf("Calling TConnResponse\n");

    errind->er_ret = TConnResponse (*a_ch, NULLTA, ts -> ts_expedited,
		       NULLCP, 0, NULLQOS, td);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "TConnResponse",
	       "tsap_await_conn_ind");
	return;
    }

} /* tsap_await_conn_ind */


/*  */

tsap_disc_request(ch, errind)
    channel_t ch;
    error_t   *errind;
{
    register struct TSAPdisconnect *td = &errind->er_td;
    

    pprintf("tsap_disc_request(%d, 0x%x)\n", ch, errind);
    
    if ((errind->er_ret = TDiscRequest (ch, NULLCP, 0, td)) == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "TDiscRequest",
	       "DiscRequest");
	return;
    }

} /* tsap_disc_request */

/*  */

tsap_await_disc_ind(ch, errind)
    channel_t ch;
    error_t *errind;
{
    register struct TSAPdisconnect *td = &errind->er_td;
    struct TSAPdata txs;
    register struct TSAPdata *tx = &txs;
    
    pprintf("tsap_await_disc_ind(ch %d, 0x%x)\n", ch, errind);


    if (TReadRequest (ch, tx, NOTOK, td) == OK) {
	eprintf(EF_IN3, COMMUNICATION, "TReadRequest",
		"AwaitDiscInd - receives data");
	TXFREE(tx);
	errind->er_ret = NOTOK;
	return;
    }

    if (td -> td_reason != DR_NORMAL) {
	eprintf(EF_IN3, COMMUNICATION, "TReadRequest",
		"Abnormal disconnect");
	errind->er_ret = NOTOK;
	return;
    }

    errind->er_ret = OK;

} /* tsap_await_disc_ind */

/*  */

tsap_create_server(aa_server, aa_addr, errind)
    struct server_t **aa_server;
    struct address_t **aa_addr;
    error_t   *errind;
{
    struct address_t myaddr;
    struct TSAPaddr *ta = &myaddr;
    int n;
    OSI_ADDR oa;
    char buf[BUFSIZ];
    char eabuf[128], *ea;
    struct ether_addr eaddr;
    char *ether_ntoa();
    
#define HOSTNAMELEN 64
    char LocalHost[HOSTNAMELEN];

    gethostname(LocalHost, sizeof(LocalHost));
    ether_hostton(LocalHost, &eaddr);
    ea = ether_ntoa(&eaddr);

    OSI_ADDR_INIT(&oa);
    sprintf(buf, "[(osinet)%d,%d; (802.osinet)%s; 0] [(tsel)%d]",
	    OSI_ORG, OSI_SUBNET, ea, OSI_TSEL);
    if (osi_parseaddr(buf, &oa, OSI_TSAP) < 0) {
	eprintf(EF_SYSCALL, COMMUNICATION, "osi_parseaddr - TSAP",
		"tsap_create_server",
		getsyserr());
	errind->er_ret = NOTOK;
	return ;
    }
#ifdef notdef
    if (osi_parseaddr(buf, &oa, OSI_NSAP) < 0) {
	eprintf(EF_SYSCALL, COMMUNICATION, "osi_parseaddr - NSAP",
		"tsap_create_server",
		getsyserr());
	errind->er_ret = NOTOK;
	return ;
    }
#endif
    pprintf("suntp4_create_server: LocalHost %s\n", LocalHost);

    if (NOTOK == tp42gen(ta, &oa, 0)) {
	eprintf(EF_SYSCALL, COMMUNICATION, "tp4 -> generic address",
		"suntp4_create_server",
		getsyserr());
	errind->er_ret = NOTOK;
	return ;
    }

    errind->er_ret = TNetListen (ta, &errind->er_td);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_SYSCALL, COMMUNICATION, "TNetListen", "suntp4_create_server",
		getsyserr());
	return;
    }

    *aa_server = (struct server_t *)malloc(sizeof(struct server_t));
    if (*aa_server == NULL) {
	eprintf(EF_IN3, INTERNAL, RESOURCE, "CreateServer");
	errind->er_ret = NOTOK;
	return;
    }
    *aa_addr = (struct address_t *)malloc(sizeof(struct address_t));
    if (*aa_addr == NULL) {
	eprintf(EF_IN3, INTERNAL, RESOURCE, "CreateServer");
	errind->er_ret = NOTOK;
	free((char *)*aa_server);
	return;
    }
    **aa_server = myaddr;
    **aa_addr = myaddr;
    errind->er_ret = OK;

} /* tsap_create_server */

/*  */

tsap_destroy_server(a_server, errind)
    struct server_t *a_server;
    error_t   *errind;
{

    pprintf("tsap_destroy_server(0x%x, 0x%x)\n", a_server, errind);

    /* stop listening */

    free((char *)a_server);
    errind->er_ret = TNetClose (NULLTA, &errind->er_td);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "TNetClose", "tsap_destoy_server");
	return;
    }
	
    errind->er_ret = OK;
} /* tsap_destroy_server */

/*  */

tsap_data_request(ch,buffer,amount,errind)
    channel_t ch;
    char * buffer;		
    int amount;
    error_t *errind;
{
    register struct TSAPdisconnect *td = &errind->er_td;

    pprintf("tsap_data_request()\n");

    errind->er_ret = TDataRequest (ch, buffer, amount, td);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "TDataRequest", "DataRequest");
	return;
    }
    
} /* tsap_data_request */

/*  */

extern char *qb2str();

tsap_await_data_ind(ch,buffer,amount,errind)
    channel_t ch;
    char * buffer;
    int amount;
    error_t *errind;
{
    register struct TSAPdisconnect *td = &errind->er_td;
    struct TSAPdata txs;
    register struct TSAPdata *tx = &txs;
    register char *p;

    pprintf("tsap_await_data_ind()\n");
    
    errind->er_ret = TReadRequest (ch, tx, NOTOK, td);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "TReadRequest",
		"AwaitDataInd");
	return;
    }

    if (tx->tx_cc != amount) {
	eprintf(EF_IN3, COMMUNICATION, "Mismatch on amount received",
		"AwaitDataInd");
	errind->er_ret = NOTOK;
	return;
    }	

    p = qb2str (&tx -> tx_qbuf);
    bcopy(p, buffer, amount);
    free (p);
    
    TXFREE(tx);    
} /* tsap_await_data_ind */

/*  */

tsap_report_error(err, str)
    error_t *err;
    char *str;
{
    int i;

    pprintf("tsap_report_error(0x%x)\n", err);
    
    if (err == NULL) {
	eprintf(EF_SYSCALL, COMMUNICATION, "Error", str,
		getsyserr());
	return;
    } 
    
    eprintf(EF_IN4X, COMMUNICATION, "TSAP", str,
	    TErrString(err->er_td.td_reason));
    if (err->er_td.td_cc > 0)
	eprintf("\tData: %*.*s\n", err->er_td.td_cc,
		err->er_td.td_cc, err->er_td.td_data);
    
} /* tsap_report_error */

