/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The driver for the client/initiator procedures
 */

#include <general.h>

int exec_client(be, serveraddr, stat)
    struct bench *be;
    struct address_t *serveraddr;
    statistics_t *stat;
{
    metrics_t mt;
    iohdl_t *srchdl, *dsthdl;    
    long bufsize;
    int totsize, iterations, itemsize, ret;
    struct datasp *dt;

        
    tprintf("exec_client(0x%x, ??, 0x%x)\n", be, stat);

    if (Debug)
	bench_print(be);
    
    /* Check parameters */

    if (bench_symbol(be) == NULLSE) {
	eprintf(EF_IN4, INTERNAL, PARAMETER,  "exec_client",
		"bench_symbol is NULLSE");
	return NOTOK;
    }
    if (!bench_isbasic(be)) {
	eprintf(EF_IN3, INTERNAL, "not a basic benchmarks", "exec_client");
	return NOTOK;
    }
    if (basic_data(be) == NULLDT) {
	eprintf(EF_IN4, INTERNAL, PARAMETER, "exec_client",
		"data specification is NULL");
	return NOTOK;
    }
    if (datasp_src(basic_data(be)) == NULLAC ||
	datasp_dst(basic_data(be)) == NULLAC) {
	eprintf(EF_IN4, INTERNAL, PARAMETER, "exec_client",
		"source or destination spec is missing!");
	return NOTOK;
    }

    dt = basic_data(be);
	
    /* Setup the source and destination */

    srchdl = access2iohdl(datasp_src(dt));
    dsthdl = access2iohdl(datasp_dst(dt));

    iterations = datasp_iterations(dt);
    if (iterations == SS_DEFAULT) {
	   iterations = MAX_ITERATIONS;
	   datasp_iterations(dt) = iterations;
    }
#ifdef notdef
    /* Can't do this with distributions on the message size! */
    if (iterations == SS_DEFAULT) {
	totsize = (*srchdl->io_size)();
	if (totsize == SIZE_UNLIMIT)
	    totsize = (*dsthdl->io_size)();
	if (totsize == SIZE_UNLIMIT) 
	   iterations = MAX_ITERATIONS;
	else
	   iterations = totsize/datasp_msgsize(dt);
	dprintf("Number of iterations set to: %d\n",
		    iterations);
	datasp_iterations(dt) = iterations;
    }
#endif notdef
    itemsize = type2size(datasp_type(dt));
    bufsize = datasp_maxsendsize(dt) * itemsize;

    /* GROSS HACK for virtual memory things */
    if (iohdl_isvm(srchdl)) 
	ret = (*srchdl->io_open)(srchdl, source, bufsize*iterations);
    else	
	ret = (*srchdl->io_open)(srchdl, source, bufsize);

    if (ret == NOTOK) {
	eprintf(EF_IN3, INTERNAL, "Failed opening the source",
		"exec_client");
	return NOTOK;
    }

    bufsize = datasp_maxrecvsize(dt) * itemsize;

    if (iohdl_isvm(dsthdl)) 
 	ret = (*dsthdl->io_open)(dsthdl, destination, bufsize*iterations);
    else	
	ret = (*dsthdl->io_open)(dsthdl, destination, bufsize);
    if (ret == NOTOK) {
	eprintf(EF_IN3, INTERNAL, "Failed opening the destination",
		"exec_client");
	return NOTOK;
    }	
						
    iohdl_setitemsize(srchdl, itemsize);
    iohdl_setitemsize(dsthdl, itemsize);

    

    if ((*bench_client_proc(be))(be, serveraddr, srchdl, dsthdl,
			  &mt) == NOTOK) {
 	(*srchdl->io_destroy)(srchdl);
	(*dsthdl->io_destroy)(dsthdl);
        srchdl = NULLIO;
        dsthdl = NULLIO;
	eprintf(EF_IN3, INTERNAL, "*bench_client_proc", "exec_client");
	return NOTOK;
    }

	
    (*srchdl->io_destroy)(srchdl);
    (*dsthdl->io_destroy)(dsthdl);
    srchdl = NULLIO;
    dsthdl = NULLIO;

    Metrics2Stats(&mt, stat);

    dprintf("exec_client done\n");
    return OK;
} /* exec_client */    
