/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Conversion
 */

/*
 * Exports:
 *	access2iohdl(ac: struct access *) -> iohdl_t *
 *	type2size(type: int) -> int		type is according to y.tab.h
 *	write_stat(s: int(socket); st: statistics_t *)
 *	scan_stat((s: int(socket); st: statistics_t *)
 */

#include <general.h>

#include <y.tab.h>


iohdl_t *access2iohdl(ac)
    struct access *ac;
{
    iohdl_t *iohdl;

    tprintf("access2iohdl(0x%x)\n", ac);

    switch (access_type(ac)) {
    case ACT_FILE:
	return iohdl_create(IOT_FILE, access_filename(ac));
    case ACT_MEM:
	return iohdl_create(IOT_MEM);
    case ACT_VM:
	return iohdl_create(IOT_VM);
    }
} /* access2iohdl */

/*  */

int type2size(type)
    int type;
{
    tprintf("type2size(%d)\n", type);

    switch (type) {
    case BYTES:
    case ASCII:
	return sizeof(char);
    case INT:
	return sizeof(int);
    default:
	eprintf(EF_IN4, INTERNAL, "Unknown type", "type2size",
	       "\nAssumes CHAR type");
	return sizeof(char);
    }
} /* type2size */

/*  */

#define BFS	100	/* enough to hold a floating number printed out */

#define write_float(val) \
    sprintf(buf, "%f ", val); \
    len = strlen(buf); \
    write(s, buf, len);
    

int write_stat(s, st)
    int s;
    statistics_t *st;
{
    static char buf[BFS];
    int len;

    tprintf("write_stat(%d, 0x%x)\n", s, st);

    write_float(st->st_exitstatus);
    write_float(st->st_elapsed);
    write_float(st->st_cputime);
    write_float(st->st_stime);
    write_float(st->st_utime);
    write_float(st->st_delay);
    write_float(st->st_datasent);
    write_float(st->st_datarcvd);
    write_float(st->st_msgsent);
    write_float(st->st_msgrcvd);
    write_float(st->st_packsent);
    write_float(st->st_packrcvd);
    write_float(st->st_signals);
    write_float(st->st_blockout);
    write_float(st->st_blockin);
    write_float(st->st_pageio);
    write_float(st->st_pagerecl);
    write_float(st->st_swaps);
    write_float(st->st_ivcsw);
    write_float(st->st_vcsw);
    write_float(st->st_maxrss);
    return OK;
} /* write_stat */

/*  */

char buf[BFS];

static RTrace = 0;

read_float(s, varp)
    double *varp;
{
    char *cp = buf; 
    float fv;
    int count;
    
    if (RTrace)
	tprintf("read_float(%d, 0x%x)\n", s, varp);

    do {
	count = read(s, cp, 1);
	if (count == NOTOK) {
	    eprintf(EF_SYSCALL, INTERNAL, "read()", "read_float",
		   getsyserr());
	    return;
	}
    } while (count != 0 && *cp++ == ' ');
    do {
	count = read(s, cp, 1);
	if (count == NOTOK) {
	    eprintf(EF_SYSCALL, INTERNAL, "read call", "read_float",
		   getsyserr());
	    return;
	}
    } while (count != 0 && *cp++ != ' ');
    
    *cp = '\0'; 
    if (RTrace)
	tprintf("read_float: %s\n", buf);
    
    if (sscanf(buf, "%f", &fv) != 1) { 
	eprintf(EF_IN4, PROTOCOL, "Bad statistics", "read_float", 
	       "Can't find a float");
	return;
    }
    *varp = fv;
} /* read_float */

int scan_stat(s, st)
    int s;
    statistics_t *st;
{
    tprintf("scan_stat(%d, 0x%x)\n", s, st);
    
    read_float(s, &st->st_exitstatus);
    read_float(s, &st->st_elapsed);
    read_float(s, &st->st_cputime);
    read_float(s, &st->st_stime);
    read_float(s, &st->st_utime);
    read_float(s, &st->st_delay);
    read_float(s, &st->st_datasent);
    read_float(s, &st->st_datarcvd);
    read_float(s, &st->st_msgsent);
    read_float(s, &st->st_msgrcvd);
    read_float(s, &st->st_packsent);
    read_float(s, &st->st_packrcvd);
    read_float(s, &st->st_signals);
    read_float(s, &st->st_blockout);
    read_float(s, &st->st_blockin);
    read_float(s, &st->st_pageio);
    read_float(s, &st->st_pagerecl);
    read_float(s, &st->st_swaps);
    read_float(s, &st->st_ivcsw);
    read_float(s, &st->st_vcsw);
    read_float(s, &st->st_maxrss);
    
    return OK;
} /* scan_stat */
