/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Error handling routines
 */

#include <general.h>
#include <ipc.h>

#define MAX_DIAGS	2048
#define FUDGE		512	/* number of characters caused by */
				/* the parameters to eprintf */


char diagstr[MAX_DIAGS];
char *diag = diagstr;

/* VARARGS1 */
eprintf(fmt,a,b,c,d,e,f,g,h)
    char *fmt;
{
    bcpaddr_t myaddr;

    myaddr = get_myaddr();

    printmynameerr();
    fprintf(stderr, fmt ,a,b,c,d,e,f,g,h);
    fflush(stderr);

    if (myaddr.ba_addr != BA_BENCH) {
      if ((int)diag + strlen(fmt) + FUDGE > (int)diagstr + MAX_DIAGS) {
	/* reset to the beginning of the string */
	diag = diagstr;
      }
      sprintf(diag, fmt, a,b,c,d,e,f,g,h);
      diag += strlen(diag);
    }
} /* eprintf */

/*  */

init_stdio()
{
#ifdef BSD
    setlinebuf(stdout);
    setlinebuf(stderr);
#endif BSD
#ifdef SYSV
    if (setvbuf(stdout, NULL, _IOLBF, 0) != 0) {
    	eprintf(EF_IN3, INTERNAL, "setvbuf", "init");
    	exit(2);
    }
    if (setvbuf(stderr, NULL, _IOLBF, 0) != 0) {
    	eprintf(EF_IN3, INTERNAL, "setvbuf", "init");
    	exit(2);
    }
#endif SYSV
} /* init_stdio */
