/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Priority handling
 */

#include <general.h>

/*  */

int reduce_priority(delta)
    int delta;
{
    int prio;

    tprintf("reduce_priority(%d)\n", delta);
#ifdef BSD
    errno = 0;
    prio = getpriority(PRIO_PROCESS, 0);
    if (errno != 0) {
	eprintf(EF_SYSCALL, INTERNAL, "getpriority", "reduce_priority",
		getsyserr());
	return NOTOK;
    }
    dprintf("\tPriority %d - change to %d\n", prio, prio+delta);

    if (setpriority(PRIO_PROCESS, 0, prio+delta) == NOTOK) {
	eprintf(EF_SYSCALL, INTERNAL, "setpriority", "reduce_priority",
		getsyserr());
	return NOTOK;
    }
    return OK;
#else
#ifdef SYSV
    prio = nice(delta);
    if (prio == NOTOK) {
	eprintf(EF_SYSCALL, INTERNAL, "getpriority", "reduce_priority",
		getsyserr());
	return NOTOK;
    }
    dprintf("\tPriority %d - change to %d\n", prio, prio+delta);
    return OK;
#else    
	eprintf("reduce_priority: not implemented for this system\n");
	return NOTOK;
#endif	
#endif	
} /* reduce_priority */


    
