/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Random number generator
 * Uses the random(3) function
 */

#include <general.h>

#ifdef BSD
extern long random();	/* returns a number between 0 and (2**31)-1 */
#endif BSD
#ifdef SYSV    
extern double drand48();
#endif SYSV

initrand()
{
    long seed;
    struct timezone tz; /* Not used */
    struct timeval tv;

    tprintf("initrand: called\n");
    
    if (gettimeofday(&tv, &tz) == NOTOK) {
	eprintf(EF_SYSCALL, INTERNAL, "gettimeofday", "initrand",
	       getsyserr());
    }

    seed = tv.tv_sec + tv.tv_usec;

#ifdef BSD
    srandom(seed);
#endif BSD
#ifdef SYSV
   srand48(seed);
#endif SYSV
} /* initrand */

#ifdef BSD
double bench_rand()
{
    double val;
    if (Debug) {
	val = (double)(random()) / (0x80000000-1);
	dprintf("bench_rand: %f\n", val);
	return val;
    } else
    return (double)(random()) / (0x80000000 - 1);
} /* bench_rand */
#endif BSD

#ifdef SYSV
double bench_rand() 
{
    return drand48();
}

#endif SYSV

    
