/* 1445, Fri 15 Jul 94

   METER_UX.C:  The AU Internet Accouting Meter mainline

   Copyright (C) 1992-1994 by Nevil Brownlee,
   Computer Centre,  The University of Auckland */

/*
 * snmpd.c - send snmp GET requests to a network entity.
 *
 */
/***********************************************************
	Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#define noUX_TESTING

#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <fcntl.h>

#include <sys/time.h>
#include <sys/timeb.h>

#ifdef SUNOS
#include <stropts.h>
#endif

#include "ausnmp.h"
#include "snmp.h"
#include "snmpimpl.h"
#include "asn1.h"

#define PKTSNAP
#include "pktsnap.h"
#include "flowhash.h"

#define APPLETALK

extern char version_descr[];  /* In met_vars.c */
extern unsigned int SampleRate;
extern char *communities[];  /* In snmp/snmpagnt.c */

#define CHUNKSIZE  70000
#define SNAPSIZE   54L  /* Enough for all except CLNS (which needs 70) */

/* SNAP size currently set to 54 to sidestep a bug in Solaris 2.3, 
   which corrupts packets smaller than the SNAP size.  This bug is 
   fixed in Solaris 2.4; if you are using Solaris 2.4 or you should
   set SNAPSIZE to MXPKTHDRLEN.   Nevil, 12 Jul 94 */

void process_pkt(unsigned int pktlen, unsigned char *cp);
int init_interface(void);
void interface_read(int fd);

void process_pkt(unsigned int pktlen, unsigned char *cp)
{
   struct pkt pp;
   unsigned char pkt_type;
   unsigned int b12_13;

   pp.PeerAddrType = AT_DUMMY;
   b12_13 = cp[12]<<8 | cp[13];
   if (b12_13 == 0x0800)
      pkt_extract(&pp, AT_IP, &cp[14]);
   else if (b12_13 <= MAXPKTLEN) {  /* 802.2 packet */
      if (proto_reqd[AT_NOVELL] && cp[14] == 0xFF && cp[15] == 0xFF)
	 pkt_extract(&pp, AT_NOVELL, &cp[14]);
      else if (cp[14] == 0xAA && cp[15] == 0xAA) {  /* SNAP */
	 if (proto_reqd[AT_ETHERTALK] &&
	       cp[20] == 0x80 && cp[21] == 0x9B)
	    pkt_extract(&pp, AT_ETHERTALK, &cp[22]);
	 else if (proto_reqd[AT_NOVELL] &&
	       cp[20] == 0x81 && cp[21] == 0x37)
	    pkt_extract(&pp, AT_NOVELL, &cp[22]);
         else if (proto_reqd[AT_OTHER])
	    pkt_extract(&pp, AT_OTHER, cp);
         }
#ifdef CLNS
      else if (cp[14] == 0xFE && cp[15] == 0xFE) {  /* CLNS */
	 if (proto_reqd[AT_CLNS])
	    pkt_extract(&pp, AT_CLNS, &cp[16]);  /* 1-org ! */
         else if (proto_reqd[AT_OTHER])
            pkt_extract(&pp, AT_OTHER, cp);
            }
#endif
      else if (proto_reqd[AT_NOVELL] &&  /* Novell 802.2 */
	    cp[14] == 0xE0 && cp[15] == 0xE0)
         pkt_extract(&pp, AT_NOVELL, &cp[18]);
                              /* F0F0 is LSAP for NetBIOS */
      else if (proto_reqd[AT_OTHER])
         pkt_extract(&pp, AT_OTHER, cp);
      }
   else if (proto_reqd[AT_DECNET] && b12_13 == 0x6003)
      pkt_extract(&pp, AT_DECNET, &cp[14]);
   else if (proto_reqd[AT_NOVELL] && b12_13 == 0x8137)
      pkt_extract(&pp, AT_NOVELL, &cp[14]);
   else if (proto_reqd[AT_OTHER])
      pkt_extract(&pp, AT_OTHER, cp);

   if (pp.PeerAddrType != AT_DUMMY) {  /* Need to look at this packet */
      if (adj_reqd) {
	 addrcpy(&pp.Low.AdjAddress,&cp[6],MAC_ADDR_LEN);  /* Source */
	 addrcpy(&pp.High.AdjAddress,&cp[0],MAC_ADDR_LEN);  /* Dest */
	 }
      }
   pp.p_len = pktlen;
   pkt_monitor(&pp);
   }

time_t accounting_start_time;  /* Seconds since start of Unix epoch */

unsigned long uptime(void)  /* SNMP time */
{
   return (time(NULL)-accounting_start_time)*100;  /* centiseconds */
   }

void show_meter_time()
{
   char msg[60], *ts;
   ts = ctime(&accounting_start_time);
   sprintf(msg,"%lu seconds since %c%c%c%c:%c%c",
      time(NULL)-accounting_start_time,
      ts[11],ts[12],ts[14],ts[15], ts[17],ts[18]);
   display_msg(0,msg);
   }

extern int  errno;
int	snmp_dump_packet = 0;

void main(argc, argv)
    int	    argc;
    char    *argv[];
{
   int arg,c, sd,if_fd;
   char *ap;
   struct sockaddr_in me;

   printf("%s\n",version_descr);
   display_enabled = kb_enabled = 1;  /* Enabled by default */
   mxflowsp1 = DFMXFLOWS+1;
   accounting_start_time = time(NULL) - 2;  /* So flows have CreateTime > 1 */
   /* Default (CMU) communities are:  0 = "public", 1 = "proxy",
	 2 = "private", 3 = "regional", 4 = "core"
      We only allow "public" and "private" by default */
   communities[1] = communities[3] = communities[4] = "";
   for (c = 0, arg = 1; arg < argc; ++arg) {
      if (argv[arg][0] == '-') {
	 switch (argv[arg][1]) {
	 case 'd':
	    snmp_dump_packet++;
	    break;
	 case 'f':
	    ap = argv[arg]+2;
	    if (*ap == NULL) ap = argv[++arg];
	    mxflowsp1 = atoi(ap)+1;
	    break;
	 case 'k':
	    kb_enabled = 0;  /* -k to disable keyboard */
	    break;
 	 case 'n':
 	    ap = argv[arg]+2;
 	    if (*ap == NULL) ap = argv[++arg];
 	    SampleRate = atoi(ap);
 	    if (SampleRate < 1) SampleRate = 1;
 	    break;
	 case 'r':
	    for (;;) {
	       if (c == 5) {
                  printf("Max of 4 read communities allowed\n");
                  exit(0);
                  }
	       communities[c++] = argv[++arg];
	       if (c == 2) ++c;  /* 2 -> "private" */
	       if (arg == argc-1 || argv[arg+1][0] == '-') break;
               }
	    break;
	 case 's':
	    display_enabled = 0;  /* -s to disable screen */
	    break;
	 case 'w':
	    communities[2] = argv[++arg];  /* -w to set write community */
	    break;
	 default:
	    printf("Invalid option: -%c\n", argv[arg][1]);
	    exit(0);
	    }
	 }
      }
    /* Set up connections */
    sd = socket(AF_INET, SOCK_DGRAM, 0);
    if (sd < 0){
	perror("socket");
	exit(1);
    }
    me.sin_family = AF_INET;
    me.sin_addr.s_addr = INADDR_ANY;
    me.sin_port = htons(SNMP_PORT);
    if (bind(sd, (struct sockaddr *)&me, sizeof(me)) != 0){
	perror("bind");
	exit(2);
    }
    init_monitor();
    init_snmp();
    if_fd = init_interface();
    receive(sd,if_fd);
}

#define TICKS_PER_S    4  /* 0.25s interface timeout -> 4 ticks per second */
#define BKG_INTERVAL  30  /* Seconds */

void zero_pkt_stats()
{
   kilodummypackets = npackets = lostpackets = stats_time = spackets = 0L;
   max_pkt_rate = 0;
   clear_pkt_stats = 0;
   }

receive(sd,int_fd)
    int sd,int_fd;
{
   fd_set fdset;
   char kb_buf[25];
   int ch, count, onesi, gci;
        /* init_interface() sets the read timeout to 0.25 seconds */
        /* If the ethernet is very busy, we'll garbage collect more often */
   unsigned char p;
   unsigned long pd;
   struct timeval t;

   onesi = TICKS_PER_S;  bkgi = BKG_INTERVAL*TICKS_PER_S;
   zero_pkt_stats();
   t.tv_sec = t.tv_usec = 0;
   gci = gc_interval;  /* Garbage collect interval */
   bkgi = BKG_INTERVAL;  /* Background interval */
   gc_f = (mxflowsp1-1)/100;  /* Flow indexes to check */
   if (gc_f < 4) gc_f = 4;
   s_uptime = uptime();  /* Initial value */

   for (;;) {
      interface_read(int_fd);
      if (--onesi == 0) {  /* One-second process .. */
         s_uptime = uptime();  /* Don't do this too often! */
         if (clear_pkt_stats) zero_pkt_stats();
         else {
            ++stats_time;
            pd = (npackets-spackets)*SampleRate;
            if (pd > max_pkt_rate) max_pkt_rate = pd;
            spackets = npackets;
	    }
         if (--gci == 0) {
            garbage_collect(1);  /* Routine incremental collection */
            gci = gc_interval;
            }
         if (--bkgi == 0) {
 	    p = (unsigned long)active_flows()*100/(mxflowsp1-1);
 	    if (p > FloodMark) {  /* % flows active */
 	       display_msg(1,"Flows > FloodMark !!!!!");
 	       }
            else if (p > HighWaterMark) {
 	       display_msg(1,"Flows > HighWaterMark !!!");
 	       more_garbage();
	       }
            bkgi = BKG_INTERVAL*TICKS_PER_S;
            }
         onesi = TICKS_PER_S;
         }

      FD_ZERO(&fdset);
      FD_SET(sd, &fdset);
      if (kb_enabled) FD_SET(0, &fdset);  /* stdin */
      count = select(FD_SETSIZE, &fdset, 0, 0, &t);  /* 0 timeval => poll */
      if (count > 0) {
         if (FD_ISSET(sd, &fdset))
	    snmp_read(sd);

         if (FD_ISSET(0, &fdset)) {  /* stdin */
            fgets(kb_buf, sizeof kb_buf, stdin);
	    if ((ch = kb_buf[0]) == 27) {  /* ESC */
	       display_msg(1,"Shutting down");
               exit(0);
               }
	    switch (tolower(ch)) {
	    case 'v':
	       printf("\n%s\n",version_descr);
	       break;
	    default:
	       handle_kb(ch);
	       break;
	       }
	    }
	 } 
      else switch (count) {
      case 0:
	 break;
      case -1:
	 if (errno == EINTR) continue;
	 else perror("select");
	 return -1;
      default:
	 printf("select returned %d\n", count);
	 return -1;
	 }
      }
   }

unsigned long snmp_peer_addr;

snmp_read(sd)
    int sd;
{
    struct sockaddr_in	from;
    int length, out_length, fromlength;
    char  packet[1500], outpacket[1500];
    char snmp_peer_name[50];  /* Name of host which sent the snmp request */

    fromlength = sizeof from;
    length = recvfrom(sd, packet, 1500, 0, (struct sockaddr *)&from, &fromlength);
    snmp_peer_addr = from.sin_addr.s_addr;
    strcpy(snmp_peer_name,inet_ntoa(from.sin_addr));
    if (length == -1)
	perror("recvfrom");
    if (snmp_dump_packet){
	int count;

	printf("received %d bytes from %s:\n", length, snmp_peer_name);
	for(count = 0; count < length; count++){
	    printf("%02X ", packet[count]);
	    if ((count % 16) == 15)
		printf("\n");
	}
	printf("\n\n");
    }
    out_length = 1500;
    if (snmp_agent_parse(packet, length, outpacket, &out_length, from.sin_addr)){
	if (snmp_dump_packet){
	    int count;

	    printf("sent %d bytes to %s:\n", out_length, snmp_peer_name);
	    for(count = 0; count < out_length; count++){
		printf("%02X ", outpacket[count]);
		if ((count % 16) == 15)
		    printf("\n");
	    }
	    printf("\n\n");
	}
	if (sendto(sd, (char *)outpacket, out_length, 0, (struct sockaddr *)&from,
	    sizeof(from)) < 0){
		perror("sendto");
		return 0;
	}

    }
    
}

