/* 1245, Tue 2 Nov 93

   FLOWHASH.H:  Data structures for AU Meter

   Copyright (C) 1992,1993 by Nevil Brownlee,
   Computer Centre,  University of Auckland */

#define BIG_PEER_ADDR  /* 20-byte peer addresses */
#define noFULL_IPX   /* Net+Host => 10-byte IPX peer addresses */

#if defined(FULL_IPX) || defined(CLNP)
#define BIG_PEER_ADDR
#endif

#ifndef EXTFLOW
#define EXTFLOW  extern
#define DECLARE  0
#define INIT(v)
#else
#define EXTFLOW
#define DECLARE  1
#define INIT(v)  = v
#endif

#ifdef BIG_PEER_ADDR
#define DFMXFLOWS 3000  /* Default max nbr of traffic flows */
#else
#define DFMXFLOWS 4000  /* Default max nbr of traffic flows */
#endif

#define MXCLCTRS    10  /* Max nbr of active Collectors */
#define MXNRTBLS    10  /* Max nbr of rule+action tables */

#define RSTKSIZ     20  /* Max depth of rule matches */
#define HASHMOD    256  /* Size of flow hash tables */
#define MNCGRPSZ     5  /* Min nbr of rules in a compare group */
#define INITHSZ   1500  /* Initial rule_hash size (ints) */
#define FLOWBLOBSZ  55  /* Nbr of {index, info} objects in a column blob */

struct hash_tbl {
   struct flow far *hash_ent[HASHMOD];
   };
   
#define AT_IGNORE     0  /* Addr_type values */
#define AT_DUMMY      1
#define AT_ADJACENT   1

#define AT_IP         2
#define AT_NSAP       3
#define AT_IDPR       4
#define AT_DECNET     5
#define AT_NOVELL     6
#define AT_ETHERTALK  7
#define AT_DETAIL     8

#define PT_ICMP       1  /* IP protocol types */
#define PT_TCP        6
#define PT_UDP       17

#define MAC_ADDR_LEN     6  /* Address lengths */

#define IP_ADDR_LEN      4
#define DN_ADDR_LEN      3
#define ET_ADDR_LEN      3
#ifdef FULL_IPX
#define IPX_ADDR_LEN    10
#else
#define IPX_ADDR_LEN     4
#endif
#define NSAP_ADDR_LEN   20

#define DETAIL_ADDR_LEN  2

#ifdef BIG_PEER_ADDR
#define PEER_ADDR_LEN   20  /* IP, IPX, Decnet, EtherTalk */

#define RULE_ADDR_LEN   20  /* Max of above */
#else
#define PEER_ADDR_LEN    4  /* IP, IPX, Decnet, EtherTalk */

#define RULE_ADDR_LEN    6  /* Max of above */
#endif

EXTFLOW char addr_len[]  /* Lengths for each address type */
#if DECLARE
   = {
      PEER_ADDR_LEN,   /* Default */
      MAC_ADDR_LEN,    /* 1 Adjacent */
      IP_ADDR_LEN,     /* 2 IP */
      NSAP_ADDR_LEN,   /* 3 CLNP */
      4,               /* 4 IDPR */
      DN_ADDR_LEN,     /* 5 DECnet */
      IPX_ADDR_LEN,    /* 6 Novell IPX */
      ET_ADDR_LEN,     /* 7 EtherTalk */
      DETAIL_ADDR_LEN  /* 8 Detail */
      }
#endif
   ;

struct key {
   unsigned char AdjAddress[MAC_ADDR_LEN], AdjMask[MAC_ADDR_LEN];
   unsigned char PeerAddress[PEER_ADDR_LEN], PeerMask[PEER_ADDR_LEN];
   unsigned char DetailAddress[DETAIL_ADDR_LEN], DetailMask[DETAIL_ADDR_LEN];
   };

struct flow {
   union {  /* Must be first to line up with hash_tbl entries */
      struct flow far *action;  /* For aggregates and tallies */
      struct rule far *count;  /* For counts */
      struct hash_tbl far *hash;  /* For tally action entries */
      struct flow far *next;  /* For hash chains */
      } link;
   unsigned long UpOctets,UpPDUs, DownOctets,DownPDUs,
      FirstTime,LastTime;
   unsigned char FlowRuleSet, FlowType;
   unsigned char PeerAddrType, PeerTypeMask,
      DetailAddrType, DetailTypeMask;
   struct key Low, High;
   };

struct flow_key {
   unsigned char PeerAddrType, PeerTypeMask,
      DetailAddrType, DetailTypeMask;
   struct key Low, High;
   };

#define Key(fp)  &fp->PeerAddrType

#define FT_RULE       0  /* Flow types */
#define FT_COUNT      1
#define FT_TALLY      2
#define FT_AGGREGATE  3

EXTFLOW unsigned int nflows,  /* Nbr of flows in use */
   mxflowsp1;  /* Max nbr of flows + 1 */
EXTFLOW struct flow far **flow_ix;  /* The flow table */
   /* Flow 1 is a dummy for the Create and Active tables */
   
EXTFLOW unsigned int empty_ix;  /* Last flow number used by number_flow */

EXTFLOW unsigned int gcf_ix;  /* Next possible flow for garbage collector */

EXTFLOW unsigned char  /* Parameters for garbage collector */
   gc_interval INIT(5),  /* Seconds between calls */
   gc_f INIT(4),  /* Non-zero (in-use) flow indexes */
   gc_e INIT(16);  /* Zero (unused) flow indexes */
EXTFLOW unsigned long GarbageCollectTime,
   /* OK to recover flows with LastTime greater than this */
   FlowsRecovered INIT(0);

struct rule {
   unsigned char RuleSelector;  /* Rule's MIB variables */
   unsigned char RuleMask[RULE_ADDR_LEN];
   unsigned char RuleMatchedValue[RULE_ADDR_LEN];
   unsigned char RuleAction;
   unsigned int  RuleJumpIndex;

   unsigned int  hash_tbl_index;  /* 0 => simple compare */
   unsigned int  hash_link;
   };

EXTFLOW struct flow far *null_flow;  /* All fields zeroed */

EXTFLOW struct rule far *rule_table[MXNRTBLS];
EXTFLOW unsigned int rt_size[MXNRTBLS];
EXTFLOW struct rule far *c_rt;  /* Current Rule Table */
EXTFLOW int c_rsz;  /* Nbr of rules in current rule table */

struct rule_hash_tbl {
   unsigned int group_last;  /* Nbr of last rule in group */
   unsigned int hash_mask;  /* Group hash table size - 1 */
   int hash_ent[1];
   };

EXTFLOW int far *rule_hash;
EXTFLOW unsigned int rh_size;

EXTFLOW struct flow far *action_table[MXNRTBLS];
EXTFLOW unsigned int at_size[MXNRTBLS];
EXTFLOW struct flow far *c_at;  /* Current Action Table */
EXTFLOW int c_asz;  /* Nbr of actions in current action table */

#define RA_COUNT      1  /* RuleAction values */
#define RA_TALLY      2
#define RA_AGGREGATE  3
#define RA_SUCCEED    4
#define RA_FAIL	      5
#define RA_PUSHTO     6
#define RA_POPTO      7
#define RA_GOTO       8
#define RA_GOSUB      9
#define RA_RETURN    10
#define RA_PUSH      11

#define RS_NULL                 0  /* Rule Selector dummy value */

#define FTFLOWINDEX		1  /* Flow table attribute values */
#define FTFLOWSTATUS		2

#define FTLOWINTERFACE          3
#define FTLOWADJACENTTYPE       4
#define FTLOWADJACENTADDRESS    5
#define FTLOWADJACENTMASK       6
#define FTLOWPEERTYPE		7
#define FTLOWPEERTYPEMASK	8
#define FTLOWPEERADDRESS	9
#define FTLOWPEERMASK	       10
#define FTLOWDETAILTYPE        11
#define FTLOWDETAILTYPEMASK    12
#define FTLOWDETAILADDRESS     13
#define FTLOWDETAILMASK        14
#define FTLOWSUBSCRIBERID      15
#define FTLOWSUBSCRIBERMASK    16
#define FTHIINTERFACE          17
#define FTHIADJACENTTYPE       18
#define FTHIADJACENTADDRESS    19
#define FTHIADJACENTMASK       20
#define FTHIPEERTYPE	       21
#define FTHIPEERTYPEMASK       22
#define FTHIPEERADDRESS	       23
#define FTHIPEERMASK	       24
#define FTHIDETAILTYPE         25
#define FTHIDETAILTYPEMASK     26
#define FTHIDETAILADDRESS      27
#define FTHIDETAILMASK         28
#define FTHISUBSCRIBERID       29
#define FTHISUBSCRIBERMASK     30

#define FTSUBSCRIBERID         31
#define FTSUBSCRIBERMASK       32

#define FTPDUSCALE             33
#define FTOCTETSCALE           34
#define FTRULESET              35
#define FTFLOWTYPE             36

#define FTUPOCTETS	       37
#define FTUPPDUS	       38
#define FTDOWNOCTETS	       39
#define FTDOWNPDUS	       40

#define FTFIRSTTIME	       41
#define FTLASTTIME	       42

struct attrib_info {
   char *name;
   unsigned char index;
   unsigned char len;
   };

EXTFLOW struct attrib_info attribs[1+FTLASTTIME]
   /* Serial search -> longest names first! */
#if DECLARE
   = {
      "null",                   0,                     0,
      "flowindex",              FTFLOWINDEX,           2,
      "flowstatus",             FTFLOWSTATUS,          1,
      "sourceinterface",        FTLOWINTERFACE,        1,
      "sourceadjacenttype",     FTLOWADJACENTTYPE,     1,
      "sourceadjacentaddress",  FTLOWADJACENTADDRESS,  MAC_ADDR_LEN,
      "sourceadjacentmask",     FTLOWADJACENTMASK,     MAC_ADDR_LEN,
      "sourcepeertypemask",     FTLOWPEERTYPEMASK,     1,
      "sourcepeertype",         FTLOWPEERTYPE,         1,
      "sourcepeeraddress",      FTLOWPEERADDRESS,      PEER_ADDR_LEN,
      "sourcepeermask",         FTLOWPEERMASK,         PEER_ADDR_LEN,
      "sourcedetailtypemask",   FTLOWDETAILTYPEMASK,   1,
      "sourcedetailtype",       FTLOWDETAILTYPE,       1,
      "sourcedetailaddress",    FTLOWDETAILADDRESS,    DETAIL_ADDR_LEN,
      "sourcedetailmask",       FTLOWDETAILMASK,       DETAIL_ADDR_LEN,
      "sourcesubscriberid",     FTLOWSUBSCRIBERID,     0,
      "sourcesubscribermask",   FTLOWSUBSCRIBERMASK,   0,
      "destinterface",          FTHIINTERFACE,         1,
      "destadjacenttype",       FTHIADJACENTTYPE,      1,
      "destadjacentaddress",    FTHIADJACENTADDRESS,   MAC_ADDR_LEN,
      "destadjacentmask",       FTHIADJACENTMASK,      MAC_ADDR_LEN,
      "destpeertypemask",       FTHIPEERTYPEMASK,      1,
      "destpeertype",           FTHIPEERTYPE,          1,
      "destpeeraddress",        FTHIPEERADDRESS,       PEER_ADDR_LEN,
      "destpeermask",           FTHIPEERMASK,          PEER_ADDR_LEN,
      "destdetailtypemask",     FTHIDETAILTYPEMASK,    1,
      "destdetailtype",         FTHIDETAILTYPE,        1,
      "destdetailaddress",      FTHIDETAILADDRESS,     DETAIL_ADDR_LEN,
      "destdetailmask",         FTHIDETAILMASK,        DETAIL_ADDR_LEN,
      "destsubscriberid",       FTHISUBSCRIBERID,      0,
      "destsubscribermask",     FTHISUBSCRIBERMASK,    0,
      "subscriberid",           FTSUBSCRIBERID,        0,
      "subscribermask",         FTSUBSCRIBERMASK,      0,
      "pduscale",               FTPDUSCALE,            0,
      "octetscale",             FTOCTETSCALE,          0,
      "flowruleset",            FTRULESET,             1,
      "flowtype",               FTFLOWTYPE,            1,
      "tooctets",               FTUPOCTETS,            4,
      "topdus",                 FTUPPDUS,              4,
      "fromoctets",             FTDOWNOCTETS,          4,
      "frompdus",               FTDOWNPDUS,            4,
      "firsttime",              FTFIRSTTIME,           4,
      "lasttime",               FTLASTTIME,            4
   }
#endif
   ;

/* Global Variables */

#define FB_OBJECT_SZ  (2+1+MAC_ADDR_LEN)
#define FB_DATA_SZ    FLOWBLOBSZ*FB_OBJECT_SZ

EXTFLOW unsigned char column_blob[FB_DATA_SZ + 2*(2+1+RULE_ADDR_LEN)];

#ifdef AU_MSDOS  /* PC ntoh routines swap the byte order */
#define netshort(x)  x
#define netlong(x)   x
#else            /* SunOS ntoh routines don't */
#define netshort(x)  htons(x)
#define netlong(x)   htonl(x)
#endif

EXTFLOW unsigned int n_hash_tables INIT(0),  /* Performance statistics */
   n_hash_ents INIT(0), t_hash_size INIT(0);
EXTFLOW unsigned long n_matches INIT(0),
   n_hash_compares INIT(0), n_hash_searches INIT(0);

EXTFLOW unsigned long s_uptime;  /* uptime() value for current sample */

EXTFLOW unsigned char kb_enabled;
EXTFLOW unsigned char display_enabled;

/* MIB variables */

EXTFLOW unsigned long InactivityTimeout INIT(600L);  /* 10 minutes */
EXTFLOW unsigned char HighWaterMark INIT(85);  /* 85 % */
EXTFLOW unsigned char FloodMark INIT(100);  /* Disabled */

struct CTinfo {
   unsigned char LastCollectPeer[PEER_ADDR_LEN];
   unsigned long LastCollectTime;
   unsigned long PrevCollectTime;
   };

EXTFLOW struct CTinfo CTi[MXCLCTRS];
EXTFLOW unsigned char n_collectors INIT(0);

EXTFLOW unsigned long LastCollectTime INIT(0L);

EXTFLOW unsigned char CurrentRuleSet INIT(0);
EXTFLOW unsigned char EmergencyRuleSet INIT(0);

/* Flowhash functions */

#define addrcpy(d,s,n) qmove(s,d,n)  /* Stick to d,s order for copies! */

struct flow far *get_flow(void);
void free_flow(struct flow far *q);

int open_rule_set(unsigned char doSet, unsigned char n);
void close_rule_set(void);

void init_flow(struct flow far *f, unsigned char type);
unsigned int number_flow(struct flow far *fp);
void garbage_collect(void);

struct flow far *find_flow(int x);

struct flow far *search_hash_table(
   struct hash_tbl far *t,  /* Table to search */
   struct key far *Low,  /* Target keys */
   struct key far *High,
   struct flow far *pdu,
   struct flow far *ap,  /* Action with table's masks */
   unsigned char OK_to_add  /* 1 = add new flow if not found */
   );

int pkt_match(unsigned char forward, unsigned char OK_to_match,
   int len, struct flow far *pdu, struct key far *from, struct key far *to);

void build_flow_blob(unsigned long t_time, unsigned int fx);

void pkt_monitor(unsigned char far *pp,int len,unsigned char pt);

void open_log(void);
void write_flows(void);

void show_stats(void);
void show_time(void);

void init_monitor(void);

void show_help(void);
void handle_kb(int ch);

