/* 1229, Fri 15 Jul 94

   MET_VARS.C:  AU Internet Accounting Meter snmp agent
		Based on the CMU snmpd version, snmpd.c

   Copyright (C) 1992-1994 by Nevil Brownlee,
   Computer Centre,  The University of Auckland */

#define noTESTING
#define noGC_TEST

#include "ausnmp.h"

#include <ctype.h>
#include <sys/types.h>

#ifdef AU_MSDOS
#include <alloc.h>
#endif

#if defined(SUNOS) || defined(ULTRIX)  /* NB, 5 Jan 94 */
#include <malloc.h>
#ifdef TESTING
#include "stdio.h"
#endif
#endif

#include "pktsnap.h"
#include "flowhash.h"

#ifdef AU_MSDOS
#include "tcp.h"

#else

#include <nlist.h>  /* BSD include files, used in CMU snmpvars.c */
#include <syslog.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/param.h>
#include <net/if.h>
#include <net/route.h>
#include <netinet/in_pcb.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/tcp.h>
#include <netinet/tcp_timer.h>
#ifdef ULTRIX
#include <xti.h>  /*Included by Anh, took a while to find  5 Jan 94 */
#endif
#include <netinet/tcp_var.h>
#include <netinet/tcp_fsm.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/ip_icmp.h>
#include <netinet/icmp_var.h>

#endif  /* End !AU_MSDOS */

#ifndef NULL
#define NULL 0
#endif

#include "asn1.h"  /* CMU snmp include files */
#include "snmp.h"
#include "snmpimpl.h"
#include "mib.h"

#include "met_vars.h"  /* Constants for snmp oids */

long long_return;

void init_snmp()
{  }

#define INT_ACCT    1, 3, 6, 1, 3, 99
#define U_AUCKLAND  1, 3, 6, 1, 4, 1, 411

char version_descr[] = "NeTraMet: Network Traffic Meter V2.2";
oid version_id[] = {U_AUCKLAND, 1, 2,2};  /* NeTraMet 2.2 */
unsigned int SampleRate = 1;

struct variable     variables[] = {
    /* these must be lexicographly ordered by the name field */
    {{MIB, 1, 1, 0},		9, STRING,  VERSION_DESCR, RONLY, var_system},
    {{MIB, 1, 2, 0},		9, OBJID,   VERSION_ID, RONLY, var_system},
    {{MIB, 1, 3, 0},		9, TIMETICKS, UPTIME, RONLY, var_system},
    {{MIB, 2, 1, 0},		9, INTEGER, IFNUMBER, RONLY, var_system},

   {{INT_ACCT, 1, 1, 0},       9, INTEGER, HIGHWATERMARK, RWRITE, var_system},
   {{INT_ACCT, 1, 2, 0},       9, INTEGER, FLOODMARK, RWRITE, var_system},
   {{INT_ACCT, 1, 3, 0},       9, INTEGER, INACT_TIMEOUT, RWRITE, var_system},
   {{INT_ACCT, 1, 4, 1, MAX_SUBID},    10, INTEGER, SAMPLE_RATE, RWRITE, var_rinfo},
   {{INT_ACCT, 1, 5, 1, 1, MAX_SUBID}, 11, INTEGER, CIINDEX, RONLY, var_rinfo},
   {{INT_ACCT, 1, 5, 1, 2, MAX_SUBID}, 11, STRING, CIPEERADDR, RONLY, var_rinfo},
   {{INT_ACCT, 1, 5, 1, 3, MAX_SUBID}, 11, TIMETICKS, CILASTTIME, RONLY, var_rinfo},
   {{INT_ACCT, 1, 5, 1, 4, MAX_SUBID}, 11, TIMETICKS, CIPREVTIME, RONLY, var_rinfo},
   {{INT_ACCT, 1, 6, 0},       9, TIMETICKS, LAST_COLLECT_TIME, RWRITE, var_system},
   {{INT_ACCT, 1, 7, 1, 1, MAX_SUBID}, 11, INTEGER, RIINDEX, RONLY, var_rinfo},
   {{INT_ACCT, 1, 7, 1, 2, MAX_SUBID}, 11, INTEGER, RIRULESIZE, RWRITE, var_rinfo},
   {{INT_ACCT, 1, 7, 1, 3, MAX_SUBID}, 11, INTEGER, RIACTIONSIZE, RWRITE, var_rinfo},
   {{INT_ACCT, 1, 8, 0},       9, INTEGER, CURRENT_RULE_SET, RWRITE, var_system},
   {{INT_ACCT, 1, 9, 0},       9, INTEGER, EMERGENCY_RULE_SET, RWRITE, var_system},

   {{INT_ACCT, 2, 1, 1,  1, MAX_SUBID}, 11, INTEGER, FTFLOWINDEX, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1,  2, MAX_SUBID}, 11, INTEGER, FTFLOWSTATUS, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1,  3, MAX_SUBID}, 11, INTEGER, FTLOWINTERFACE, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1,  4, MAX_SUBID}, 11, INTEGER, FTLOWADJACENTTYPE, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1,  5, MAX_SUBID}, 11, STRING,  FTLOWADJACENTADDRESS, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1,  6, MAX_SUBID}, 11, STRING,  FTLOWADJACENTMASK, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1,  7, MAX_SUBID}, 11, INTEGER, FTLOWPEERTYPE, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1,  8, MAX_SUBID}, 11, INTEGER, FTLOWPEERTYPEMASK, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1,  9, MAX_SUBID}, 11, STRING,  FTLOWPEERADDRESS, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 10, MAX_SUBID}, 11, STRING,  FTLOWPEERMASK, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 11, MAX_SUBID}, 11, INTEGER, FTLOWDETAILTYPE, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 12, MAX_SUBID}, 11, INTEGER, FTLOWDETAILTYPEMASK, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 13, MAX_SUBID}, 11, STRING,  FTLOWDETAILADDRESS, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 14, MAX_SUBID}, 11, STRING,  FTLOWDETAILMASK, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 17, MAX_SUBID}, 11, INTEGER, FTHIINTERFACE, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 18, MAX_SUBID}, 11, INTEGER, FTHIADJACENTTYPE, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 19, MAX_SUBID}, 11, STRING,  FTHIADJACENTADDRESS, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 20, MAX_SUBID}, 11, STRING,  FTHIADJACENTMASK, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 21, MAX_SUBID}, 11, INTEGER, FTHIPEERTYPE, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 22, MAX_SUBID}, 11, INTEGER, FTHIPEERTYPEMASK, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 23, MAX_SUBID}, 11, STRING,  FTHIPEERADDRESS, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 24, MAX_SUBID}, 11, STRING,  FTHIPEERMASK, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 25, MAX_SUBID}, 11, INTEGER, FTHIDETAILTYPE, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 26, MAX_SUBID}, 11, INTEGER, FTHIDETAILTYPEMASK, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 27, MAX_SUBID}, 11, STRING,  FTHIDETAILADDRESS, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 28, MAX_SUBID}, 11, STRING,  FTHIDETAILMASK, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 33, MAX_SUBID}, 11, INTEGER, FTPDUSCALE, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 34, MAX_SUBID}, 11, INTEGER, FTOCTETSCALE, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 35, MAX_SUBID}, 11, INTEGER, FTRULESET, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 36, MAX_SUBID}, 11, INTEGER, FTFLOWTYPE, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 37, MAX_SUBID}, 11, COUNTER, FTUPOCTETS, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 38, MAX_SUBID}, 11, COUNTER, FTUPPDUS, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 39, MAX_SUBID}, 11, COUNTER, FTDOWNOCTETS, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 40, MAX_SUBID}, 11, COUNTER, FTDOWNPDUS, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 41, MAX_SUBID}, 11, TIMETICKS, FTFIRSTTIME, RONLY, var_ft},
   {{INT_ACCT, 2, 1, 1, 42, MAX_SUBID}, 11, TIMETICKS, FTLASTTIME, RONLY, var_ft},

   {{INT_ACCT, 2, 2, 1, 1, MAX_SUBID, MAX_SUBID}, 12, TIMETICKS, FTCRFIRSTTIME, RONLY, var_flow_index},
   {{INT_ACCT, 2, 2, 1, 2, MAX_SUBID, MAX_SUBID}, 12, INTEGER, FTCRFLOWINDEX, RONLY, var_flow_index},

   {{INT_ACCT, 2, 3, 1, 1, MAX_SUBID, MAX_SUBID}, 12, TIMETICKS, FTACFIRSTTIME, RONLY, var_flow_index},
   {{INT_ACCT, 2, 3, 1, 2, MAX_SUBID, MAX_SUBID}, 12, INTEGER, FTACFLOWINDEX, RONLY, var_flow_index},

   {{INT_ACCT, 2, 4, 1, 1, MAX_SUBID, MAX_SUBID, MAX_SUBID}, 13, INTEGER, FTCOLATTRIB, RONLY, var_col_tbl},
   {{INT_ACCT, 2, 4, 1, 2, MAX_SUBID, MAX_SUBID, MAX_SUBID}, 13, TIMETICKS, FTCOLTIME, RONLY, var_col_tbl},
   {{INT_ACCT, 2, 4, 1, 3, MAX_SUBID, MAX_SUBID, MAX_SUBID}, 13, INTEGER, FTCOLINDEX, RONLY, var_col_tbl},
   {{INT_ACCT, 2, 4, 1, 4, MAX_SUBID, MAX_SUBID, MAX_SUBID}, 13, OPAQUE, FTCOLBLOB, RONLY, var_col_tbl},

   {{INT_ACCT, 3, 1, 1, 1, MAX_SUBID, MAX_SUBID}, 12, INTEGER, RTRULESET, RONLY, var_rt},
   {{INT_ACCT, 3, 1, 1, 2, MAX_SUBID, MAX_SUBID}, 12, INTEGER, RTRULEINDEX, RONLY, var_rt},
   {{INT_ACCT, 3, 1, 1, 3, MAX_SUBID, MAX_SUBID}, 12, INTEGER, RTSELECTOR, RWRITE, var_rt},
   {{INT_ACCT, 3, 1, 1, 4, MAX_SUBID, MAX_SUBID}, 12, STRING, RTRULEMASK, RWRITE, var_rt},
   {{INT_ACCT, 3, 1, 1, 5, MAX_SUBID, MAX_SUBID}, 12, STRING, RTMATCHVALUE, RWRITE, var_rt},
   {{INT_ACCT, 3, 1, 1, 6, MAX_SUBID, MAX_SUBID}, 12, INTEGER, RTRULEACTION, RWRITE, var_rt},
   {{INT_ACCT, 3, 1, 1, 7, MAX_SUBID, MAX_SUBID}, 12, INTEGER, RTJUMPINDEX, RWRITE, var_rt},

   {{INT_ACCT, 4, 1, 1,  1, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATACTIONINDEX, RONLY, var_rt},
   {{INT_ACCT, 4, 1, 1,  3, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATLOWINTERFACE, RONLY, var_rt},
   {{INT_ACCT, 4, 1, 1,  4, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATLOWADJACENTTYPE, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1,  5, MAX_SUBID, MAX_SUBID}, 12, STRING,  ATLOWADJACENTADDRESS, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1,  6, MAX_SUBID, MAX_SUBID}, 12, STRING,  ATLOWADJACENTMASK, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1,  7, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATLOWPEERTYPE, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1,  8, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATLOWPEERTYPEMASK, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1,  9, MAX_SUBID, MAX_SUBID}, 12, STRING,  ATLOWPEERADDRESS, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 10, MAX_SUBID, MAX_SUBID}, 12, STRING,  ATLOWPEERMASK, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 11, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATLOWDETAILTYPE, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 12, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATLOWDETAILTYPEMASK, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 13, MAX_SUBID, MAX_SUBID}, 12, STRING,  ATLOWDETAILADDRESS, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 14, MAX_SUBID, MAX_SUBID}, 12, STRING,  ATLOWDETAILMASK, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 17, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATHIINTERFACE, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 18, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATHIADJACENTTYPE, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 19, MAX_SUBID, MAX_SUBID}, 12, STRING,  ATHIADJACENTADDRESS, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 20, MAX_SUBID, MAX_SUBID}, 12, STRING,  ATHIADJACENTMASK, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 21, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATHIPEERTYPE, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 22, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATHIPEERTYPEMASK, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 23, MAX_SUBID, MAX_SUBID}, 12, STRING,  ATHIPEERADDRESS, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 24, MAX_SUBID, MAX_SUBID}, 12, STRING,  ATHIPEERMASK, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 25, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATHIDETAILTYPE, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 26, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATHIDETAILTYPEMASK, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 27, MAX_SUBID, MAX_SUBID}, 12, STRING,  ATHIDETAILADDRESS, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 28, MAX_SUBID, MAX_SUBID}, 12, STRING,  ATHIDETAILMASK, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 33, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATPDUSCALE, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 34, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATOCTETSCALE, RWRITE, var_rt},
   {{INT_ACCT, 4, 1, 1, 35, MAX_SUBID, MAX_SUBID}, 12, INTEGER, ATACTIONSET, RWRITE, var_rt},

   {{U_AUCKLAND, 1,  1, 0},  10, INTEGER, MSSTATSRESET, RWRITE, var_system},
   {{U_AUCKLAND, 1,  2, 0},  10, INTEGER, MSSTATSTIME, RONLY, var_system},
   {{U_AUCKLAND, 1,  3, 0},  10, INTEGER, MSNPACKETS, RONLY, var_system},
   {{U_AUCKLAND, 1,  4, 0},  10, INTEGER, MSTBACKLOG, RONLY, var_system},
   {{U_AUCKLAND, 1,  5, 0},  10, INTEGER, MSMXPKTRATE, RONLY, var_system},
   {{U_AUCKLAND, 1,  6, 0},  10, INTEGER, MSMXBACKLOG, RONLY, var_system},
   {{U_AUCKLAND, 1,  7, 0},  10, INTEGER, MSNFLOWS, RONLY, var_system},
   {{U_AUCKLAND, 1,  8, 0},  10, INTEGER, MSFLOWSRCV, RONLY, var_system},
   {{U_AUCKLAND, 1,  9, 0},  10, INTEGER, MSNMATCHES, RONLY, var_system},
   {{U_AUCKLAND, 1, 10, 0},  10, INTEGER, MSHASHSRCHS, RONLY, var_system},
   {{U_AUCKLAND, 1, 11, 0},  10, INTEGER, MSHASHCMPS, RONLY, var_system},
   {{U_AUCKLAND, 1, 12, 0},  10, INTEGER, MSTHASHSZ, RONLY, var_system},
   {{U_AUCKLAND, 1, 13, 0},  10, INTEGER, MSNHASHENTS, RONLY, var_system},
   {{U_AUCKLAND, 1, 14, 0},  10, INTEGER, MSGCINTERVAL, RWRITE, var_system},
   {{U_AUCKLAND, 1, 15, 0},  10, INTEGER, MSMXFLOWS, RONLY, var_system},
   {{U_AUCKLAND, 1, 16, 0},  10, INTEGER, MSAVIDLEPER1000, RONLY, var_system},
   {{U_AUCKLAND, 1, 17, 0},  10, INTEGER, MSMINIDLEPER1000, RONLY, var_system},

   {{U_AUCKLAND, 2, 1, 0},   10, INTEGER, PCNEARMEM, RONLY, var_system},
   {{U_AUCKLAND, 2, 2, 0},   10, INTEGER, PCFARMEM, RONLY, var_system},
   {{U_AUCKLAND, 2, 3, 0},   10, INTEGER, PCBADPKTS, RONLY, var_system},
   {{U_AUCKLAND, 2, 4, 0},   10, INTEGER, PCNOBUFPKTS, RONLY, var_system},
   {{U_AUCKLAND, 2, 5, 0},   10, INTEGER, PCLOSTPKTS, RONLY, var_system},
   };

int
compare(name1, len1, name2, len2)
    register oid	    *name1, *name2;
    register int	    len1, len2;
{
    register int    len;
    /* len = minimum of len1 and len2 */
    if (len1 < len2)
	len = len1;
    else
	len = len2;
    /* find first non-matching byte */
    while(len-- > 0){
	if (*name1 < *name2)
	    return -1;
	if (*name2++ < *name1++)
	    return 1;
    }
    /* bytes match up to length of shorter string */
    if (len1 < len2)
	return -1;  /* name1 shorter, so it is "less" */
    if (len2 < len1)
	return 1;
    return 0;	/* both strings are equal */
}

/*
 * getStatPtr - return a pointer to the named variable, as well as it's
 * type, length, and access control list.
 *
 * If an exact match for the variable name exists, it is returned.  If not,
 * and exact is false, the next variable lexicographically after the
 * requested one is returned.
 *
 * If no appropriate variable can be found, NULL is returned.
 */
u_char far *
getStatPtr(name, namelen, type, len, acl, exact, access_method)
    oid		*name;	    /* IN - name of var, OUT - name matched */
    int		*namelen;   /* IN -number of sub-ids in name, OUT - subid-is in matched name */
    u_char	*type;	    /* OUT - type of matched variable */
    int		*len;	    /* OUT - length of matched variable */
    u_short	*acl;	    /* OUT - access control list */
    int		exact;	    /* IN - TRUE if exact match wanted */
    int		*access_method; /* OUT - 1 if function, 0 if char * */
{
    register struct variable	*vp;
    register int	x;
    u_char far		*access;
    int			result;
    register int	minlen;
    register oid	*name1, *name2;
   int b,t;

   b = 0;  t = sizeof(variables)/sizeof(struct variable) - 1;
   do {  /* Binary search averages about 6 compares instead of 22 */
      x = (b + t)/2;
      vp = &variables[x];
      result = compare(name, *namelen, vp->name, (int)vp->namelen);
      if (result < 0) t = x-1;  /* Move top down */
      else b = x+1; /* Move bottom up */
      } while (b <= t);

   for (x = t, vp = &variables[x];
	 x < sizeof(variables)/sizeof(struct variable);  ++vp, ++x) {
   /* Find first vp entry >= requested one */
      result = compare(name, *namelen, vp->name, (int)vp->namelen);
      if ((result < 0) || (exact && (result == 0))) {
	 access = (*(vp->findVar))(vp, name, namelen, exact, len, access_method);
	 if (access != NULL) {
	    *type = vp->type;
	    *acl = vp->acl;
	    return access;
	    }
	 }
      }

   return NULL;
   }

extern unsigned long snmp_peer_addr;  /* Declared in meter_pc.c */

void display_msg(unsigned char timestamp, char *msg)
{
#ifdef AU_MSDOS
   if (display_enabled) {
      scpos(0,24);
      if (timestamp) printf("%02d%02d:%02d  ", tod_h,tod_m,tod_s);
      else printf("   ");
      printf(msg);
      w_roll(0,7, 40,24, 1);
      }
#else
   time_t t; char *ts;
   if (display_enabled) {
      if (timestamp) {
         time(&t);  ts = ctime(&t);
         printf("%c%c%c%c:%c%c  ", 
            ts[11],ts[12],ts[14],ts[15], ts[17],ts[18]);
         }
      else printf("   ");
      printf("%s\n",msg);
      }
#endif
   }

int writechar(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP);
int writeint(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP);
int writelong(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP);
int writeAddress(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP);

int writeRuleSet(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP);
int writeRuleSize(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP);
int writeActionSize(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP);
int writeLastCollectTime(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP);
int writeStatsReset(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP);

u_char far *
var_system(vp, name, length, exact, var_len, write_method)
    register struct variable *vp;   /* IN - pointer to variable entry that points here */
    register oid	*name;	    /* IN/OUT - input name requested, output name found */
    register int	*length;    /* IN/OUT - length of input and output oid's */
    int			exact;	    /* IN - TRUE if an exact match was requested. */
    int			*var_len;   /* OUT - length of variable or 0 if function returned. */
    int			(**write_method)(); /* OUT - 1 if function, 0 if char pointer. */
{
#ifndef AU_MSDOS
    struct timeval now, boottime;
#endif
   unsigned long dummy;

    if (exact && (compare(name, *length, vp->name, (int)vp->namelen) != 0))
	return NULL;
    bcopy((char far *)vp->name, (char far *)name, (int)vp->namelen * sizeof(oid));
    *length = vp->namelen;
    *write_method = 0;
    *var_len = sizeof(long);	/* default length */
   switch (vp->magic){
   case VERSION_DESCR:
      *var_len = strlen(version_descr);
      return (u_char far *)version_descr;
   case VERSION_ID:
      *var_len = sizeof(version_id);
      return (u_char far *)version_id;
   case UPTIME:
      long_return = uptime();
      return (u_char far *)&long_return;
   case IFNUMBER:
      long_return = 1;  /* 1 ethernet card to start with */
      return (u_char far *)&long_return;

   case HIGHWATERMARK:
      *write_method = (int (*)())writechar;
      *var_len = sizeof(unsigned char);
      return (u_char far *)&HighWaterMark;
   case FLOODMARK:
      *write_method = (int (*)())writechar;
      *var_len = sizeof(unsigned char);
      return (u_char far *)&FloodMark;
   case INACT_TIMEOUT:
      *write_method = (int (*)())writelong;
      return (u_char far *)&InactivityTimeout;
   case LAST_COLLECT_TIME:
      *write_method = (int (*)())writeLastCollectTime;
      return (u_char far *)&LastCollectTime;
   case CURRENT_RULE_SET:
      *write_method = (int (*)())writeRuleSet;
      *var_len = sizeof(unsigned char);
      return (u_char far *)&CurrentRuleSet;
   case EMERGENCY_RULE_SET:
      *write_method = (int (*)())writeRuleSet;
      *var_len = sizeof(unsigned char);
      return (u_char far *)&EmergencyRuleSet;

   case MSSTATSRESET:
      *write_method = (int (*)())writeStatsReset;
      long_return = 0;
      return (u_char far *)&long_return;
   case MSSTATSTIME:
      return (u_char far *)&stats_time;
   case MSNPACKETS:
      return (u_char far *)&npackets;
   case MSTBACKLOG:
      return (u_char far *)&t_backlog;
   case MSMXPKTRATE:
      *var_len = sizeof(unsigned int);
      return (u_char far *)&max_pkt_rate;
   case MSMXBACKLOG:
      *var_len = sizeof(unsigned int);
      return (u_char far *)&max_pkt_backlog;
   case MSNFLOWS:
      *var_len = sizeof(unsigned int);
      return (u_char far *)&nflows;
   case MSFLOWSRCV:
      return (u_char far *)&FlowsRecovered;
   case MSNMATCHES:
      return (u_char far *)&n_matches;
   case MSHASHSRCHS:
      return (u_char far *)&n_hash_searches;
   case MSHASHCMPS:
      return (u_char far *)&n_hash_compares;
   case MSTHASHSZ:
      *var_len = sizeof(unsigned int);
      return (u_char far *)&t_hash_size;
   case MSNHASHENTS:
      *var_len = sizeof(unsigned int);
      return (u_char far *)&n_hash_ents;
   case MSGCINTERVAL:
      *write_method = (int (*)())writechar;
      *var_len = sizeof(unsigned char);
      return (u_char far *)&gc_interval;
   case MSMXFLOWS:
      long_return = mxflowsp1-1;  /* Set at meter startup */
      return (u_char far *)&long_return;
   case MSAVIDLEPER1000:
#ifdef AU_MSDOS
      long_return = kilodummypackets;
      if (dummypackets >= 500) ++long_return;
      long_return = long_return*1000L/(long_return+npackets/1000L);
#else
      long_return = 0;
#endif
      return (u_char far *)&long_return;
   case MSMINIDLEPER1000:
#ifdef AU_MSDOS
      long_return = (mindummyrate*10000L+5L)/((mindummyrate+mdpacketrate)*10L);
#else
      long_return = 0;
#endif
      return (u_char far *)&long_return;

#ifdef AU_MSDOS
   case PCNEARMEM:
      long_return = (long)coreleft();
      return (u_char far *)&long_return;
   case PCFARMEM:
      long_return = (long)farcoreleft();
      return (u_char far *)&long_return;
   case PCBADPKTS:
      return (u_char far *)&badpackets;
   case PCNOBUFPKTS:
      return (u_char far *)&nobufpackets;
   case PCLOSTPKTS:
      return (u_char far *)&lostpackets;
#else
   case PCLOSTPKTS:
      long_return = 0;
      return (u_char far *)&long_return;
#endif

   default:
      ERROR("");
      }
   return NULL;
   }

int string_OK(t)
int t;
{
   if (t != STRING) {
      display_msg(1,"Not string");  return FALSE;
      }
   return TRUE;
   }

int int_OK(t)
int t;
{
   if (t != INTEGER){
      display_msg(1,"Not integer");  return FALSE;
      }
   return TRUE;
   }

int writelong(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP)
{
   int bigsize = 1000;
   long intval = 0;
   if (!int_OK(var_val_type)) return FALSE;
   asn_parse_int(var_val, &bigsize, &var_val_type, &intval, sizeof(intval));
   if (intval < 0) {
      display_msg(1,"Bad long");  return FALSE;
      }
   if (doSet) *((long far *)statP) = intval;
   return TRUE;
  }

int writeint(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP)
{
   int bigsize = 1000;
   long intval = 0;
   unsigned int i;
   if (!int_OK(var_val_type)) return FALSE;
   asn_parse_int(var_val, &bigsize, &var_val_type, &intval, sizeof(intval));
   if (intval < 0 || intval > 0xFFFF) {
      display_msg(1,"Bad int");  return FALSE;
      }
   if (doSet) {
      i = (int)intval;
      *((int far *)statP) = i;
      }
   return TRUE;
  }

int writechar(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP)
{
   int bigsize = 1000;
   long intval = 0;
   unsigned char c;
   if (!int_OK(var_val_type)) return FALSE;
   asn_parse_int(var_val, &bigsize, &var_val_type, &intval, sizeof(intval));
   if (intval < 0 || intval > 0xFF) {
      display_msg(1,"Bad char");  return FALSE;
      }
   if (doSet) {
      c = (char)intval;
      *((char far *)statP) = c;
      }
   return TRUE;
  }

int writeAddress(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP)
{
   int size, bigsize = 1000;
   u_char buf[RULE_ADDR_LEN];

   if (!string_OK(var_val_type)) return FALSE;
   size = sizeof(buf);
   asn_parse_string(var_val, &bigsize, &var_val_type, buf, &size);
   if (size > var_val_len) {
      display_msg(1,"Bad Address");  return FALSE;
      }
   if (doSet) {
      addrcpy(statP, buf, size);
      }
   return TRUE;
   }

int writeRuleSet(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP)
{
   int bigsize = 1000;
   long intval = 0;
   char msg[30];
   if (!int_OK(var_val_type)) return FALSE;
   asn_parse_int(var_val, &bigsize, &var_val_type, &intval, sizeof(intval));
   if (intval < 1 || intval > MXNRTBLS) {
      display_msg(1,"Bad RuleSet");  return FALSE;
      }
   if (intval == CurrentRuleSet) return TRUE;  /* No change needed */
   if (doSet) {
      if (statP == (unsigned char far *)&CurrentRuleSet) {
	 if (!open_rule_set(0, intval)) {
	    display_msg(1,"Incomplete RuleSet");  return FALSE;
	    }
	 else {
	    close_rule_set();
	    open_rule_set(1,intval);
	    sprintf(msg,"Rule set %d opened", intval);
	    display_msg(1,msg);
	    }
	 }
      else {
	 sprintf(msg,"Emergency rule set %d", EmergencyRuleSet = intval);
	 display_msg(1,msg);
	 }
      }
   return TRUE;
   }

unsigned char info_table_index;  /* Set by var_rinfo() */

int writeRuleSize(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP)
{
   int bigsize = 1000, j;
   long intval = 0;
   char msg[30];
   struct rule far *rt;

   if (!int_OK(var_val_type)) return FALSE;
   asn_parse_int(var_val, &bigsize, &var_val_type, &intval, sizeof(intval));
   if (info_table_index == CurrentRuleSet) {
      display_msg(1,"Can't modify current rules");  return FALSE;
      }
   if (info_table_index < 2) {
      display_msg(1,"Can't modify default rules");  return FALSE;
      }
   if (doSet) {
      if (intval > rt_size[info_table_index-1]) {  /* Needs to be bigger */
	 if (rt_size[info_table_index-1] != 0)
	    farfree(rule_table[info_table_index-1]);
	 rt = (struct rule far *)farmalloc(sizeof(struct rule)*intval);
	 if (rt == NULL) {
	    display_msg(1,"No mem for rule table");  return FALSE;
	    }
	 rule_table[info_table_index-1] = rt;
	 rt_size[info_table_index-1] = intval;
	 }
      else rt = rule_table[info_table_index-1];
      for (j = 0; j != intval; ++j, ++rt) {
	 bcopy((unsigned char far *)null_flow,
	    (unsigned char far *)rt, sizeof(struct rule));
	 }
      sprintf(msg,"rt[%d]: %d rules", info_table_index,intval);
      display_msg(1,msg);
      }
   return TRUE;
   }

int writeActionSize(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP)
{
   int bigsize = 1000, j;
   long intval = 0;
   char msg[30];
   struct flow far *at;

   if (!int_OK(var_val_type)) return FALSE;
   asn_parse_int(var_val, &bigsize, &var_val_type, &intval, sizeof(intval));
   if (info_table_index == CurrentRuleSet) {
      display_msg(1,"Can't modify current actions");  return FALSE;
      }
   if (info_table_index < 2) {
      display_msg(1,"Can't modify default actions");  return FALSE;
      }
   if (doSet) {
      if (intval > at_size[info_table_index-1]) {  /* Needs to be bigger */
	 if (at_size[info_table_index-1] != 0)
	    farfree(action_table[info_table_index-1]);
	 at = (struct flow far *)farmalloc(sizeof(struct flow)*intval);
	 if (at == NULL) {
	    display_msg(1,"No mem for action table");  return FALSE;
	    }
	 action_table[info_table_index-1] = at;
	 at_size[info_table_index-1] = intval;
	 }
      else at = action_table[info_table_index-1];
      for (j = 0; j != intval; ++j, ++at) {
	 bcopy((unsigned char far *)Key(null_flow),
	    (unsigned char far *)Key(at), sizeof(struct flow_key));
	 }
      sprintf(msg,"at[%d]: %d actions", info_table_index,intval);
      display_msg(1,msg);
      }
   return TRUE;
   }

int writeLastCollectTime(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP)
{
   int bigsize = 1000;
   unsigned char j;
   long intval = 0;
   char msg[30];
   unsigned char CollectPeer[4];
   struct CTinfo *ctip;

   if (var_val_type != TIMETICKS) {
      display_msg(1,"Not timeticks");  return FALSE;
      }
   asn_parse_int(var_val, &bigsize, &var_val_type, &intval, sizeof(intval));
   if (doSet) {
      CollectPeer[0] = snmp_peer_addr >> 24;
      CollectPeer[1] = (snmp_peer_addr >> 16) & 0xFF;
      CollectPeer[2] = (snmp_peer_addr >>  8) & 0xFF;
      CollectPeer[3] = snmp_peer_addr & 0xFF;
      for (j = 0; j != n_collectors; ++j) {
	 ctip = &CTi[j];
	 if (qcmp((unsigned char far *)ctip->LastCollectPeer,
	    (unsigned char far *)CollectPeer, IP_ADDR_LEN) == 0);
	       break;
	 }
      if (j == n_collectors) {  /* New collector */
	 ctip = &CTi[n_collectors++];
	 bcopy((unsigned char far *)CollectPeer,
	    (unsigned char far *)ctip->LastCollectPeer, IP_ADDR_LEN);
	 }
      ctip->PrevCollectTime = ctip->LastCollectTime;
      ctip->LastCollectTime = LastCollectTime = s_uptime;

      GarbageCollectTime = LastCollectTime < InactivityTimeout ? 0
	 : LastCollectTime-InactivityTimeout;  /* Must be >= 0 */
      for (j = 0; j != n_collectors; ++j) {
	 ctip = &CTi[j];
	 if (ctip->PrevCollectTime < GarbageCollectTime)
	    GarbageCollectTime = ctip->PrevCollectTime;
	 }

      sprintf(msg,"Collection by %d.%d.%d.%d",
	 CollectPeer[0],CollectPeer[1],CollectPeer[2],CollectPeer[3]);
      display_msg(1,msg);
#ifdef GC_TEST
      printf("uptime=%lu, GCtime=%lu\n",
	 LastCollectTime,GarbageCollectTime);
#endif
      }
   return TRUE;
   }

int writeStatsReset(int doSet, u_char *var_val,
   u_char var_val_type, int var_val_len, u_char far *statP)
{
   int bigsize = 1000;
   unsigned char j;
   long intval = 0;
   if (!int_OK(var_val_type)) return FALSE;
   asn_parse_int(var_val, &bigsize, &var_val_type, &intval, sizeof(intval));
   if (doSet) zero_stats();
   return TRUE;
   }

u_char far *	/* acctControl info tables */
var_rinfo(vp, name, length, exact, var_len, write_method)
    register struct variable *vp;   /* IN - pointer to variable entry that points here */
    register oid	*name;	    /* IN/OUT - input name requested, output name found */
    register int	*length;    /* IN/OUT - length of input and output oid's */
    int			exact;	    /* IN - TRUE if an exact match was requested. */
    int			*var_len;   /* OUT - length of variable or 0 if function returned. */
    int			(**write_method)(); /* OUT - 1 if function, 0 if char pointer. */
{
   unsigned char tblsz,x_loc;
   oid newname[MAX_NAME_LEN];
   unsigned int x;
   struct flow far *t;
#ifdef TESTING
   unsigned char j;
   int cmp;
#endif

   switch ((unsigned char)name[7]) {
   case 4:  /* Sampling Rate */
      tblsz = 1;  /* Only one interface so far */
      x_loc = 9;
      break;
   case 5:  /* Collector Info */
      tblsz = n_collectors;
      x_loc = 10;
      break;
   case 7:  /* Rule Set Info */
      tblsz = MXNRTBLS;
      x_loc = 10;
      break;
      }
   x = (unsigned int)name[x_loc];  /* Index value */
   info_table_index = x;  /* For rule- and action-size write routines */
#ifdef TESTING
   scpos(0,24);
   printf("\nvar_rinfo(): exact=%d, control=%d, xloc=%d, x=%d, tblsz=%d, magic=%d\n   name=",
      exact,(unsigned char)name[7],x_loc,x,tblsz,vp->magic);
   for (j = 0; j != *length; ++j) printf(".%d",name[j]);
   printf("\n");
#endif
   bcopy((char far *)vp->name, (char far *)newname, x_loc*sizeof(oid));

   if (exact) {
      if (x > tblsz) return NULL;
      newname[x_loc] = (oid)x;
      if (compare(name,*length, newname,(int)vp->namelen) != 0) return NULL;
      }
   else {
      if (compare(name,x_loc, newname,x_loc) != 0) x = 0;
      for (++x;  x <= tblsz;  ++x) {
	 newname[x_loc] = (oid)x;
#ifdef TESTING
	 cmp = compare(name, *length, newname, (int)vp->namelen);
	 printf("x=%d, cmp=%d ", x,cmp);
	 for (j = 0; j != (int)vp->namelen; ++j) printf(".%d",newname[j]);
	 printf("\n");
	 if (cmp < 0) break;
#else
	 if (compare(name, *length, newname, (int)vp->namelen) < 0) break;
#endif
	 }
      if (x > tblsz) return NULL;
      }

   bcopy((char far *)newname, (char far *)name, (int)vp->namelen * sizeof(oid));
   *length = (int)vp->namelen;

   *var_len = sizeof(long);
   *write_method = 0;
   switch (vp->magic) {
   case RIINDEX:
   case CIINDEX:
      long_return = (long)x;
      return (u_char *)&long_return;
   case RIRULESIZE:
      *write_method = (int (*)())writeRuleSize;
      *var_len = sizeof(unsigned int);
      return (u_char far *)&rt_size[x-1];
   case RIACTIONSIZE:
      *write_method = (int (*)())writeActionSize;
      *var_len = sizeof(unsigned int);
      return (u_char far *)&at_size[x-1];

   case CIPEERADDR:
      *var_len = IP_ADDR_LEN;
      return (u_char far *)CTi[x-1].LastCollectPeer;
   case CILASTTIME:
      return (u_char far *)&CTi[x-1].LastCollectTime;
   case CIPREVTIME:
      return (u_char far *)&CTi[x-1].PrevCollectTime;

   case SAMPLE_RATE:
      *write_method = (int (*)())writeint;
      *var_len = sizeof(unsigned int);
      return (u_char far *)&SampleRate;

   default:
      ERROR("");
      }
   return NULL;
   }

unsigned char *putshort(unsigned char *d, unsigned int n)
{
   *d++ = (n >> 8) & 0xFF;
   *d++ = n & 0xFF;
   return d;
   }

unsigned char *putlong(unsigned char *d, unsigned long n)
{
   *d++ = (n >> 24) & 0xFF;
   *d++ = (n >> 16) & 0xFF;
   *d++ = (n >> 8) & 0xFF;
   *d++ = n & 0xFF;
   return d;
   }

unsigned char *putvariable(unsigned char *d, unsigned int *sz,
   unsigned char far *s, unsigned char type)
{
   unsigned int len;
   len = addr_len[type];
   while (len != 0 && s[len-1] == 0) --len;
   *d++ = len;  bcopy(s, (unsigned char far *)d, len);
   *sz = 1+len;  return d+len;
   }

u_char far *	/* Flow table */
var_ft(vp, name, length, exact, var_len, write_method)
    register struct variable *vp;   /* IN - pointer to variable entry that points here */
    register oid	*name;	    /* IN/OUT - input name requested, output name found */
    register int	*length;    /* IN/OUT - length of input and output oid's */
    int			exact;	    /* IN - TRUE if an exact match was requested. */
    int			*var_len;   /* OUT - length of variable or 0 if function returned. */
    int			(**write_method)(); /* OUT - 1 if function, 0 if char pointer. */
{
   oid newname[MAX_NAME_LEN];
   unsigned int x;
   struct flow far *t;
   unsigned char pal;

   bcopy((char far *)vp->name, (char far *)newname, (int)vp->namelen * sizeof(oid));

   if (exact) {
      newname[10] = name[10];
      x = (unsigned int)newname[10];
      if (compare(name,*length, newname,(int)vp->namelen) != 0  /* No match */
	 || (t = find_flow(x)) == NULL)  /* Doesn't exist */
	 return NULL;
      }
   else {
      x = compare(name,10, newname,10) != 0  /* Not in this ptTable column */
	 ? 1  /* Have to search whole table */
	 : (unsigned int)name[10];  /* Only search from specified row */
      for (++x;  x <= mxflowsp1;  ++x) {
	 if ((t = find_flow(x)) == NULL)  /* Ignore deallocated flows */
	    continue;
	 newname[10] = (oid)x;
	 if (compare(name, *length, newname, (int)vp->namelen) < 0) break;
	 }
      if (x > mxflowsp1) return NULL;
      }

   bcopy((char far *)newname, (char far *)name, (int)vp->namelen * sizeof(oid));
   *length = (int)vp->namelen;

   *write_method = 0;
   *var_len = sizeof(long);
   pal = addr_len[t->PeerAddrType];
   switch (vp->magic) {
   case FTFLOWINDEX:
      long_return = (long)x;
      return (u_char *)&long_return;
   case FTFLOWSTATUS:
      long_return = find_flow(x) != NULL;
      return (u_char far *)&long_return;
   case FTLOWINTERFACE:
   case FTHIINTERFACE:
   case FTLOWADJACENTTYPE:
   case FTHIADJACENTTYPE:
      long_return = 1;
      return (u_char far *)&long_return;
   case FTLOWADJACENTADDRESS:
      *var_len = MAC_ADDR_LEN;
      return (u_char far *)&t->Low.AdjAddress;
   case FTLOWADJACENTMASK:
      *var_len = MAC_ADDR_LEN;
      return (u_char far *)&t->Low.AdjMask;
   case FTLOWPEERTYPE:
   case FTHIPEERTYPE:
      *var_len = sizeof(unsigned char);
      return (u_char far *)&t->PeerAddrType;
   case FTLOWPEERTYPEMASK:
   case FTHIPEERTYPEMASK:
      *var_len = sizeof(unsigned char);
      return (u_char far *)&t->PeerTypeMask;
   case FTLOWPEERADDRESS:
      *var_len = pal;
      return (u_char far *)&t->Low.PeerAddress;
   case FTLOWPEERMASK:
      *var_len = pal;
      return (u_char far *)&t->Low.PeerMask;
   case FTLOWDETAILTYPE:
   case FTHIDETAILTYPE:
      *var_len = sizeof(unsigned char);
      return (u_char far *)&t->DetailAddrType;
   case FTLOWDETAILTYPEMASK:
   case FTHIDETAILTYPEMASK:
      *var_len = sizeof(unsigned char);
      return (u_char far *)&t->DetailTypeMask;
   case FTLOWDETAILADDRESS:
      *var_len = DETAIL_ADDR_LEN;
      return (u_char far *)&t->Low.DetailAddress;
   case FTLOWDETAILMASK:
      *var_len = DETAIL_ADDR_LEN;
      return (u_char far *)&t->Low.DetailMask;
   case FTHIADJACENTADDRESS:
      *var_len = MAC_ADDR_LEN;
      return (u_char far *)&t->High.AdjAddress;
   case FTHIADJACENTMASK:
      *var_len = MAC_ADDR_LEN;
      return (u_char far *)&t->High.AdjMask;
   case FTHIPEERADDRESS:
      *var_len = pal;
      return (u_char far *)&t->High.PeerAddress;
   case FTHIPEERMASK:
      *var_len = pal;
      return (u_char far *)&t->High.PeerMask;
   case FTHIDETAILADDRESS:
      *var_len = DETAIL_ADDR_LEN;
      return (u_char far *)&t->High.DetailAddress;
   case FTHIDETAILMASK:
      *var_len = DETAIL_ADDR_LEN;
      return (u_char far *)&t->High.DetailMask;
   case FTRULESET:
      *var_len = sizeof(unsigned char);
      return (u_char far *)&t->FlowRuleSet;
   case FTFLOWTYPE:
      *var_len = sizeof(unsigned char);
      return (u_char far *)&t->FlowType;
   case FTUPOCTETS:
      return (u_char far *)&t->UpOctets;
   case FTUPPDUS:
      return (u_char far *)&t->UpPDUs;
   case FTDOWNOCTETS:
      return (u_char far *)&t->DownOctets;
   case FTDOWNPDUS:
      return (u_char far *)&t->DownPDUs;
   case FTFIRSTTIME:
      return (u_char far *)&t->FirstTime;
   case FTLASTTIME:
      return (u_char far *)&t->LastTime;

   default:
      ERROR("");
      }
   return NULL;
   }

u_char far *	/* Creation and activity tables */
var_flow_index(vp, name, length, exact, var_len, write_method)
    register struct variable *vp;   /* IN - pointer to variable entry that points here */
    register oid	*name;	    /* IN/OUT - input name requested, output name found */
    register int	*length;    /* IN/OUT - length of input and output oid's */
    int			exact;	    /* IN - TRUE if an exact match was requested. */
    int			*var_len;   /* OUT - length of variable or 0 if function returned. */
    int			(**write_method)(); /* OUT - 1 if function, 0 if char pointer. */
{
   unsigned char create;
   unsigned long t_time;  /* 'Target' time */
   unsigned int x;
   oid newname[MAX_NAME_LEN];
   struct flow far *t;
#ifdef TESTING
   unsigned char j;
#endif

   create = name[7] == 2;  /* acct.2.2.1 = CreateTime */
   t_time = (unsigned long)name[10];
   x = (unsigned int)name[11];
   bcopy((char far *)vp->name, (char far *)newname, (int)vp->namelen * sizeof(oid));
#ifdef TESTING
   scpos(0,24);
   printf("flow_index(): exact=%d, create=%d, t=%lu, x=%d\n      name=",
      exact,create,t_time,x);
   for (j = 0; j != *length; ++j) printf(".%d",name[j]);
   printf("\n");
#endif

   if (exact) {
      if (compare(name, *length-2, newname, (int)vp->namelen-2) != 0)
	 return NULL;
      for ( ;  x <= mxflowsp1;  ++x) {
	 if ((t = find_flow(x)) == NULL)  /* Ignore deallocated flows */
	    continue;
	 if (create) {
	    if (t->FirstTime > t_time)  /* Created after target time */
	       break;
	    }
	 else if (t->LastTime > t_time)  /* Active after target time */
	    break;
	 }
      newname[10] = t_time;  newname[11] = (oid)x;
      }
   else {  /* Does oid match up to indexes? */
      if (compare(name,10, newname,10) != 0) {    /* No - find first entry */
	 t_time = 1L;  /* Have to search whole flow table */
	 x = 1;  /* Flow 1 is a dummy - never used by meter */
	 }
      for (++x;  x <= mxflowsp1;  ++x) {
	 if ((t = find_flow(x)) == NULL)  /* Ignore deallocated flows */
	    continue;
	 if (create) {
	    if (t->FirstTime <= t_time)  /* Created up to target time */
	       continue;
	    }
	 else if (t->LastTime <= t_time)  /* Active up to target time */
	    continue;
	 newname[10] = t_time;  newname[11] = (oid)x;
	 if (compare(name, *length, newname, (int)vp->namelen) < 0) break;
	 }
      }
   if (x > mxflowsp1) return NULL;  /* No more flows to search */
      /* Only allow getnext to go through flow table once! */

   bcopy((char far *)newname, (char far *)name, (int)vp->namelen * sizeof(oid));
   *length = (int)vp->namelen;

   *write_method = 0;
   *var_len = sizeof(long);
   switch (vp->magic) {
   case FTCRFIRSTTIME:
      return (u_char far *)&t->FirstTime;
   case FTCRFLOWINDEX:
      long_return = (long)x;
      return (u_char far *)&long_return;
   case FTACFIRSTTIME:
      return (u_char far *)&t->LastTime;
   case FTACFLOWINDEX:
      long_return = (long)x;
      return (u_char far *)&long_return;
      }
   return NULL;
   }

u_char far *	/* Activity Column Table */
var_col_tbl(vp, name, length, exact, var_len, write_method)
    register struct variable *vp;   /* IN - pointer to variable entry that points here */
    register oid	*name;	    /* IN/OUT - input name requested, output name found */
    register int	*length;    /* IN/OUT - length of input and output oid's */
    int			exact;	    /* IN - TRUE if an exact match was requested. */
    int			*var_len;   /* OUT - length of variable or 0 if function returned. */
    int			(**write_method)(); /* OUT - 1 if function, 0 if char pointer. */
{
   unsigned long t_time;  /* 'Target' time */
   unsigned int x,n, sz;
   unsigned char a;
   oid newname[MAX_NAME_LEN];
   unsigned char *ucp;
   struct flow far *t;
#ifdef TESTING
   unsigned char j;
#endif

   a = (unsigned char)name[10];
   t_time = (unsigned long)name[11];
   x = (unsigned int)name[12];
#ifdef TESTING
   scpos(0,24);
   printf("col_tbl(): exct=%d, a=%d, t=%lu, x=%d\n      name=",
      exact,a,t_time,x);
   for (j = 0; j != *length; ++j) printf(".%d",name[j]);
   printf("\n");
#endif
   bcopy((char far *)vp->name, (char far *)newname, 10*sizeof(oid));
   if (exact) {
      if (compare(name, 10, newname, 10) != 0) return NULL;
      if (a < FTFLOWINDEX || a > FTLASTTIME) return NULL;
      newname[10] = (oid)a;
      for ( ;  x <= mxflowsp1;  ++x) {
	 if ((t = find_flow(x)) == NULL)  /* Ignore deallocated flows */
	    continue;
	 if (t->LastTime > t_time)  /* Active after target time */
	    break;
	 }
      newname[11] = (oid)t_time;  newname[12] = (oid)x;
      }
   else {  /* Does oid match up to indexes? */
      if (compare(name,10, newname,10) != 0) {    /* No - find first entry */
	 a = FTLOWPEERTYPE;
	 t_time = 1L;  /* Have to search whole flow table */
	 x = 1;  /* Flow 1 is a dummy - never used by meter */
	 }
      else if (a > FTLASTTIME) return NULL;
      newname[10] = (oid)a;
      for (++x;  x <= mxflowsp1;  ++x) {
	 if ((t = find_flow(x)) == NULL)  /* Ignore deallocated flows */
	    continue;
	 if (t->LastTime <= t_time)  /* Active up to target time */
	    continue;
	 newname[11] = (oid)t_time;  newname[12] = (oid)x;
	 if (compare(name, *length, newname, (int)vp->namelen) < 0) break;
	 }
      }
   if (x > mxflowsp1) return NULL;  /* No more flows to search */
      /* Only allow getnext to go through flow table once! */

   bcopy((char far *)newname, (char far *)name, (int)vp->namelen * sizeof(oid));
   *length = (int)vp->namelen;

   *write_method = 0;
   *var_len = sizeof(long);
   switch (vp->magic) {
   case FTCOLATTRIB:
      long_return = (long)a;
      return (u_char far *)&long_return;
   case FTCOLTIME:
      return (u_char far *)&t->LastTime;
   case FTCOLINDEX:
      long_return = (long)x;
      return (u_char far *)&long_return;
   case FTCOLBLOB:
      for (n = 0, ucp = column_blob;  /* Build the flow blob */
	    n <= FB_DATA_SZ;  ++x) {
	 for ( ; x <= mxflowsp1;  ++x) {  /* Find next active flow */
	    if ((t = find_flow(x)) != NULL && t->LastTime > t_time) {
	       ucp = putshort(ucp,netshort(x));
	       sz = attribs[a].len;
	       switch (a) {  /* Build the flow blob */
	       case FTFLOWINDEX:
		  ucp = putshort(ucp,netshort(x));
		  break;
	       case FTFLOWSTATUS:
	       case FTLOWINTERFACE:
	       case FTHIINTERFACE:
	       case FTLOWADJACENTTYPE:
	       case FTHIADJACENTTYPE:
		  *ucp++ = 1;
		  break;
	       case FTLOWADJACENTADDRESS:
		  bcopy(t->Low.AdjAddress,
		     (unsigned char far *)ucp, MAC_ADDR_LEN);
		  ucp += MAC_ADDR_LEN;
		  break;
	       case FTLOWADJACENTMASK:
		  bcopy(t->Low.AdjMask,
		     (unsigned char far *)ucp, MAC_ADDR_LEN);
		  ucp += MAC_ADDR_LEN;
		  break;
	       case FTLOWPEERTYPE:
	       case FTHIPEERTYPE:
		  *ucp++ = t->PeerAddrType;
		  break;
	       case FTLOWPEERTYPEMASK:
	       case FTHIPEERTYPEMASK:
		  *ucp++ = t->PeerTypeMask;
		  break;
	       case FTLOWPEERADDRESS:
		  ucp = putvariable(ucp,&sz,
		     t->Low.PeerAddress,t->PeerAddrType);
		  break;
	       case FTLOWPEERMASK:
		  ucp = putvariable(ucp,&sz,
		     t->Low.PeerMask,t->PeerAddrType);
		  break;
	       case FTLOWDETAILTYPE:
	       case FTHIDETAILTYPE:
		  *ucp++ = t->DetailAddrType;
		  break;
	       case FTLOWDETAILTYPEMASK:
	       case FTHIDETAILTYPEMASK:
		  *ucp++ = t->DetailTypeMask;
		  break;
	       case FTLOWDETAILADDRESS:
		  bcopy(t->Low.DetailAddress,
		     (unsigned char far *)ucp, DETAIL_ADDR_LEN);
		  ucp += DETAIL_ADDR_LEN;
		  break;
	       case FTLOWDETAILMASK:
		  bcopy(t->Low.DetailMask,
		     (unsigned char far *)ucp, DETAIL_ADDR_LEN);
		  ucp += DETAIL_ADDR_LEN;
		  break;
	       case FTHIADJACENTADDRESS:
		  bcopy(t->High.AdjAddress,
		     (unsigned char far *)ucp, MAC_ADDR_LEN);
		  ucp += MAC_ADDR_LEN;
		  break;
	       case FTHIADJACENTMASK:
		  bcopy(t->High.AdjMask,
		     (unsigned char far *)ucp, MAC_ADDR_LEN);
		  ucp += MAC_ADDR_LEN;
		  break;
	       case FTHIPEERADDRESS:
		  ucp = putvariable(ucp,&sz,
		     t->High.PeerAddress,t->PeerAddrType);
		  break;
	       case FTHIPEERMASK:
		  ucp = putvariable(ucp,&sz,
		     t->High.PeerMask,t->PeerAddrType);
		  break;
	       case FTHIDETAILADDRESS:
		  bcopy(t->High.DetailAddress,
		     (unsigned char far *)ucp, DETAIL_ADDR_LEN);
		  ucp += DETAIL_ADDR_LEN;
		  break;
	       case FTHIDETAILMASK:
		  bcopy(t->High.DetailMask,
		     (unsigned char far *)ucp, DETAIL_ADDR_LEN);
		  ucp += DETAIL_ADDR_LEN;
		  break;
	       case FTRULESET:
		  *ucp++ = t->FlowRuleSet;
		  break;
	       case FTFLOWTYPE:
		  *ucp++ = t->FlowType;
		  break;
	       case FTUPOCTETS:
		  ucp = putlong(ucp,netlong(t->UpOctets));
		  break;
	       case FTUPPDUS:
		  ucp = putlong(ucp,netlong(t->UpPDUs));
		  break;
	       case FTDOWNOCTETS:
		  ucp = putlong(ucp,netlong(t->DownOctets));
		  break;
	       case FTDOWNPDUS:
		  ucp = putlong(ucp,netlong(t->DownPDUs));
		  break;
	       case FTFIRSTTIME:
		  ucp = putlong(ucp,netlong(t->FirstTime));
		  break;
	       case FTLASTTIME:
		  ucp = putlong(ucp,netlong(t->LastTime));
		  break;
		  }
	       n += 2+sz;
	       break;
	       }
	    }
	 if (x > mxflowsp1) {
	    if (!exact) name[12] = mxflowsp1;
	       /* Return index of last possible flow */
	    putshort(ucp,0);  /* Mark end of column */
	    *var_len = n+2;
	    return (u_char far *)&column_blob;
	    }
	 }
      if (!exact) name[12] = (oid)x;
	 /* Return index of last flow in blob */
      putshort(ucp,1);  /* Mark end of this blob (more to come) */
      *var_len = n+2;
      return (u_char far *)&column_blob;
      }
   return NULL;
   }

u_char far *	/* Rule + action tables */
var_rt(vp, name, length, exact, var_len, write_method)
    register struct variable *vp;   /* IN - pointer to variable entry that points here */
    register oid	*name;	    /* IN/OUT - input name requested, output name found */
    register int	*length;    /* IN/OUT - length of input and output oid's */
    int			exact;	    /* IN - TRUE if an exact match was requested. */
    int			*var_len;   /* OUT - length of variable or 0 if function returned. */
    int			(**write_method)(); /* OUT - 1 if function, 0 if char pointer. */
{
   unsigned char rule_rq, rule_set;
   unsigned int x, sz;
   oid newname[MAX_NAME_LEN];
   struct rule far *r, far *rt;
   struct flow far *a, far *at;
#ifdef TESTING
   unsigned char j;
   int cmp;
#endif

   rule_rq =  /* acct.3 = rule table, acct.4 = action table */
      (unsigned int)name[6] == 3;
#ifdef TESTING
   rule_set = name[10];
   x = (unsigned int)name[11];
   scpos(0,24);
   printf("var_rt(): exact=%d, rule=%d, set=%d, x=%d\n   name=",
      exact,rule_rq,rule_set,x);
   for (j = 0; j != *length; ++j) printf(".%d",name[j]);
   printf("\n");
#endif
   bcopy((char far *)vp->name, (char far *)newname, 10*sizeof(oid));
   if (exact) {
      if ((rule_set = name[10]) > MXNRTBLS) return NULL;
      x = (unsigned int)name[11];
      if (rule_rq) {
	 if ((rt = rule_table[rule_set-1]) == NULL) return NULL;
	 if (x > (sz = rt_size[rule_set-1])) return NULL;
	 }
     else {
	 if ((at = action_table[rule_set-1]) == NULL) return NULL;
	 if (x > (sz = at_size[rule_set-1])) return NULL;
	 }
      newname[10] = (oid)rule_set;  newname[11] = (oid)x;
      if (compare(name,*length, newname,(int)vp->namelen) != 0) return NULL;
      if (rule_rq) {
	 if ((r = &rt[x-1]) == NULL) return NULL;
	 }
      else {
	 if ((a = &at[x-1]) == NULL) return NULL;
	 }
      }
   else {
      if (compare(name,10, newname,10) != 0) {  /* Not in this table column */
	 rule_set = 1;  x = 1;  /* Have to search whole 2-D table */
	 }
      else {
	 rule_set = name[10];  x = (unsigned int)name[11];
	 }
      for ( ; ; ++rule_set, x = 0) {
	 if (rule_set > MXNRTBLS) return NULL;
	 if (rule_rq) {
	    if ((rt = rule_table[rule_set-1]) == NULL) continue;
	    if (x >= (sz = rt_size[rule_set-1])) continue;
	    }
	 else {
	    if ((at = action_table[rule_set-1]) == NULL) continue;
	    if (x >= (sz = at_size[rule_set-1])) continue;
	    }
	 newname[10] = (oid)rule_set;
	 for (++x; x <= sz; ++x) {
	    if (rule_rq) {
	       if ((r = &rt[x-1]) == NULL) continue;
	       }
	    else {
	       if ((a = &at[x-1]) == NULL) continue;
	       }
	    newname[11] = (oid)x;
#ifdef TESTING
	    cmp = compare(name, *length, newname, (int)vp->namelen);
	    printf("x=%d, cmp=%d ", x,cmp);
	    for (j = 0; j != (int)vp->namelen; ++j) printf(".%d",newname[j]);
	    printf("\n");
	    if (cmp < 0) break;
#else
	    if (compare(name, *length, newname, (int)vp->namelen) < 0) break;
#endif
	    }
	 if (x <= sz) break;  /* Found the next one! */
	 }
      }

   bcopy((char far *)newname, (char far *)name, (int)vp->namelen * sizeof(oid));
   *length = (int)vp->namelen;

#ifdef TESTING
#ifdef AU_MSDOS
if (rule_rq) printf("   rt[%d], address=%Fp, x=%d\n", rule_set, r, x);
else printf("   at[%d], address=%Fp, x=%d\n", rule_set, a, x);
#else
if (rule_rq) printf("   rt[%d], address=%lu, x=%d\n", rule_set, r, x);
else printf("   at[%d], address=%lu, x=%d\n", rule_set, a, x);
fflush(stdout);
#endif
#endif
   *write_method = 0;
   *var_len = sizeof(long);
   switch (vp->magic) {
   case RTRULESET:
   case ATACTIONSET:
      long_return = (long)rule_set;
      return (u_char far *)&long_return;
   case RTRULEINDEX:
   case ATACTIONINDEX:
      long_return = (long)x;
      return (u_char far *)&long_return;

   case RTSELECTOR:
      *write_method = (int (*)())writechar;
      *var_len = sizeof(unsigned char);
      return (u_char far *)&r->RuleSelector;
   case RTRULEMASK:
      *write_method = (int (*)())writeAddress;
      *var_len = RULE_ADDR_LEN;
      return (u_char far *)&r->RuleMask;
   case RTMATCHVALUE:
      *write_method = (int (*)())writeAddress;
      *var_len = RULE_ADDR_LEN;
      return (u_char far *)&r->RuleMatchedValue;
   case RTRULEACTION:
      *write_method = (int (*)())writechar;
      *var_len = sizeof(unsigned char);
      return (u_char far *)&r->RuleAction;
   case RTJUMPINDEX:
      *write_method = (int (*)())writeint;
      *var_len = sizeof(unsigned int);
      return (u_char far *)&r->RuleJumpIndex;

   case ATLOWINTERFACE:
   case ATHIINTERFACE:
      break;  /* Interface 1 is the only one! */

   case ATLOWADJACENTTYPE:
   case ATHIADJACENTTYPE:
      break;  /* Ethernet is the only adjacent type! */
   case ATLOWADJACENTADDRESS:
      *write_method = (int (*)())writeAddress;
      *var_len = MAC_ADDR_LEN;
      return (u_char far *)&a->Low.AdjAddress;
   case ATLOWADJACENTMASK:
      *write_method = (int (*)())writeAddress;
      *var_len = MAC_ADDR_LEN;
      return (u_char far *)&a->Low.AdjMask;

   case ATLOWPEERTYPE:
   case ATHIPEERTYPE:
      *write_method = (int (*)())writechar;
      *var_len = sizeof(unsigned char);
      return (u_char far *)&a->PeerAddrType;
   case ATLOWPEERTYPEMASK:
   case ATHIPEERTYPEMASK:
      *write_method = (int (*)())writechar;
      *var_len = sizeof(unsigned char);
      return (u_char far *)&a->PeerTypeMask;
   case ATLOWPEERADDRESS:
      *write_method = (int (*)())writeAddress;
      *var_len = PEER_ADDR_LEN;
      return (u_char far *)&a->Low.PeerAddress;
   case ATLOWPEERMASK:
      *write_method = (int (*)())writeAddress;
      *var_len = PEER_ADDR_LEN;
      return (u_char far *)&a->Low.PeerMask;

   case ATLOWDETAILTYPE:
   case ATHIDETAILTYPE:
      *write_method = (int (*)())writechar;
      *var_len = sizeof(unsigned char);
      return (u_char far *)&a->DetailAddrType;
   case ATLOWDETAILTYPEMASK:
   case ATHIDETAILTYPEMASK:
      *write_method = (int (*)())writechar;
      *var_len = sizeof(unsigned char);
      return (u_char far *)&a->DetailTypeMask;
   case ATLOWDETAILADDRESS:
      *write_method = (int (*)())writeAddress;
      *var_len = DETAIL_ADDR_LEN;
      return (u_char far *)&a->Low.DetailAddress;
   case ATLOWDETAILMASK:
      *write_method = (int (*)())writeAddress;
      *var_len = DETAIL_ADDR_LEN;
      return (u_char far *)&a->Low.DetailMask;

   case ATHIADJACENTADDRESS:
      *write_method = (int (*)())writeAddress;
      *var_len = MAC_ADDR_LEN;
      return (u_char far *)&a->High.AdjAddress;
   case ATHIADJACENTMASK:
      *write_method = (int (*)())writeAddress;
      *var_len = MAC_ADDR_LEN;
      return (u_char far *)&a->High.AdjMask;

   case ATHIPEERADDRESS:
      *write_method = (int (*)())writeAddress;
      *var_len = PEER_ADDR_LEN;
      return (u_char far *)&a->High.PeerAddress;
   case ATHIPEERMASK:
      *write_method = (int (*)())writeAddress;
      *var_len = PEER_ADDR_LEN;
      return (u_char far *)&a->High.PeerMask;

   case ATHIDETAILADDRESS:
      *write_method = (int (*)())writeAddress;
      *var_len = DETAIL_ADDR_LEN;
      return (u_char far *)&a->High.DetailAddress;
   case ATHIDETAILMASK:
      *write_method = (int (*)())writeAddress;
      *var_len = DETAIL_ADDR_LEN;
      return (u_char far *)&a->High.DetailMask;

   case ATPDUSCALE:
   case ATOCTETSCALE:
      break;  /* Not yet implemented */

   default:
      ERROR("");
      }
   return NULL;
   }
