;
; while macro

;(define while 
  (macro (while cnd body)
     (define (loop)
        (if cnd 
	    (begin
	      body
	      (loop))))
     (loop))

;
; for macro
(macro (for start cnd step body)
  start
  (while cnd (begin body step)))
;
;
; list-from  (list-from <list> <index>)
;
(define (list-from lst ind)
  (if (= ind 0)
      lst
    (list-from (cdr lst) (dec ind))))
;
;
; list-to (list-to <list> <len>
;
(define (list-to lst len)
  (if (= len 0)
      ()
    (cons (car lst) (list-to (cdr lst) (dec len)))))


