/**********************************************************************
** MODULE INFORMATION*
**********************
**      FILE     NAME:       SCHTST.C
**      SYSTEM   NAME:       SCHEME
**      ORIGINAL AUTHOR(S):  Alfred Kayser
**                           Jan van Oorschot
**      VERSION  NUMBER:     1.5.5
**      CREATION DATE:       88/02/29
**
** DESCRIPTION: Test main module for the SCHEME system.
**              Contains dummy "main".
***********************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** CHANGER:     $Author:   ALFRED  $
** WORKFILE:    $Workfile:   schtst.c  $
** LOGFILE:     $Logfile:   C:/CPROG/SCHEME/VCS/SCHTST.C_V  $
** LOGINFO:     $Log:   C:/CPROG/SCHEME/VCS/SCHTST.C_V  $
**              
**                 Rev 1.0   12 Oct 1989 11:45:14   ALFRED
**              Initial revision.
**********************************************************************/
#include <fcntl.h>
#ifndef UNIX
#include <io.h>
#endif
#include "schinc.h"         /* needed for DScheme.lib */

STATIC void PASCAL werror  __((CONST char *mes));
STATIC void PASCAL quit    __((int ret_code));

void DSdefglob __((int schnr,char **schargs));
static int iSilent;

/***************************************************************
** NAME:        main
** SYNOPSIS:    void main(argc,argv)
**              int argc;
**              char **argv;
** DESCRIPTION: Initializes the SCHEME system for a test drive
** RETURNS:     Error code
** SEE ALSO:    Scheme
***************************************************************/
GLOBAL *job1=NIL;

void main(argc,argv)
int argc;
char **argv;
{
    LONG numcels,numstr;
    char *schargs[32];
    char *filargs[32];
    int  schnr,filnr;
    char *cPtr;
    int iCnt;
    char *cpPrompt;
    int iCtrlc;

    cpPrompt = "\nSAGE=> ";
    iSilent = 0;

    numcels=6550L; /*default*/
    numstr=10000L; /*default*/
    /* handle arguments */
    iCnt=1;
    filnr = schnr = 0;
    while( iCnt < argc )
    {
	if( argv[iCnt][0] == '-')
	{
	    /* this is an option, handle it */
	    switch(argv[iCnt][1])
	    {
		case 'n':
		/* keep silent */
		iSilent = !iSilent;
		cpPrompt = "";
		iCnt++;
		break;
	      case 's':
		/* string space size */
		if(argv[iCnt][2]!='\0')
		{
		    cPtr = argv[iCnt] + 2;
		    iCnt++;
		}
		else
		{
		    cPtr = argv[iCnt+1];
		    iCnt+=2;
		}
		numstr=atol(cPtr);
		break;
	      case 'c':
		/* number of cells */
		if(argv[iCnt][2]!='\0')
		{
		    cPtr = argv[iCnt] + 2;
		    iCnt++;
		}
		else
		{
		    cPtr = argv[iCnt+1];
		    iCnt+=2;
		}
		numcels=atol(cPtr);
		break;
	      case 'f':
		/* scheme file to load */
		if(argv[iCnt][2]!='\0')
		{
		    cPtr = argv[iCnt] + 2;
		    iCnt++;
		}
		else
		{
		    cPtr = argv[iCnt+1];
		    iCnt+=2;
		}
		filargs[filnr++]=cPtr;
		break;
	      default:
		/* unknown option */
		fprintf(stderr,"unknown option %c",argv[iCnt][1]);
		iCnt++;
		break;
	    }
	    
	}
	else
	{
	    /* this is a single argument, add it to scheme args */
	    schargs[schnr++]=argv[iCnt++];
	}
    }
    
#ifndef MSDOS
    setvbuf(stdin,NULL,_IONBF,0);/*force immediate flushing of each character */
    setvbuf(stdout,NULL,_IONBF,0); /* stderr is already unbufferd */
#endif
    if(!iSilent)
    {
	info();
	iCtrlc = S_CTRLC;
    }
    else
    {
	iCtrlc = 0;
    }

    if (DSinit(&job1, S_NUMCEL,    numcels,
                      S_STRING,    numstr,
                      S_STACK,     8000,
                      S_HASHSIZE,  997,
                      S_PROMPT,    cpPrompt,
	              S_VERBOSE,   !iSilent,
                      iCtrlc,
                      0)==S_OKAY)
    {
        if (DSmath(job1)!=S_OKAY ||
            DSextend(job1)!=S_OKAY ||
	    DSsage(job1) != S_OKAY)
            werror("Errors detected while initializing DScheme\n");
	DSdefglob(schnr,schargs);
        DScheme(job1);
    }
    quit(0);
}

void DSdefglob(schnr,schargs)
int schnr;
char **schargs;
{
    CELP argc,argv,list;
    int iCnt;
    
    /* define global scheme variables ARGC and ARGV */
    argc = DsSymbol("ARGC");
    argv = DsSymbol("ARGV");
    CARpart(argc) = DSINTCEL(schnr);
    TAGpart(argc) = TYPE_SYMD;
    
    list = NIL;
    for(iCnt=schnr-1 ; iCnt >=0 ; iCnt--)
	list = DsCons(DsStrCell(schargs[iCnt]),list);
    CARpart(argv) = list;
    TAGpart(argv) = TYPE_SYMD;
}

    

/***************************************************************
** NAME:        DSGCmessage
** SYNOPSIS:    void DSGCmessage(global,mesnr)
**              GLOBAL *global; Pointer to environment
**              int mesnr;      Message nummer
** DESCRIPTION: To be supplied by the user. This function is
**              called by the garbage collector to indicate its
**              progress. Mesnr can be: GCstart,GCrun and GSstop
**              These are defined in scheme.h
** RETURNS:     void
***************************************************************/
void PASCAL DSGCmessage(nr)
int nr;
{
#ifndef SAGE
    static int smiley='\\';
    if (nr==GCstop)         /* end of GC? */
        putchar(' ');
    else
    {
        putchar(smiley);
        smiley ^= '\\'^'/';
    }
    putchar('\b');
#endif
}


STATIC void PASCAL werror(mes)
CONST char *mes;
{
    fprintf(stderr,"SCHTST: %s\n",mes);
    quit(1);
}


STATIC void PASCAL quit(ret_code)
int ret_code;
{
    if (job1)
    {
	if (!iSilent)
	  DsOutf(job1->soutport,"Back to %s\n",SYSTEEM);
        DSclose(&job1);
    }
    exit(ret_code);
}

