 /************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       mgt.c
**     SYSTEM   NAME:       SNMP Management Module
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1
**     CREATION DATE:       1990/11/22
**
** DESCRIPTION: SNMP Management Module
**
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   mgt.c  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/SNMP/SNMP/VCS/MGT.C_V  $
**
**                 Rev 1.0   26 Nov 1990 16:38:02   etstjan
**              ipdate
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/SNMP/SNMP/VCS/MGT.C_V   1.0   26 Nov 1990 16:38:02   etstjan  $";
#endif
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include "snmp.h"
#include "error.h"
#include "pkt.h"


/**************************************************************
** NAME:        MgtAdr
** SYNOPSIS:    long unsigned
**                  MgtAdr
**                  (
**                      char        *Hst
**                  )
** DESCRIPTION: Translates hostname or address to IP address.
**              Parameters:
**              Hst: IP hostname or address in string.
** RETURNS:     0xFFFFFFFF --> error
**              else           IP address
**************************************************************/
unsigned long MgtAdr (Hst)
char    *Hst;
{
    struct hostent
        *Ent;
    long unsigned
        Adr;

    Ent = gethostbyname (Hst);
    if (Ent != NULL)
        Adr = *((long unsigned *)(Ent->h_addr_list [0]));
    else
        Adr = inet_addr (Hst);
    return (Adr);
}


/**************************************************************
** NAME:        MgtOpn                                    [API]
** SYNOPSIS:    mgt_sck
**                  *MgtOpn
**                  (
**                      short       Prt,
**                      long        Adr
**                  )
** DESCRIPTION: Opens a managent station.
**              Parameters:
**              Prt: IP Port.
**              Adr: IP Address.
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
mgt_sck *MgtOpn (Prt,Adr)
int     Prt;
long    Adr;
{
    IPS_IPA
        Sin;
    mgt_sck
        *Sck;

    if ((Sck = (mgt_sck *)malloc (sizeof (mgt_sck))) == NULL)
    {
        ERR_ERR (ERR_MGT, ERR_CRITICAL, "No buffer\n");
        return (NULL);
    }
    Sin.sin_family = AF_INET;
    Sin.sin_port = Prt;
    Sin.sin_addr.s_addr = Adr;
    if ((Sck->SckBsd = socket (AF_INET, SOCK_DGRAM, 0)) == IPS_ERR)
    {
        ERR_ERR (ERR_MGT, ERR_CRITICAL, "No socket\n");
        return (NULL);
    }
    if (connect (Sck->SckBsd, (IPS_ADR *)&Sin, sizeof (IPS_IPA)) < 0)
    {
        ERR_ERR (ERR_MGT, ERR_CRITICAL, "Cannot connect socket\n");
        return (NULL);
    }
    Sck->SckAdr = Adr;
    Sck->SckRid = 0;
    return (Sck);
}

/**************************************************************
** NAME:        MgtRqs                                    [API]
** SYNOPSIS:    int
**                  MgtRqs
**                  (
**                      mgt_sck         *Sck,     
**                      pkt_msg         *Msg,
**                      long unsigned   Tio,   
**                      unsigned        Rtr
**                  )
** DESCRIPTION: Sends a request.
**              Parameters:
**              Sck: Socket created with MgtOpn.
**              Msg: Request message.
**              Tio: Time out in micro sec.
**              Rtr: Retries.
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
int MgtRqs (Sck,Msg,Tio,Rtr)                             
mgt_sck         *Sck;
pkt_msg         *Msg;
long unsigned   Tio;
unsigned        Rtr;
{
    pkt_ror
        *Ror;
    char
        Rqs [MGT_SZEPKT], Rsp [MGT_SZEPKT], *RqsBeg, *RspBeg;
    int
        RqsLen, RspLen;
    unsigned long
        Len;
    fd_set fdvar;
    struct timeval to;

    Ror = &Msg->MsgPdu.PduRor;
    Ror->RorRid = ++(Sck->SckRid);
    Ror->RorErrSts = 0;
    Ror->RorErrInd = 0;
    RqsBeg = Rqs;
    RqsLen = MGT_SZEPKT;
    if (PktEnc (Sck->SckAdr, Msg, &RqsBeg, (unsigned *)&RqsLen) < 0)
    {
        ERR_ERR (ERR_MGT, ERR_CRITICAL, "Cannot encode request\n");
        return (-1);
    }
    while (Rtr-- > 0)
    {
        if (send (Sck->SckBsd, RqsBeg, RqsLen, 0) < 0)
	{
	    ERR_ERR (ERR_MGT, ERR_WARNING, "Send failed\n");
	    continue;
	}

	/* JvO replace ioctl by select call */
	to.tv_sec = Tio / 1000000L;
	to.tv_usec = Tio % 1000000L;
	
	FD_ZERO(&fdvar);
	FD_SET(Sck->SckBsd,&fdvar);
	select(Sck->SckBsd+1,&fdvar,NULL,NULL,&to);

	while ((ioctl (Sck->SckBsd, FIONREAD, (char *)&Len), (int)Len) > 0)
        {
            RspBeg = Rsp;
            RspLen = MGT_SZEPKT;
            if ((RspLen = recv (Sck->SckBsd, RspBeg, RspLen, 0)) < 0)
	    {
		ERR_ERR (ERR_MGT, ERR_WARNING, "Nothing received\n");
		continue;
	    }
	    if (PktDec (Sck->SckAdr, Msg, RspBeg, RspLen) < 0)
	    {
		ERR_ERR (ERR_MGT, ERR_WARNING, "Cannot decode\n");
		continue;
	    }
	    if (Ror->RorRid != Sck->SckRid)
            {
		ERR_ERR (ERR_MGT, ERR_WARNING, "Wrong requestid\n");
		continue;
	    }
	    return (0);
        }
    }
    ERR_ERR (ERR_MGT, ERR_CRITICAL, "Cannot receive response\n");
    return (-2);
}

/**************************************************************
** NAME:        MgtCls                                    [API]
** SYNOPSIS:    int
**                  MgtCls
**                  (
**                      mgt_sck *Sck
**                  )
** DESCRIPTION: Closes a management station.
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
int MgtCls (Sck)
mgt_sck *Sck;
{
    IPS_CLS (Sck->SckBsd);
    free (Sck);
    return (0);
}
