#! /bin/csh -f

#
# This is a command file to build a host table format file for JvNCnet
# gateways based on information from the domain system (via DNSQ)
#


## #  #   #    #     #      #       #      #     #    #   #  # ##
#
echo		"Getting data from DNS for all JvNCnet hosts..."
#
## #  #   #    #     #      #       #      #     #    #   #  # ##


# Make sure we start out with a clean slate
/bin/rm -f Hosts.JvNC.DNS.new
echo ";;; JvNCnet gateways, DNS file." >Hosts.JvNC.DNS.new
echo ";;;  Generated by `/usr/ucb/whoami` on `/bin/hostname` at `/bin/date`." >>Hosts.JvNC.DNS.new
echo "" >>Hosts.JvNC.DNS.new
# Go get the data for all hosts
../misc/dnsq -l -v -t any JvNC.Net NISC.JvNC.Net | \
	/bin/awk '$1==")"{f++;next}f==1{if($4=="SOA")f++;else print}' | \
	grep -i JvNC.net | \
	/usr/bin/sort -u >>Hosts.JvNC.DNS.new
# See if anything changed (other than the date :-)
/usr/ucb/tail +3 Hosts.JvNC.DNS >/tmp/foo$$
/usr/ucb/tail +3 Hosts.JvNC.DNS.new >/tmp/bar$$
if ( { /bin/cmp -s /tmp/foo$$ /tmp/bar$$ } ) then
	/bin/echo "New Hosts.JvNC.DNS same as before, just leave the old one."
	/bin/rm -f /tmp/foo$$ /tmp/bar$$ Hosts.JvNC.DNS.new
	exit 0
endif
/bin/rm -f /tmp/foo$$ /tmp/bar$$


/bin/rm -f Hosts.JvNC.DNS.old
/bin/ln Hosts.JvNC.DNS Hosts.JvNC.DNS.old
/bin/mv Hosts.JvNC.DNS.new Hosts.JvNC.DNS



## #  #   #    #     #      #       #      #     #    #   #  # ##
#
echo		"DNS data retreived, converting to host table..."
#
## #  #   #    #     #      #       #      #     #    #   #  # ##

/bin/rm -f Hosts.JvNC.new
echo ";;; JvNCnet host table file." >Hosts.JvNC.new
echo ";;;  Generated by `/usr/ucb/whoami` on `/bin/hostname` at `/bin/date`." >>Hosts.JvNC.new
echo "" >>Hosts.JvNC.new
# Find all the ones that have A records to use as masters.
foreach h ( `awk '$4=="A"{print $1}' Hosts.JvNC.DNS | sort -u` )
	if ( "$h" == "jvnc.net" ) continue
	echo -n "Making record for $h..."
	grep -i "$h" Hosts.JvNC.DNS \
	    | awk 'BEGIN{OFS=":";typ="HOST"}$1~/-gateway/{typ="GATEWAY";prot="IP/GW,"}$4=="CNAME"{cname=cname "," $1}$4=="A"{if (addr=="")addr=$5;else addr=addr "," $5;name=$1;}$4=="HINFO"{hw=$5;sw=$6}END{if (hw=="")hw="cisco";if (sw=="")sw="cisco";print typ, addr, name cname, hw, sw, prot "UDP/SNMP,TCP/TELNET:"}' \
			>> Hosts.JvNC.new
	echo "Done."
end



## #  #   #    #     #      #       #      #     #    #   #  # ##
#
echo		"Conversion complete, check results..."
#
## #  #   #    #     #      #       #      #     #    #   #  # ##


# See if anything changed (other than the date :-)
/usr/ucb/tail +3 Hosts.JvNC | tr a-z A-Z >/tmp/foo$$
/usr/ucb/tail +3 Hosts.JvNC.new | tr a-z A-Z >/tmp/bar$$
if ( { /bin/cmp -s /tmp/foo$$ /tmp/bar$$ } ) then
	/bin/echo "New Hosts.JvNC same as before, just leaving the old one."
	/bin/rm -f /tmp/foo$$ /tmp/bar$$ Hosts.JvNC.new
	exit 0
endif
/bin/rm -f /tmp/foo$$ /tmp/bar$$


# Make an overall check that we haven't lost too much data
if ( `/bin/ls -s Hosts.JvNC|/bin/awk '{print $1}'` > `/bin/ls -s Hosts.JvNC.new|/bin/awk '{printf "%d\n", $1*1.2}'` ) then
	/bin/echo "New Hosts.JvNC file too small" 
	/bin/ls -lag
	/bin/ls -lag|/usr/ucb/mail -s "Hosts.JvNC too small in MINTAKA:/projects/Network/release" MAP=Status
	exit 1
endif

# Check that we have data for every one we had data for before
# NO!  JvNC changes too much miscellany
# Eventually make it check not mid=ssing data on ones in Geometry...
#foreach h ( `/usr/ucb/tail +3 Hosts.JvNC|awk -F: '{print $3}'|awk -F, '{print $1}'` )
#    if ( `grep -ci $h Hosts.JvNC` > `grep -ci $h Hosts.JvNC.new` ) then
#	/bin/echo "New Hosts.JvNC is missing data on $h" 
#	/bin/ls -lag
#	/bin/ls -lag|/usr/ucb/mail -s "Data missing on $h in MINTAKA:/projects/Network/release/Hosts.JvNC" MAP=Status
#	exit 1
#    endif
#end



## #  #   #    #     #      #       #      #     #    #   #  # ##
#
echo		"OK, so now install it."
#
## #  #   #    #     #      #       #      #     #    #   #  # ##


diff -wi Hosts.JvNC{,.new}|/usr/ucb/mail -s "Update to Hosts.JvNC on MINTAKA:/projects/Network/release" MAP=Status
/bin/rm -f Hosts.JvNC.old
/bin/ln Hosts.JvNC Hosts.JvNC.old
/bin/mv Hosts.JvNC.new Hosts.JvNC
