/*
 * Copyright 1992 SynOptics Communications, Inc.  All Rights Reserved.
 * SynOptics grants a non-exclusive license to use, copy, modify, and
 * distribute this software for any purpose and without fee, provided
 * that this copyright notice and license appear on all copies and
 * supporting documentation.
 * SynOptics makes no representations about the suitability of this
 * software for any particular purpose.  The software is supplied
 * "AS IS", and SynOptics makes no warranty, either express or implied,
 * as to the use, operation, condition, or performance of the software.
 * SynOptics retains all title and ownership in the software.
 *
 * file: SMSYDEFS.H - Symbol definitions
 *
 * $Revision:   1.2  $ $Date:   08 Jul 1992 17:19:44  $
 * $Log:   R:/MIBTOOLS/V1.0/SMIC/SRC/SMSYDEFS.H_V  $
 * 
 *    Rev 1.2   08 Jul 1992 17:19:44   gfoster
 * Removed unnecessary revision comment lines added by
 * PVCS to make revision history easier to read.
 * 
 *    Rev 1.1   19 Jun 1992 16:39:12   gfoster
 * Copyright text was reformated.
 * 
 *    Rev 1.0   27 May 1992 16:19:26   gfoster
 * Initial revision.
 *
*/

typedef struct _mibmod { /* module */
    struct _mibmodref *pImodHL; /* head of list of imports */
    struct _mibmodref *pImodTL; /* tail of list of imports */
} MIBMOD;

typedef struct _mibmodref { /* module in IMPORT */
    struct _mibsym *pMod;       /* module (NULL untill defined) */
    struct _mibimpi *pImpIL;    /* imported names from module */
    USHORT cImpi;               /* number of names */
    struct _mibmodref *pNext;   /* next in list */
} MIBMODREF;

typedef struct _mibimpi { /* name of imported item */
    struct _strtab *pNa;        /* imported item name */
    struct _mibimpi *pNext;     /* next in list */
} MIBIMPI;

typedef struct _mibimp { /* import object */
    struct _mibsym *pImpSym;    /* ptr to imported symbol */
    USHORT cUse;                /* use count in module */
} MIBIMP;

typedef struct _mibal { /* alias item */
    struct _mibsym *pAlSym;     /* item that is being aliased */
    USHORT cUse;                /* use count */
    struct _mibsym *pNext;      /* next alias for symbol */
} MIBAL;

typedef struct _mibsmi { /* SMI (or TRAP-TYPE or OBJECT-TYPE) object */
    USHORT iKW;                 /* keyword index in scanner */
} MIBSMI;

typedef union _mibusr { /* size or range */
    USHORT usSize[2];           /* size in bytes */
    ULONG ulRange[2];           /* range */
} MIBUSR;

typedef struct _mibsyn { /* syntax information */
    USHORT usSyntax;            /* object syntax (see MIBSYNxxx) */
    USHORT cEnum;               /* number of enumered items (if used) */
    union {                     /* additional info */
        VOID *pSI;              /* generic syntax info (NULL if not used) */
        struct _mibenum *pEnumL; /* list of enumerated values */
        struct _mibsym *pSeq;   /* sequence */
        struct _mibsym *pTC;    /* textual convention */
    } usi;
    USHORT usSizeRange;         /* type of size/range values (see MIBSRxxx) */
    MIBUSR usr;                 /* size/range values */
} MIBSYN;

/* the types of syntax */
#define MIBSYNnu      1         /* not used */
#define MIBSYNbad     2         /* invalid syntax specified */
#define MIBSYNint     3         /* integer */
#define MIBSYNoctstr  4         /* octet string */
#define MIBSYNoid     5         /* object identifier */
#define MIBSYNnull    6         /* NULL */
#define MIBSYNnaddr   7         /* network address */
#define MIBSYNipaddr  8         /* IP address */
#define MIBSYNcntr    9         /* counter */
#define MIBSYNgauge  10         /* gauge */
#define MIBSYNticks  11         /* timer tics */
#define MIBSYNopaque 12         /* opaque */
#define MIBSYNenum   13         /* enumerated (pEnumL points to list) */
#define MIBSYNseqOf  14         /* sequence of (table) (pSeq pts to type) */
#define MIBSYNseq    15         /* sequence (row)  (pSeq pts to type) */
#define MIBSYNtc     16         /* textual convention (pTC points to item) */

/* types for size or range */
#define MIBSRno  1              /* no size or range */
#define MIBSRbad 2              /* invalid size/range */
#define MIBSRfs  3              /* fixed size (value in usSize[0]) */
#define MIBSRvs  4              /* variable size */
#define MIBSRpp  5              /* positive to positive range */
#define MIBSRnp  6              /* negative to positive range */
#define MIBSRnn  7              /* negative to negative range */


typedef struct _miboid { /* pure OID, Table, Row, or Object */
    BOOL fDup;                  /* true if another OID has same name */
    ULONG ulVal;                /* component value */
    struct _mibsym *pPar;       /* parent */
    struct _mibsym *pChild;     /* first child */
    struct _mibsym *pSib;       /* sibling (sorted by ulVal) */
    USHORT usOType;             /* type (see MIBOTxxx) */
    MIBSYN syn;                 /* object syntax info */
    USHORT usAccess;            /* object access (see MIBACCxxx) */
    /* next two are only for rows (or deviate objects) */
    struct _mibindx *pIndxL;    /* index list (NULL if not used) */
    USHORT cIndx;               /* number of items in index list */
    /* remaining are only for objects */
    struct _mibsym *pDefSeq;    /* defining containing sequence (or NULL) */
    MIBSYN rsyn;                /* "resolved" syntax info */
    USHORT usDefVal;            /* type of default value (see MIBDFVxxx) */
    union {                     /* default value */
        PSZ pszDefVal;              /* string or name */
        ULONG ulDefVal;             /* number */
        BYTE ipDefVal[4];           /* ip address */
        struct _mibsym *pOid;       /* object identifier */
    } udv;
} MIBOID;

/* the types for Otype */
#define MIBOTunk    1           /* unknown or bad */
#define MIBOToid    2           /* pure OID */
#define MIBOTtab    3           /* SNMP table */
#define MIBOTrow    4           /* SNMP row */
#define MIBOTobj    5           /* SNMP object */

/* the types for access */
#define MIBACCnu    1           /* not used */
#define MIBACCbad   2           /* invalid access */
#define MIBACCro    3           /* read-only */
#define MIBACCrw    4           /* read-write */
#define MIBACCwo    5           /* write-only */
#define MIBACCna    6           /* not-accessible */

/* the types of default values */
#define MIBDFVno    1           /* no default value */
#define MIBDFVbad   2           /* invalid value */
#define MIBDFVstr   3           /* string */
#define MIBDFVbstr  4           /* binary string */
#define MIBDFVhstr  5           /* hex string */
#define MIBDFVint   6           /* integer */
#define MIBDFVneg   7           /* negative number */
#define MIBDFVna    8           /* name (enumerated value) */
#define MIBDFVip    9           /* ip address */
#define MIBDFVoid  10           /* oid */


typedef struct _mibenum { /* enumerated item */
    PSZ pszName;                /* name */
    ULONG ulVal;                /* value */
    struct _mibenum *pNext;     /* next item */
} MIBENUM;


typedef struct _mibindx { /* index item */
    USHORT usItype;             /* index type (see MIBITxxx) */
    struct _mibsym *pOid;       /* index item (NULL if not used) */
    ULONG ulLow;                /* low range if INTEGER type (or low
                                    size if OCTET STRING) */
    ULONG ulHigh;               /* high range if INTEGER type (or high
                                    size if OCTET STRING. NOTE: varying
                                    length OCTET STRINGs (ie type MIBIToct
                                    or MIBITnloct) with no size
                                    specified have zero here) */
    struct _mibindx *pNext;     /* next in list */
} MIBINDX;

/* types for Itype - note: textual conventions are already resolved */
#define MIBITbad    1           /* bad index item */
#define MIBITobj    2           /* object */
#define MIBITnlobj  3           /* length object */
#define MIBITint    4           /* INTEGER */
#define MIBIToct    5           /* varying length OCTET STRING */
#define MIBITnloct  6           /* "no length" varying length OCTET STRING */
#define MIBITfloct  7           /* fixed length OCTET STRING (size in ulLow) */
#define MIBIToid    8           /* OBJECT IDENTIFIER */
#define MIBITnloid  9           /* "no length" OBJECT IDENTIFIER */
#define MIBITnaddr  10          /* NetworkAddress */
#define MIBITipaddr 11          /* IpAddress */


typedef struct _mibtc { /* textual convention */
    MIBSYN syn;                 /* syntax info */
    MIBSYN rsyn;                /* "resolved" syntax info */
    USHORT cUse;                /* use count */
} MIBTC;


typedef struct _mibseq { /* sequence */
    struct _mibseqi *pSeqIL;    /* list of items in seq */
    USHORT cSeqi;               /* number of items in seq */
    USHORT cUse;                /* use count */
    struct _mibsym *pRow;       /* row using sequence */
} MIBSEQ;

typedef struct _mibseqi { /* item in sequence */
    struct _mibsym *pOid;       /* sequence item */
    MIBSYN syn;                 /* syntax info */
    struct _mibseqi *pNext;     /* next in list */
} MIBSEQI;

typedef struct _mibtr { /* traps */
    struct _mibsym *pOid;       /* enterprise */
    struct _mibsym *pEntTr;     /* next trap that has same enterprise val */
    struct _mibvar *pVarL;      /* variable list */
    USHORT cVar;                /* number in list */
    ULONG ulVal;                /* trap value */
} MIBTR;

typedef struct _mibvar { /* item in variable list */
    struct _mibsym *pOid;       /* trap variable */
    struct _mibvar *pNext;      /* next in list */
} MIBVAR;

typedef struct _mibent { /* enterprise value for a trap */
    struct _mibsym *pOid;       /* enterprise value */
    struct _mibsym *pTr;        /* 1st trap in list that has enterprise val */
                                /* traps are sorted by value */
    struct _mibent *pNext;      /* next in list */
} MIBENT;

typedef struct _mibsym { /* MIB symbol */
    USHORT usType;              /* symbol type (see MIBSYMxxx) */
    struct _mibsym *pSym;       /* ptr to next symbol with the same name */
    struct _mibsym *pMod;       /* module containing symbol */
    struct _mibsym *pAlist;     /* list of aliases for symbol (NULL if none)*/
    PSZ pszName;                /* name of symbol (NULL if not used) */
    USHORT usStatus;            /* object status (see MIBSTAxxx) */
    USHORT usNeed;              /* include/exclude status (see MIBIExxx) */
    VOID *pBKEdata;             /* additional data for backend */
    PSZ pszDesc;                /* description (NULL if not used) */
    PSZ pszRefer;               /* reference (NULL if not used) */
    struct _mibsym *pNext;      /* next in list of same type of symbol */
    union {                     /* information for type */
        struct _mibmod mod;        /* module */
        struct _mibimp imp;        /* import */
        struct _mibal  al;         /* alias */
        struct _mibsmi smi;        /* smi item */
        struct _miboid oid;        /* oid item */
        struct _mibtc  tc;         /* textual convention */
        struct _mibseq seq;        /* sequence */
        struct _mibtr  tr;         /* trap */
    } ut;
} MIBSYM;

/* the types of symbols */
#define MIBSYMmod   1           /* module */
#define MIBSYMoid   2           /* pure OID, Table, Row, or object */
#define MIBSYMseq   3           /* sequence */
#define MIBSYMtc    4           /* textual convention */
#define MIBSYMtr    5           /* trap */
#define MIBSYMimp   6           /* import */
#define MIBSYMsmi   7           /* SMI item (OBJECT-TYPE, Counter, etc) */
#define MIBSYMalias 8           /* alias */
                            
/* type modifiers */
#define MIBSYMDF  0x8000        /* symbol being defined */
#define MIBSYMFR  0x4000        /* forward reference */
#define MIBSYMmask (~(MIBSYMDF | MIBSYMFR)) /* mask to isolate type */

/* the types for status */
#define MIBSTAnu    1           /* not used */
#define MIBSTAbad   2           /* invalid */
#define MIBSTAma    3           /* mandatory */
#define MIBSTAop    4           /* optional */
#define MIBSTAob    5           /* obsolete */
#define MIBSTAde    6           /* deprecated */

/* the types for include/exclude */
#define MIBIEns     1           /* not specified */
#define MIBIEbad    2           /* invalid */
#define MIBIEin     3           /* include */
#define MIBIEex     4           /* exclude */


/* objects from scanner */

typedef struct _numval {    /* number */
  PSZ pszFn;                    /* file name */
  USHORT usLineNo;              /* line number */
  USHORT usColNo;               /* column number */
  ULONG  ul;                    /* value */
} NUMVAL;

typedef struct _strval {    /* string */
  PSZ pszFn;                    /* file name */
  USHORT usLineNo;              /* line number */
  USHORT usColNo;               /* column number */
  STRTAB *pStr;                 /* value */
} STRVAL;

typedef struct _symval {    /* name */
  PSZ pszFn;                    /* file name */
  USHORT usLineNo;              /* line number */
  USHORT usColNo;               /* column number */
  MIBSYM *pSym;                 /* value */
} SYMVAL;

typedef struct _kwval {     /* keyword or other symbol */
  PSZ pszFn;                    /* file name */
  USHORT usLineNo;              /* line number */
  USHORT usColNo;               /* column number */
  USHORT us;                    /* value */
} KWVAL;


/* end of file: SMSYDEFS.H */
