/*
 * Copyright 1992 SynOptics Communications, Inc.  All Rights Reserved.
 * SynOptics grants a non-exclusive license to use, copy, modify, and
 * distribute this software for any purpose and without fee, provided
 * that this copyright notice and license appear on all copies and
 * supporting documentation.
 * SynOptics makes no representations about the suitability of this
 * software for any particular purpose.  The software is supplied
 * "AS IS", and SynOptics makes no warranty, either express or implied,
 * as to the use, operation, condition, or performance of the software.
 * SynOptics retains all title and ownership in the software.
 *
 * file: SMTR.C - TRAP functions
 *
 * $Revision:   1.2  $ $Date:   08 Jul 1992 17:40:50  $
 * $Log:   R:/MIBTOOLS/V1.0/SMIC/SRC/SMTR.C_V  $
 * 
 *    Rev 1.2   08 Jul 1992 17:40:50   gfoster
 * Removed unnecessary revision comment lines added by
 * PVCS to make revision history easier to read.
 * 
 *    Rev 1.1   19 Jun 1992 16:32:22   gfoster
 * Copyright text was reformated.
 * 
 * Added check for duplicate definition of traps.
 * 
 *    Rev 1.0   27 May 1992 16:08:52   gfoster
 * Initial revision.
 *
*/

#include <stdio.h>

#ifdef MS_DOS
#include <stdlib.h>
#endif /* MS_DOS */

#include <string.h>
#include <ctype.h>

#include "tds.h"
#include "smscdefs.h"
#include "smstdefs.h"
#include "smsydefs.h"
#include "smic.h"


/** addTRname - add trap
*
* call with:
*   pNa - trap name
*   pMod - containing module
*
* returns:
*   ptr to trap or NULL if error
*/
    MIBSYM *
#ifdef __STDC__
addTRname(STRTAB *pNa, MIBSYM *pMod)
#else
addTRname(pNa, pMod)
    STRTAB *pNa;
    MIBSYM *pMod;
#endif /* __STDC__ */
{
    MIBSYM *pSym;
    MIBSYM *pTr;


    /* check if item already defined */
    pSym = pNa->pSym;
    if ((pSym != NULL) && (pSym->pMod == pMod)) {
        /* item already defined */
        /* check if forward reference */
        if (pSym->usType != (MIBSYMFR|MIBSYMtr)) {
            yyerror("\"%s\" already defined in current module",
                    pSym->pszName);
#ifdef OLD
            yyterm();
#endif
            return(NULL);
        }
        pTr = (MIBSYM *)pSym;
    } else {
        /* item not defined */
        /* allocate new symbol */
        pTr = newTR(pNa, pMod);
    }

    /* mark as TRAP, forward reference, and being defined */
    pTr->usType |= MIBSYMtr | MIBSYMFR | MIBSYMDF;

    /* check for proper case of first letter */
    if (!islower(*(pTr->pszName))) {
        yyerror("Name of trap \"%s\" must start with lowercase letter",
                pTr->pszName);
    }

    return(pTr);

} /* addTRname */


/** finishTR - finish definition of trap
*
* NOTE: the checking of the variables must be done
*       later after all the variables are defined
*
* call with:
*   pTr - trap
*   pNaEnt - enterprise
*   pDesc - description
*   pRefer - reference
*   ulVal - trap value
*
* returns:
*   ptr to trap or NULL for error
*/
    MIBSYM *
#ifdef __STDC__
finishTR(MIBSYM *pTr, STRTAB *pNaEnt, STRTAB *pDesc,
         STRTAB *pRefer, ULONG ulVal)
#else
finishTR(pTr, pNaEnt, pDesc, pRefer, ulVal)
    MIBSYM *pTr;
    STRTAB *pNaEnt;
    STRTAB *pDesc;
    STRTAB *pRefer;
    ULONG ulVal;
#endif /* __STDC__ */
{
    MIBSYM *pOidEnt;
    MIBSYM *pSym;
    MIBSYM *pT;
    MIBSYM *pOt;
    MIBENT *pEnt;


    /* check if Enterprise defined */
    pSym = pNaEnt->pSym;
    if ((pSym != NULL) && (pSym->pMod == pTr->pMod)) {
        /* item defined */
        /* check if import */
        if (pSym->usType == MIBSYMimp) {
            pSym->ut.imp.cUse++;
            pSym = pSym->ut.imp.pImpSym;
        }
        /* check if OID type */
        if ((pSym->usType & MIBSYMmask) != MIBSYMoid) {
            yyerror("\"%s\" is not valid type for enterprise of trap",
                    pSym->pszName);
#ifdef OLD
            yyterm();
            return(NULL);
#endif
            pOidEnt = NULL;
        } else
            pOidEnt = pSym;
    } else {
        /* enterprise not defined */
        /* allocate new symbol */
        pOidEnt = newOID(pNaEnt, pTr->pMod);
    }

    /* store values */
    pTr->usType = MIBSYMtr;
    if ((pDesc != NULL) && (*(pDesc->pszVal) != 0))
        pTr->pszDesc = pDesc->pszVal;
    if ((pRefer != NULL) && (*(pRefer->pszVal) != 0))
        pTr->pszRefer = pRefer->pszVal;
    pTr->ut.tr.pOid = pOidEnt;
    pTr->ut.tr.ulVal = ulVal;


    /* return now if bad enterprise value */
    if (pOidEnt == NULL)
        return(pTr);

    /* check that no other trap has same ID
        (that is, the same value for enterprise and value)
        and insert trap is list of all traps with the same
        value of enterprise. */
    for (pEnt = pEntGHL; pEnt != NULL; pEnt = pEnt->pNext) {
        /* check of enterprise matches */
        if (pEnt->pOid != pOidEnt)
            continue;
        /* got a match, check for duplicate value */
        for (pOt = NULL, pT = pEnt->pTr; pT != NULL;
                pOt = pT, pT = pT->ut.tr.pEntTr) {
            if (pT->ut.tr.ulVal == ulVal) {
                /* duplicate values or duplicate definitions */
                if (strcmp(pT->pszName, pTr->pszName) == 0)
                    yyerror("Trap \"%s\" has already been defined",
                            pT->pszName);
                else
                    yyerror("Traps \"%s\" and \"%s\" have duplicate values",
                            pT->pszName, pTr->pszName);
#ifdef OLD
                yyterm();
                return(NULL);
#endif
                return(pTr);
            }
            if (pT->ut.tr.ulVal > ulVal) {
                /* insert before this item */
                break;
            }
        }
        if (pOt == NULL) {
            /* insert at head of list */
            pEnt->pTr = pTr;
        } else {
            /* insert in list */
            pOt->ut.tr.pEntTr = pTr;
        }
        pTr->ut.tr.pEntTr = pT;
        break;
    }

    /* Check that no other trap has the same name
        for a given enterprise. */
    for (pSym = pTr->pSym; pSym != NULL; pSym = pSym->pSym) {
        if (pSym->usType != MIBSYMtr)
            continue;

        /* found trap with same name, check for same enterprise */
        if (pSym->ut.tr.pOid == pOidEnt) {
            yyerror("Trap \"%s\" has already been defined, but with value %lu",
                    pSym->pszName, pSym->ut.tr.ulVal);
        }
    }

    if (pEnt == NULL) {
        /* enterprise not used, so allocate one */
        pEnt = newENT(pTr);
    }

    return(pTr);

} /* finishTR */


/** checkTRs - check the vars for all traps defined in a module
*
* call with:
*   pMod - module to check
*/
    VOID
#ifdef __STDC__
checkTRs(MIBSYM *pMod)
#else
checkTRs(pMod)
    MIBSYM *pMod;
#endif /* __STDC__ */
{
    MIBSYM *pT;
    MIBVAR *pV;


    for (pT = pTrGHL; pT != NULL; pT = pT->pNext) {
        if (pT->pMod != pMod)
            continue;

        /* check variables of a trap */
        for (pV = pT->ut.tr.pVarL; pV != NULL; pV = pV->pNext) {
            /* check if type an object */
            if ((pV->pOid)->ut.oid.usOType != MIBOTobj) {
                yyerror("Variable \"%s\" in trap \"%s\" is not an object",
                        (pV->pOid)->pszName, pT->pszName);
            }
        }
    }
} /* checkTRs */


/* end of file: SMTR.C */
