/*
 *                  multi_sds_test.c
 *	A simple routine that tests the basic HDF scientific
 *	data set read/write functions.
 *      
 *      modified to test storage/retrieval of multiple data sets
 *      in same file.
 *
 *      Should be run in a cmdtool or other scrollable window as
 *      output text can be long.
 *
 *       compile with          cc -DSUN -o outfile infile.c
 *
 *       Input file:  multi_test.raw: a binary file containing a 10x10
 *                    array of floating point values, with 1's along
 *                    the diagonal and 0's elsewhere.
 *       Output file: named by user in response to a prompt.
 *
 *       (This program was donated by Paul Girardi and Phil Frulla of 
 *       Schlumberger.)
 */

#include "df.h"
#include <stdio.h>
#include <errno.h>

FILE *stream;

main()
{


	int	ret, i, j;
	int	rank=2, inRank;
	int32	dimsize[2], inDimsize[2];
	char	fname[50],command[80];
	float	*data_array;
			
	fprintf(stdout,"\n\nWe will read 'multi_test.dat'...\n");
	fprintf(stdout,"  This is a file of 100 floating point values\n");
	fprintf(stdout,"  As a 10x10 matrix: data[x][y]=1.0 where x=y.\n");
	fprintf(stdout,"  We will create an HDF file from it\n");
	fprintf(stdout,"  We will then modify the array 2 times and\n");
	fprintf(stdout,"  write 2 more SDSs to the HDF file.\n");

	
	fprintf(stdout,"\nEnter the name of the output HDF file: ");
	fscanf(stdin,"%s",fname);
	
	data_array = (float *)malloc(100*sizeof(float));

	fprintf(stdout,"...reading\n");	
	stream = fopen("multi_test.dat","r");
	fread(data_array,sizeof(float),100,stream);
	fclose(stream);
	
	fprintf(stdout,"\n\n'multi_test.dat' has been read...\n\n");
	for(i=0;i<10;i++)
	{
	   for(j=0;j<10;j++)
	   {
	      fprintf(stdout,"%5.2f ",*(data_array+i*10+j));
	   }
	   fprintf(stdout,"\n");
	}
	fprintf(stdout,"\n\n");
	
	fprintf(stdout,"Attempting to write HDF SDS file...\n");

	dimsize[0]= dimsize[1] = 10;
	ret =DFSDsetdims(rank,dimsize);
	ret =DFSDputdata(fname,2,dimsize,data_array);

	if (!ret) 
	{
	   fprintf(stdout,"...first matrix has been successfully written..\n");
	}
	else
	{
	   fprintf(stdout,"\nDFSputdata returned %d\n",ret);
	   exit();
	}

/*
 *
 *  replace '1s' in matrix with '2s' and write second Data Set
 *
 */

	for(i=0;i<10;i++)
	  {
	    *(data_array + 10*i + i) = 2.0;
	  }
	ret =DFSDsetdims(rank,dimsize);
	ret =DFSDadddata(fname,2,dimsize,data_array);

	if (!ret) 
	{
	   fprintf(stdout,"\t...second matrix successfully written...\n");
	}
	else
	{
	   fprintf(stdout,"\nDFSDadddata returned %d\n",ret);
	   exit();
	}
/*
 *
 *  replace '2s' in matrix with '3s' and write third Data Set
 *
 */
	for(i=0;i<10;i++)
	  {
	    *(data_array + 10*i + i) = 3.0;
	  }
	ret =DFSDsetdims(rank,dimsize);
	ret =DFSDadddata(fname,2,dimsize,data_array);

	if (!ret) 
	{
	   fprintf(stdout,"\t\t...third matrix successfully written...\n\n");
	   fprintf(stdout," HDF file successfully written with 3 SDSs.\n\n");
	}
	else
	{
	   fprintf(stdout,"\nDFSDadddata returned %d\n",ret);
	   exit();
	}

/*
 *
 *   Use hdfls command line utility to show that HDF file contains 3 SDS
 *
 */
	fprintf(stdout,"Here is a listing of the HDF file contents.\n\n");
	strcpy(command,"hdfls -o ");
	strcat(command,fname);
	system(command);
	fprintf(stdout,"\n\n");
	strcpy(command,"hdfls -l ");
	strcat(command,fname);
	system(command);

	fprintf(stdout,"After zeroing the data array we will attempt to \n");
	fprintf(stdout,"read in the newly created HDF file and determine\n");
	fprintf(stdout,"that it contains the correct data\n");
	
	for (i=0;i<100;i++)
	{
	   *(data_array + i) = 0.0;
	}
	fprintf(stdout,"\n\n Data initialized, now reading HDF file...\n");
	
	ret = DFSDgetdims(fname,&inRank,inDimsize,2);
	fprintf(stdout,"Data in file has following parameters:\n");
	fprintf(stdout,"     Rank: %d\n",inRank);
	fprintf(stdout,"    Xdims: %d\n",inDimsize[0]);
	fprintf(stdout,"    Ydims: %d\n\n",inDimsize[1]);

	ret = DFSDgetdata(fname,2,inDimsize,data_array);
	if (!ret)
	{
		fprintf(stdout,"...first data array read:\n");
	}
	else
	{
		fprintf(stdout,"\nDFSDgetdata returned %d\n",ret);
		exit();
	}

	for(i=0;i<10;i++)
	{
	   for(j=0;j<10;j++)
	   {
	      fprintf(stdout,"%5.2f ",*(data_array+i*10+j));
	   }
	   fprintf(stdout,"\n");
	}

/*
 *
 *  Re-initialize the data array and get second SDS from file
 *
 */
	for (i=0;i<100;i++)
	{
	   *(data_array + i) = 0.0;
	}
	ret = DFSDgetdata(fname,2,inDimsize,data_array);
	if (!ret)
	{
		fprintf(stdout,"...second data array read:\n");
	}
	else
	{
		fprintf(stdout,"\nDFSDgetdata returned %d\n",ret);
		exit();
	}

	for(i=0;i<10;i++)
	{
	   for(j=0;j<10;j++)
	   {
	      fprintf(stdout,"%5.2f ",*(data_array+i*10+j));
	   }
	   fprintf(stdout,"\n");
	}

/*
 *
 *  Re-initialize the array and get the third SDS from file
 *
 */
	for (i=0;i<100;i++)
	{
	   *(data_array + i) = 0.0;
	}
	ret = DFSDgetdata(fname,2,inDimsize,data_array);
	if (!ret)
	{
		fprintf(stdout,"...third data array read:\n");
	}
	else
	{
		fprintf(stdout,"\nDFSDgetdata returned %d\n",ret);
		exit();
	}

	for(i=0;i<10;i++)
	{
	   for(j=0;j<10;j++)
	   {
	      fprintf(stdout,"%5.2f ",*(data_array+i*10+j));
	   }
	   fprintf(stdout,"\n");
	}
/*
 *
 *  Try to read a fourth SDS from the file...this should fail !!
 *
 */
	ret = DFSDgetdata(fname,2,inDimsize,data_array);
	if (!ret)
	{
		fprintf(stdout,"...fourth data array read:\n");
		fprintf(stdout,"THIS SHOULD NOT HAVE HAPPENED !!!!\n\n");
	        exit();
	}
	else
	{
		fprintf(stdout,"\nDFSDgetdata returned %d\n",ret);
	        fprintf(stdout,"This error is normal, EOF reached.\n\n");
	}

	
	fprintf(stdout,"Test of SDS data file read/write successful !\n");
}






