/* put.c -- generic put routines */
#include "he.h"

int HEput(cmd)
    HE_CMD *cmd;
{
    register int i;
    int verbose = NO;
    char *template = "elt#.@";

    for (i = 1; i < cmd->argc; i++)
	if (cmd->argv[i][0] == '-')
	    switch (findOpt(cmd->argv[i] + 1))
	    {
	    case HE_HELP:
		puts("put [-file <file>] [-verbose]");
		puts("\tPut the raw binary of this element in a file");
		puts("\t-file\t\tOut file name (default \"elt#.@\")");
		puts("\t-verbose\tOutput diagnostic info");
		return HE_OK;
	    case HE_FILE:
		template = cmd->argv[++i];
		break;
	    case HE_VERBOSE:
		verbose = YES;
		break;
	    case HE_NOTFOUND:
		unkOpt(cmd->argv[i]);
		return HE_FAIL;
	    case HE_AMBIG:
		ambigOpt(cmd->argv[i]);
		return HE_FAIL;
	    default:
		irrOpt(cmd->argv[i]);
		return HE_FAIL;
	    }
	else
	{
	    unkArg(cmd->argv[i]);
	    return HE_FAIL;
	}
    return put(template, verbose);
}

int put(template, verbose)
    char *template;
    int verbose;
{
    int length;
    char *data;
    int ret;

    length = getElement(he_currDesc, &data);
    if ((length <= 0) || (data == NULL)) return HE_FAIL;
    ret = putWithTempl(template, he_currDesc, length, 1, data, length,
		       verbose);
    free(data);

    return ret;
}

/* end of put.c */
