/* write_hdf.c
 * Write out an HDF file.
 * 
 * Peter Webb, Summer 1990
 */

/* Standard include files */

#include <stdio.h>

/* File format */

#include "df.h"

/* Package include files */

#include "reformat.h"
#include "types.h"
#include "extern.h"
#include "error.h"

/* Write out an HDF file */

ErrorCode WriteHDF(info)
  FileInfo *info;
{
  long width, height;
  int pal;

/* Check parameters */

  if (info == NULL)
      return(err_msg(WriteHDFFile, NullPtr));
  if (info->image == NULL)
      return(err_msg(WriteHDFFile, ConvertFailed));

/* Set the palette */

  if (info->values & (BitMask)CvtPalette)
    DFR8setpalette(info->palette);

/* Write out the image */

  if (info->values & (BitMask)CvtImage)
    DFR8putimage(info->name, info->image, info->width, info->height,
		 (CompressHDF == TRUE ? DFTAG_RLE : 0));

/* Write out the scientific data set */

  if (info->values & (BitMask)CvtData)
    if (info->values & (BitMask)CvtImage)
      DFSDadddata(info->name, info->dimension, info->ranks, info->data);
    else DFSDputdata(info->name, info->dimension, info->ranks, info->data);

/* Small internal consistiency check - are dimensions written correctly? */

  DFR8getdims(info->name, &width, &height, &pal);

  if (width != info->width || height != info->height)
    return(err_msg(WriteHDFFile, CorruptedOutputFile));

/* All done */

  return(AllOk);
}


