/*
 *  isis_gated_util.c,v 1.11 1993/01/07 22:39:20 jch Exp
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */
/* rights reserved.  Refer to Particulars and other Copyright notices at */
/* the end of this file.  */
/*  */


#define	INCLUDE_IF
#include "include.h"
#include "isis_includes.h"

#if (_BSD > 43) || (BSD > 43)

extern int run_from_log; /* suppress output under simulation */

void
ReceiveSock __PF1(tp, task *)
{
#define	SOCKETBUF (64*1024)

	tp->task_socket = task_get_socket(tp, AF_ISO, SOCK_DGRAM, ISOPROTO_ESIS);
	if (tp->task_socket < 0) {
		task_quit(errno);
	}
	if (task_set_option(tp, TASKOPTION_RECVBUF, min(task_maxpacket, SOCKETBUF)) < 0) {
		task_quit(errno);
	}
	if (task_set_option(tp, TASKOPTION_SENDBUF, min(task_maxpacket, SOCKETBUF)) < 0) {
		task_quit(errno);
	}
	if (task_set_option(tp, TASKOPTION_NONBLOCKING, TRUE) < 0) {
		task_quit(errno);
	}
}

int
Transmit(c, macAddr, buf, len)
CircuitEntry	*c;
MACAddress	macAddr;
u_char		*buf;
int		len;
{
	struct sockaddr_dl whereto;
	struct sockaddr_dl *to = &whereto;
	int cc;

	/* set up destination information */
	bzero( (char *)&whereto, sizeof(struct sockaddr));
	to->sdl_family = AF_LINK;
	to->sdl_index = c->kernindex;
	to->sdl_nlen = 0;
	to->sdl_alen = sizeof(MACAddress);
	bcopy((char *)macAddr, (char *)LLADDR(to), sizeof(MACAddress));
	to->sdl_len = sizeof(whereto);

	if (run_from_log)
		return(0); /* do nothing */
	/*
	{
		int pinoped;
		printf("TRANSMIT BUFFER:\n");
		for (pinoped=0;pinoped<len;pinoped++) printf("%02x ",buf[pinoped]);
		printf("\n");
	}
	*/
	cc = sendto(c->fd, buf, len, 0, (struct sockaddr *) &whereto, sizeof(whereto));
	if ( cc < 0)
		perror("sendto");

	return(0);
}

int
RecvData(fd,indx,buf,buflen,src)
int fd;
int *indx;
char *buf;
int buflen;
MACAddress src;
{
	struct sockaddr_dl from;
	int len, fromlen = sizeof(from);

	len = recvfrom(fd, buf, buflen, 0, (struct sockaddr *) &from, &fromlen);
	if (len >= 0) {
		*indx = from.sdl_index;
		bzero((caddr_t) src, sizeof(MACAddress));
		bcopy((caddr_t) LLADDR(&from), (caddr_t) src, sizeof(MACAddress));
	}
	return(len);
}
#else /* dummy stubs */
void
ReceiveSock(){}
int
Transmit __PF0(void)
{
return(0);
}
void
RecvData(){}
#endif	/* (_BSD > 43) */


/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3.5
 * 
 * 	Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * ------------------------------------------------------------------------
 * 
 * 	Copyright 1991 D.L.S. Associates
 * 
 * 	Permission to use, copy, modify, distribute, and sell this software
 * 	and its documentation for any purpose is hereby granted without
 * 	fee, provided that the above copyright notice appear in all copies
 * 	and that both that copyright notice and this permission notice
 * 	appear in supporting documentation, and that the name of D.L.S. not
 * 	be used in advertising or publicity pertaining to distribution of
 * 	the software without specific, written prior permission.  D.L.S.
 * 	makes no representations about the suitability of this software for
 * 	any purpose.  It is provided "as is" without express or implied
 * 	warranty.
 * 
 * 	D.L.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * 	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * 	NO EVENT SHALL D.L.S.  BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * 	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * 	OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * 	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * 	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * 	Authors:  Robert Hagens and Dan Schuh
 * 
 * 
 */
