/*
 * Copyright (c) 1993 Thomas Pusateri
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * redistribution for commercial purposes be limited to those that obtain
 * prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

/**********************************************************************
 *
 * Name:        $RCSfile: ospf.h,v $
 *
 * Dated:       $Date: 93/05/14 11:36:57 $
 *
 * Author:      $Author: pusateri $
 *
 * Revision:    $Revision: 1.4 $
 *
 * Description:
 *
 *
 ***********************************************************************/

struct ospfIf {
    struct ospfIf *next;
    struct ospfIf *prev;
    u_long ospfIfIpAddress;
    u_long ospfIfAreaId;
    int ospfIfType;
    int ospfIfRtrPriority;
    int ospfIfState;
    u_long ospfIfDesignatedRouter;
    u_long ospfIfBackupDesignatedRouter;
};

struct ospfNbr {
    struct ospfNbr *next;
    struct ospfNbr *prev;
    u_long ospfNbrIpAddr;
    u_long ospfNbrRtrId;
    u_long ospfNbrPriority;
    u_long ospfNbrState;
};

struct ospfLsdb {
    struct ospfLsdb *next;
    struct ospfLsdb *prev;
    u_long ospfLsdbAreaId;
    long ospfLsdbType;
    u_long ospfLsdbLSID;
    u_long ospfLsdbRouterId;
    u_long ospfLsdbSequence;
    u_long ospfLsdbAge;
    u_long ospfLsdbChecksum;
};

struct lsa_header {
    u_short age;
    u_char options;
    u_char LStype;
    u_long lsID;
    u_long router;
    u_long sequence;
    u_short checksum;
    u_short length;
};

struct lsa_network {
    u_long netmask;
    u_long **routers;
};

struct lsa_summary {
    u_long netmask;
    u_int TOS:8;
    u_int metric:24;
};

struct lsa_ase {
    u_int bitE:1;
    u_int TOS:7;
    u_int metric:24;
    u_long forw_addr;
    u_long tag;
};

struct ospfLsdbAdvertisement {
    struct lsa_header header;
    char lsa_data;
};

struct lsa_router_header {
    u_char flags;
    u_char unused;
    u_short nlinks;
};

struct router_link {
    u_long linkID;
    u_long linkdata;
    u_char linktype;
    u_char ntos;
    u_short TOS_0_metric;
};

struct TOSmetric {
    u_char TOS;
    u_char reserved;
    u_short metric;
};
struct ospf_advlist {
    struct ospf_advlist *next;
    struct ospf_advlist *prev;
    struct ospfLsdbAdvertisement *entry;
};

struct ospfRT {
    struct ospfRT *next;
    struct ospfRT *prev;
    u_long ipRouteDest;
    u_long ipRouteMask;
    u_long ipRouteNextHop;
    int ipRouteType;
    int ipRouteProto;
    int ipRouteAge;
    int ipRouteMetric1;
};

struct ospfFT {
    struct ospfFT *next;
    struct ospfFT *prev;
    u_long ipForwardDest;
    u_long ipForwardMask;
    u_long ipForwardNextHop;
    int ipForwardType;
    int ipForwardProto;
    int ipForwardAge;
    int ipForwardMetric1;
};

	/* status values */
#define ENABLED		1
#define DISABLED	2

	/* run time options */
#define NEIGHBORS	1
#define INTERFACES	2
#define LSDB		3
#define GENERAL		4
#define MISMATCH	5
#define ADVERTISEMENTS	6
#define ROUTE_TABLE	7
#define FORWARD_TABLE	8

	/* LS Types */
#define ROUTER_LSA	1
#define NETWORK_LSA	2
#define SUMNET_LSA	3
#define ASBR_LSA	4
#define ASE_LSA		5

	/* ipRoute Protocol Types */
#define r_OTHER		1
#define r_LOCAL		2
#define r_NETMGMT	3
#define r_ICMP		4
#define r_EGP		5
#define r_GGP		6
#define r_HELLO		7
#define r_RIP		8
#define r_IS_IS		9
#define r_ES_IS		10
#define r_IGRP		11
#define r_BBNSPF	12
#define r_OSPF		13
#define r_BGP		14

	/* ipForward Protocol Types */
#define f_OTHER		1
#define f_LOCAL		2
#define f_NETMGMT	3
#define f_ICMP		4
#define f_EGP		5
#define f_GGP		6
#define f_HELLO		7
#define f_RIP		8
#define f_IS_IS		9
#define f_ES_IS		10
#define f_IGRP		11
#define f_BBNSPF	12
#define f_OSPF		13
#define f_BGP		14
#define f_IDPR		15
