/* dir.c
   routines to manage the data fields for gopher directories */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.2     20 November 1991               */
     /*                version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#include <stdio.h>

#include "gopher.h"
#include "dir.h"
#include "dirList.h"



/* Directory data management routines:
	newDir()			return ptr to a gopherDir structure
	freeDir(gopherDirP)		free contents of a directory

   data access:
	getDirContents(gopherDirP)	return the contents of a directory 

*/


/* newDir 
	Return a fresh ready-to-use gopher directory */

gopherDirP
newDir()
{
	gopherDirP	dir;

	dir = acquireDir();

	dir->selectorItem = NULL;
	dir->created = NOT_LOADED;
	initItemList(&(dir->contents));

	return dir;
}


/* freeDir 
	free the contents of a gopher directory */

void
freeDir(dir)
gopherDirP	dir;
{
	if (dir == NULL) return;

	/* free selector item and directory contents item list */

	freeItem(dir->selectorItem);
	freeItemList(&(dir->contents));

	releaseDir(dir);

	return;
}


/* getDirContents
	return the contents (item list pointer) of a directory */

gopherItemListP
getDirContents(gd)
gopherDirP	gd;
{
	return &(gd->contents);
}
