/* cfgroupid.c */

/* Copyright 1997 by Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
   Donated to the public domain.  No warranty.

   1997-01-04 Initial version
   1997-04-05 Reorganize library */

#include <stdlib.h>
#include <syslog.h>
#include "firewall.h"
#include "libemfw.h"

int config_groupid (Cfg *confp, int do_set)
{
  Cfg *cf;
  int gid = -1;

  if ((cf = cfg_get ("groupid", confp)) != (Cfg *)0)
    {
      if (cf->argc != 1)
	{
	  syslog (LLEV, "fwtkcfgerr: groupid must have one parameter, line %d",cf->ln);
	  exit (1);
	}
      if ((gid = mapgid (cf->argv[0])) == -1)
	{
	  syslog (LLEV, "fwtkcfgerr: cannot map %s to gid", cf->argv[0]);
	  exit(1);
	}
    }
  if (do_set && gid != -1 && setgid (gid) != 0)
    {
      syslog (LLEV, "fwtksyserr: cannot setgid %d: %m", gid);
      exit (1);
    }
  return gid;
}
