
/* Source of alexmirror.c */

#include "alexincs.h"

/*

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <malloc.h>
#include <fcntl.h>
#include <dirent.h>
#include <string.h>
#include <stdio.h>
 */

/*
 * the following defines must be kept in sync with alex
 */

#define ALEX_UPDATE	".alex.update"
#define ALEX_ERROR(f)	((f)+16)

#define IS_ALEX_FILE(f)	(strncmp((f),".alex",5) == 0)
#define IS_ALEX_ERROR(f) (strncmp((f),"ALEX_FTP_ERROR__",16) == 0)

#ifndef S_ISLNK
#define S_ISLNK(m)	(((m)&S_IFMT) == S_IFLNK)
#endif

#define MAX_FILES	2048		/* max # of files per directory */
#define Printf		if(!isVerbose) ; else printf
   					/* log with printf if verbose */

static int doRecurse = 0;		/* mirror directorys recursively */
static int isVerbose = 0;		/* log each action taken */
static int listOnly = 0;		/* only list actions - don't retrieve */

/*
 * retrieve a file -- simly read so it becomes cached
 */

static void
RetrieveFile(pathName, size)
char *pathName;
int size;
{
  int fd,n;
  char buf[8192];

  if(listOnly){
    printf("retrv %s (%d bytes)\n",pathName,size);
    return;
  }

  Printf("retrv %s (%d bytes)\n",pathName,size);

  if((fd = open(pathName,O_RDONLY)) < 0){
    perror(pathName);
    return;
  }

  while((n = read(fd,buf,sizeof(buf))) > 0)
    ;

  if(n < 0)
    perror(pathName);

  if(close(fd) < 0)
    perror(pathName);
}

/*
 * compare two pointers to strings -- used by qsort
 */

static int
CharCompare( a, b)
char **a, **b;
{
  return(strcmp(*a,*b));
}

/*
 * mirror the given path
 */

static void
MirrorPath(pathName)
char *pathName;
{
  int i,fd,tmpLen,dirLast;
  char tmpBuf[MAXPATHLEN],*dirList[MAX_FILES];
  struct stat statbuf;
  struct dirent *dp;
  DIR *dirp;

  dirLast = 0;

  Printf("enter %s (recursion is %s)\n",pathName,doRecurse ? "on" : "off");

  strcpy(tmpBuf,pathName);
  strcat(tmpBuf,"/");
  tmpLen = strlen(tmpBuf);

  /* update directory information */

  strcpy(tmpBuf+tmpLen,ALEX_UPDATE);
  if((fd = open(tmpBuf,O_RDONLY)) >= 0)
    close(fd);

  /* scan directory */

  if((dirp = opendir(pathName)) == NULL){
    perror(pathName);
    exit(1);
  }

  while((dp = readdir(dirp)) != NULL) {
    if(strcmp(dp->d_name, ".") == 0 || strcmp(dp->d_name, "..") == 0)
      continue;
    else if(IS_ALEX_FILE(dp->d_name))
      continue;
    else if(IS_ALEX_ERROR(dp->d_name)){
      fprintf(stderr,"%s: alex error %s\n",pathName,ALEX_ERROR(dp->d_name));
      closedir(dirp);
      Printf("leave %s\n",pathName);
      return;
    }else{
      strcpy(tmpBuf+tmpLen,dp->d_name);
      if(dirLast == MAX_FILES){
        fprintf(stderr,"%s: too many files (max=%d)\n",pathName,MAX_FILES);
	Printf("leave %s\n",pathName);
       return;
      }
      if((dirList[dirLast] = malloc(strlen(tmpBuf)+1)) == NULL){
        fprintf(stderr,"%s: out of memory\n",pathName);
        exit(1);
      }
      strcpy(dirList[dirLast++],tmpBuf);
    }
  }

  closedir(dirp);

  /* sort files (alpha, up) */

  qsort(dirList,dirLast,sizeof(char *),CharCompare);

  /* actually retrieve all regular files */

  for(i = 0; i < dirLast; i++)
    if(lstat(dirList[i],&statbuf) < 0)
      perror(dirList[i]);
    else if(!S_ISDIR(statbuf.st_mode)){
      if(S_ISREG(statbuf.st_mode))
        RetrieveFile(dirList[i],statbuf.st_size);
      else if(!S_ISLNK(statbuf.st_mode))
	fprintf(stderr,"%s: unsupported mode\n",dirList[i]);

      dirList[i][0] = '\0';
    }

  /* if recursive mirror all directorys encountered */

  for(i = 0; i < dirLast; i++)
    if(doRecurse && dirList[i][0] != '\0')
      MirrorPath(dirList[i]);


  for(i = 0; i < dirLast; i++)
    free(dirList[i]);

  Printf("leave %s\n",pathName);
}

static void
Usage(progName)
char *progName;
{
  fprintf(stderr,"usage: %s [+rvn] [-rvn] [-] path ...\n",progName);
  exit(1);
}

main(argc, argv)
int argc;
char **argv;
{
  int i,noSwitch;
  char *cp;

  noSwitch = 0;
  for(i = 1; i < argc; i++)
    if(noSwitch == 0 && (*(cp = argv[i]) == '-' || *cp == '+')){
      if(strcmp(cp,"-") == 0)
	noSwitch = 1;
      else if(*++cp == '\0')
	Usage(argv[0]);
      else
	while(*cp != '\0')
	  switch(*cp++){
	  case 'n':
	    listOnly = (argv[i][0] == '-' ? 0 : 1);
	    break;

	  case 'r':
	    doRecurse = (argv[i][0] == '-' ? 0 : 1);
	    break;

	  case 'v':
	    isVerbose = (argv[i][0] == '-' ? 0 : 1);
	    break;

	  default:
	    Usage(argv[0]);
	    break;
	  }
    }else{
      MirrorPath(argv[i]);
      noSwitch = 0;
    }

  exit(0);
}
