
#include <sys/types.h>
#include <stdio.h>
#include <strings.h>
#include <ctype.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

extern int h_errno;


char *malloc();

void ToLower(s)
char *s;
{
    for (; *s != 0; s++) {
        if (isupper(*s)) {
            *s=tolower(*s);
        }
    }
}


/*  Input:     "sam.cs.cmu.edu"
 *  Returns:   "/edu/cmu/cs/sam"
 *  Destructive operation
 */
int NameToPath(namepath)
char *namepath;
{
    char LIFO[20][100];
    int length, seg, outi, cur, Result;

    seg=0;
    outi=0;
    Result=0;

    length=strlen(namepath);

    for (cur=0; cur<length; cur++) {
        if (namepath[cur] == '.') {
            LIFO[seg][outi]=NULL;
            seg++;
            outi=0;
        } else {
            LIFO[seg][outi]=namepath[cur];
            outi++;
        }
    }
    LIFO[seg][outi]=NULL;

    if (seg==0) Result=1;

    cur=0;
    for (; seg>=0; seg--) {
        namepath[cur++]='/';
        (void) strcpy(&namepath[cur], LIFO[seg]);
        cur += strlen(LIFO[seg]);
    }
    namepath[cur]=NULL;

    return(Result);
}


/* we also expand aliases like furmint */
int StandardForm(name)
char *name;
{
    struct hostent *h;             /* gethostbyname has its own static area */

    int Result;
    unsigned long addr;


    if (isdigit(*name) && (addr = inet_addr(name)) != -1) {
        h = gethostbyaddr((char *)&addr, sizeof(name), AF_INET);
        if (h != NULL) {
            (void) strcpy(name,h->h_name);
            (void) strcat(name,".");       /* add trailing dot */
            h = gethostbyname(name);
        }
    } else {
        h = gethostbyname(name);
    }

    Result=1;
    if (h != NULL) {
        (void) strcpy(name, h->h_name);
        Result=0;
    } else if (h_errno == NO_ADDRESS) {         /* means a domain */
        Result=0;
    }

    Result=0;
    ToLower(name);
    return(Result);
}

fixandprint(line)
char *line;
{
    if (!StandardForm(line)) {
        if (!NameToPath(line)) {
            puts(line);    
        }
    }
}

#define MAXL 100
main(argc, argv)
int argc;
char *argv[];
{
    char line[MAXL];
    int length;

    if (argc > 2) {
        fprintf(stderr, "usage: nametopath hostname");
        exit(-1);
    }

    if (argc == 2) {
        printf("/alex");
        (void) strcpy(line, argv[1]);
        fixandprint(line);
        exit(0);
    }
       

    while (fgets(&line[0] , MAXL , stdin) != NULL) {
        length=strlen(line);
        if (length > 1) {
            if (line[length-1] == '\n') {
                line[length-1]=NULL;                  /* get rid of New Line */
            }
            fixandprint(line);
        }
    }
}



