
#include "alexincs.h"
#include "alex.h"

/* Thought of puting this in conifig.h but decided not to */
#define LRU 1
#define SPACETIME 2
#define SPACETIMETRUNC 3
#define SPACETIMESP   4

#define CACHETYPE SPACETIMESP


struct DirPair {
        struct stat s;
        char path[MAXPATH];
        int pathlen;
} DirStack[200];

int TopOfStack = -1;

/*
 *   Input   /foo/bar/baz
 *   Output  baz
 */
extern int PathToFileName(Path, name)
char *Path, *name;
{
     Path=rindex(Path, '/');
     if (Path == 0) {
         return(AFAIL);
     }

     Path++;
     (void) strcpy(name,Path);
     return(AOK);
}


/*  This returns Greenich time in seconds since Jan 1 1970
 *  This is Unix/NFS standard
 */
extern double TimeInSecondsPI()
{
    struct timeval tp;
    struct timezone tzp;
    double Result;

    (void) gettimeofday(&tp, &tzp);

    Result= tp.tv_sec + (tp.tv_usec / 1000000.0);

    return(Result);
}




int OutputAPath(s, Type, FileName)
struct stat *s;
char Type;
char *FileName;
{
    static double CurrentTime=0;
    double Time, Space, StayingPower, BadNess;
    int FNLen;

    if (CurrentTime == 0) {
        CurrentTime= TimeInSecondsPI();
    }

    Time = (CurrentTime - s->st_atime);           /* how long since read                 */  
    Space = s->st_size;                           /* size of file                        */
    StayingPower = s->st_atime - s->st_mtime;     /* how long after read has been reread */

    Space += 1024;                                /* cost of alexinfo, inode, directory stuff */
    if (StayingPower < ADAY) StayingPower = ADAY;

    switch (CACHETYPE) {
        case LRU:          BadNess = Time;
                           break;

        case SPACETIME:    BadNess = Space * Time;
                           break;

        case SPACETIMESP:  BadNess = Space * Time * (Time/StayingPower);
                           break;

        case SPACETIMETRUNC: if (Space < 50000) Space = 50000;
                             BadNess = Space * Time;
                             break;

    }
       
    BadNess /= 1000000; 

    FNLen = strlen(FileName);
    if ((FNLen > 9) && (!strcmp(&FileName[FNLen-9], ALEXDIR))) {   /* strlen(ALEXDIR) = 9         */
        BadNess *= 1000000;                              /* every night clean .alex.dir files */
    }
    if ((FNLen > 11) && (!strcmp(&FileName[FNLen-11], ALEXERROR))) {   /* strlen(ALEXERROR) = 11      */
        BadNess *= 100000000;                            /* every night clean .alex.error files */
    }

    printf("%lf %d %d %d #%c %s\n", BadNess, s->st_atime, s->st_mtime, s->st_size, Type, FileName);
}

main(argc, argv)
int argc;
char **argv;
{
    struct stat s;
    char *myname, *FileName, namebuf[500], ShortName[500];
    int ReadFromStdin, HaveFileName;
    int TotalBytes, TotalDirs, TotalFiles, TotalLinks, TotalUnknown;
    char Type;

    myname = argv[0];

    TotalBytes=0;
    TotalDirs=0;
    TotalFiles=0;
    TotalLinks=0;
    TotalUnknown=0;

    HaveFileName=0;
    ReadFromStdin=0;
    if (argc > 2) {
        printf("usage: %s FileName\n", myname);
        exit(1);
    } else if (argc == 2) {                   
        FileName = argv[1]; 
        HaveFileName=1;
    } else {
        FileName=namebuf;
        ReadFromStdin=1;
    }


    /* We want to set the atime on a directory to the largest atime of all
     * files below it.  This is what DirStack is for.
     */   
    while (HaveFileName || (ReadFromStdin && (scanf("%s", FileName)==1))) { 
        while ((TopOfStack>=0) && 
             (strncmp(DirStack[TopOfStack].path, FileName, DirStack[TopOfStack].pathlen))) {
             OutputAPath(&DirStack[TopOfStack].s, 'D', DirStack[TopOfStack].path);
             s = DirStack[TopOfStack].s;
             TopOfStack--;
             if (s.st_atime > DirStack[TopOfStack].s.st_atime) {
                DirStack[TopOfStack].s.st_atime = s.st_atime;    /* propagate up dir tree */
             }                
        }

        if (lstat(FileName, &s) == 0) {
            if ((s.st_mode & S_IFDIR) == S_IFDIR) {
                TotalDirs++;
                TopOfStack++;
                (void) strcpy(DirStack[TopOfStack].path, FileName);
                DirStack[TopOfStack].pathlen = strlen(FileName);
                DirStack[TopOfStack].s = s;
                DirStack[TopOfStack].s.st_atime=0;               /* we don't use atime of actual dir */
            } else if ((s.st_mode & S_IFLNK) == S_IFLNK) {
                TotalLinks++;
                Type='L';
                fprintf(stderr, "%s: link inside cache tree %s\n" ,myname, FileName);
            } else if ((s.st_mode & S_IFREG) == S_IFREG) {
                TotalFiles++;
                Type='F';
                if (s.st_atime > DirStack[TopOfStack].s.st_atime) {
                    DirStack[TopOfStack].s.st_atime = s.st_atime;   /* we use most current child file */
                }                
                (void) PathToFileName(FileName, ShortName);
                if (!streql(ShortName, ALEXINFO)) {   /* don't output .alex.info since evictor never erases */
                    OutputAPath(&s, Type, FileName);
                }
            } else {
                TotalUnknown++;
                Type='X';
                fprintf(stderr, "%s: unknown inside cache tree %s\n" ,myname, FileName);
            }
            TotalBytes+=s.st_size;
        }
        HaveFileName=0;
    }

    printf("%lf Bytes= %d   Dirs= %d  Files= %d  Unknown= %d\n", 
                1000000000000000000000000.0,   TotalBytes, TotalDirs, TotalFiles, TotalUnknown);
}

