/* edit.c -- routines that allow actual editing of fields.
 *
 * Copyright (C) 1992, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Wed Apr 22 11:04:08 1992 by bcs (Bradley C. Spatz) on frenulum
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/List.h>

#include "fields.h"
#include "replies.h"
#include "global.h"


/* Prototype some functions.  I gotta start using ANSI C... */
void edit_help(), done();
extern String lookup_field();

/* We keep these widgets globally so we can update their values.
 * We build the edit panel only once.
 */
static Widget edit_popup=NULL;
static Widget ehelp_popup=NULL;
static Widget efname, elength, eattr, edesc, evalue;
static Widget field_list_widget=NULL;

/* Store the current value of a field.  We'll compare this with what's
 * returned by the edit widget; if they're different, we'll attempt
 * an update.
 */
static String field_value=NULL;
static char field_name[128];


void do_edit(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
    Widget	eform, evlabel, edone, ehelp;
    Position	x, y;
    XawListReturnStruct *item = (XawListReturnStruct*)call_data;
    char buf[80];
    field_node_t *node;
    char *value;

    field_list_widget = widget;

    /* If the edit panel hasn't been created, do so now. */
    if (edit_popup == NULL) {
       edit_popup = XtVaCreatePopupShell("xph_edit", transientShellWidgetClass,
					 (Widget) client_data,
					 XtNtitle, "Xph Edit",
					 XtNiconPixmap, icon_pixmap, NULL);
       
       eform = XtCreateManagedWidget("eform", formWidgetClass, edit_popup,
				     NULL, ZERO);

       efname = XtCreateManagedWidget("efname", labelWidgetClass, eform,
				      NULL, ZERO);
       edesc = XtCreateManagedWidget("edesc", labelWidgetClass, eform,
				      NULL, ZERO);
       elength = XtCreateManagedWidget("elength", labelWidgetClass, eform,
				       NULL, ZERO);
       eattr = XtCreateManagedWidget("eattr", labelWidgetClass, eform,
				     NULL, ZERO);
       
       evlabel = XtCreateManagedWidget("evlabel", labelWidgetClass, eform,
				       NULL, ZERO);

       evalue = XtCreateManagedWidget("evalue", asciiTextWidgetClass, eform,
				      NULL, ZERO);
       
       edone = XtCreateManagedWidget("edone", commandWidgetClass, eform,
				     NULL, ZERO);
       XtAddCallback(edone, XtNcallback, done, (XtPointer) eform);
       ehelp = XtCreateManagedWidget("ehelp", commandWidgetClass, eform,
				     NULL, ZERO);
       XtAddCallback(ehelp, XtNcallback, edit_help, (XtPointer) eform);
    }

    /* Position the popup just inside the field list panel. */
    XtVaGetValues((Widget) client_data, XtNx, &x, XtNy, &y, NULL);
    XtTranslateCoords((Widget) client_data, (Position) x + 10,
		      (Position) y + 10, &x, &y);
    XtVaSetValues(edit_popup, XtNx, x, XtNy, y, NULL);
    
    /* Now we need to set the field name, description, length, and
     * attributes. We look up the data on the field to do so.
     */
    strcpy(field_name, item->string);
    sprintf(buf, "       Name: %s", field_name);
    XtVaSetValues(efname, XtNlabel, buf, NULL);
    node = find_entry(item->string);
    sprintf(buf, "Description: %s", node->description);
    XtVaSetValues(edesc, XtNlabel, buf, NULL);
    sprintf(buf, " Max length: %d", node->max_length);
    XtVaSetValues(elength, XtNlabel, buf, NULL);
    sprintf(buf, " Attributes: %s", node->attr_str);
    XtVaSetValues(eattr, XtNlabel, buf, NULL);

    /* For the field's value, we check the local entry in the field's
     * node.  If not filled in, we query the server for the value.
     * As a hack, we call the action proc to goto the beginning of the
     * buffer in order to force a resize.
     */
    free(field_value);
    field_value = lookup_field(login_alias, field_name);
    XtVaSetValues(evalue, XtNstring, field_value, XtNwidth, 100, NULL);
    XtCallActionProc(evalue, "beginning-of-file", NULL, NULL, ZERO);

    XtPopup(edit_popup, XtGrabExclusive);
}


edit_field(alias, field, value)
char *alias, *field, *value;
{
   int code; 

   /* This routine updates a specific field in a record. */
   sprintf(buf, "change alias=%s make %s=\"%s\"\n", alias, field, value);
   write_ns(buf);
   read_ns(line);
   if (atoi(line) != LR_OK) {
      /* Fuck.  An error.  Man, it is getting late.  Errors are
       * pissing me off.
       */
      do {
	 strcat(line, "\n\n");
	 XawAsciiAppend(text, word(line, ':', 1));
	 read_ns(line);
	 code = atoi(line);
      } while (code < 0 );
      return(0);
   }
   return(1);
}


static void
done(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   Widget parent = XtParent((Widget) client_data);
   String new_value;

   /* Check if the user modified the field value.  If so, send off
    * a request to the server to update the field.
    */
   XtVaGetValues(evalue, XtNstring, &new_value, NULL);
   if (strcmp(new_value, field_value) != 0) {
      if (edit_field(login_alias, field_name, new_value)) {
	 /* Check if they just changed their alias.  Record the
	  * new one if so.
	  */
	 if (strcmp(field_name, "alias") == 0) {
	    strcpy(login_alias, new_value);
	 }
      }
   }

   XawListUnhighlight(field_list_widget);
   XtPopdown(parent);
}


#define HELP_WIDTH  310
#define HELP_HEIGHT 100

static String ehelp_text = 
"Edit Value Help\n\n\
This panel describes the selected\n\
field.  You may edit the field\n\
value if desired.  Make sure to\n\
stay within the maximum length.";

static void
edit_help(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
    Widget	hform, htext, hdismiss;
    Position	x, y;
    Dimension	width, height;

    if (ehelp_popup == NULL) {
       ehelp_popup = XtVaCreatePopupShell("login_help",
					  transientShellWidgetClass, widget,
					  XtNtitle, "Xph Edit Help",
					  XtNiconPixmap, icon_pixmap, NULL);

       /* Create a form with a text widget and a dismiss button. */
       hform = XtCreateManagedWidget("hform", formWidgetClass, ehelp_popup,
				     NULL, ZERO);

       htext = XtVaCreateManagedWidget("htext", asciiTextWidgetClass, hform,
				       XtNwidth, HELP_WIDTH,
				       XtNheight, HELP_HEIGHT,
				       XtNdisplayCaret, FALSE,
				       XtNstring, ehelp_text, NULL);
       hdismiss = XtCreateManagedWidget("hdismiss", commandWidgetClass, hform,
					NULL, ZERO);
       XtAddCallback(hdismiss, XtNcallback, pop_down_widget,
		     (XtPointer) hform);
    }

    /* Position the login help widget.*/
    XtVaGetValues(widget, XtNwidth, &width, XtNheight, &height, NULL);
    XtTranslateCoords(widget, (Position) (width / 2),
		      (Position) (height / 2), &x, &y);
    XtVaSetValues(ehelp_popup, XtNx, x, XtNy, y-HELP_HEIGHT-40, NULL);

    XtPopup(ehelp_popup, XtGrabExclusive);
}
