/* misc.c -- routines to perform most of the Misc menu functions.
 *
 * Copyright (C) 1992, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Wed Apr 22 11:05:12 1992 by bcs (Bradley C. Spatz) on frenulum
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>

#include "replies.h"
#include "global.h"
#include "fields.h"


void field_info(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   busy_cursor();
   do_field_info();
   unbusy_cursor();
}


void do_logout(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   if (logged_in) {
      write_ns("logout\n");
      read_ns(line);
      if (atoi(line) != LR_OK) {
	 sprintf(buf, "Unexpected response logout request:\n   %s\n\n",
		 word(line, ':', 1));
	 XawAsciiSaveTextPosition(text);
	 XawAsciiAppend(text, buf);
	 XawAsciiRestoreTextPosition(text);
      }
      logged_in = 0;
      strcpy(login_alias, "");
      strcpy(login_password, "");
      if (change_popup != NULL) {
	 XtPopdown(change_popup);
      }
   }
   else {
      XawAsciiSaveTextPosition(text);
      XawAsciiAppend(text, "You are not logged in.\n\n");
      XawAsciiRestoreTextPosition(text);
   }
}


/* This is a lame implementation of the protocol.  I just pass this
 * information on.
 */
void site_info(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   int code;

   XawAsciiSaveTextPosition(text);
   XawAsciiAppend(text, "The following information is site-specific:\n");
   write_ns("siteinfo\n");
   do {
      read_ns(buf);
      code = atoi(buf);
      if (code != LR_OK) {
	 sprintf(line, "   %s\n", word(buf, ':', 1));
	 XawAsciiAppend(text, line);
      }
   } while (code < 0 );
   XawAsciiAppend(text, "\n");
  
   XawAsciiRestoreTextPosition(text);
}


void
pop_down_widget(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   Widget parent = XtParent((Widget) client_data);
   XtPopdown(parent);
}


void
destroy_widget(widget, client_data, call_data)
Widget  widget;
XtPointer client_data, call_data;
{
    Widget parent = XtParent((Widget) client_data);
    XtDestroyWidget(parent);
}


