/*
 * exec.h: header for exec.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: exec.h,v 1.10 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _EXEC_H_
#define _EXEC_H_

#include "irc_std.h"
#include <sys/types.h>

#if defined(NeXT)             /* lameness for configure/NeXT -phone */
# if !defined(_POSIX_SOURCE) && !defined(BSDWAIT)
#  define BSDWAIT
# endif /* !_POSIX_SOURCE && !BSDWAIT */
#else /* !NeXT */
# ifndef WAITSTUFF_DECLARED
#  ifdef BSDWAIT
#   ifndef WAIT3_DECLARED
struct rusage;
union wait;
extern int   wait3 _((union wait *, int, struct rusage *));
#   endif /* WAIT3_DECLARED */
#  else /* BSDWAIT */
#   ifndef WAITPID_DECLARED
/* I cant believe this is really needed anyhow. */
/*extern short waitpid _((int, int *, int));*/
#   endif /* WAITPID_DECLARED */
#  endif /* BSDWAIT */
# endif /* WAITSTUFF_DECLARED */
#endif /* NeXT */

#ifndef WTERMSIG
# ifndef BSDWAIT /* if wait is NOT a union: */
#  define WTERMSIG(status) ((status) & 0177)
# else
#  define WTERMSIG(status) status.w_T.w_Termsig
# endif
#endif

#ifndef WEXITSTATUS
# ifndef BSDWAIT
#  define WEXITSTATUS(status) ((status) & 0xff00) >> 8		/* dgux 5.4.1 */
# else
#  define WEXITSTATUS(status) status.w_T.w_Retcode
# endif
#endif

extern	int	check_wait_status _((int));
/*extern	void	check_process_list _(());*/
extern	void	check_process_limits _((void));
extern	void	do_processes _((fd_set *));
extern	void	set_process_bits _((fd_set *));
extern	int	text_to_process _((int, char *, int));
extern	char	*signals[];
extern	void	clean_up_processes _((void));
extern	int	is_process _((char *));
extern	int	get_process_index _((char **));
extern	void	exec_server_delete _((int));
extern	int	is_process_running _((int));
extern	void	add_process_wait _((int, char *));
extern	void	set_wait_process _((int));
extern	void	close_all_exec _((void));
extern	int	logical_to_index _((char *));
extern	int	get_child_exit _((int));
extern	void	execcmd _((char *, char *, char *));

#endif /* _EXEC_H_ */
