;;;
;;; here is a list of hooks, which you can activate by just
;;; setting some variables, they are maybe the best way of
;;; enchanging irchat
;;;

(provide 'irchat-hooks)

(defun irchat-join-hook (prefix rest)
  (cond
   ((string= "#report" rest)
      t)
   ((and (string= "INSERT_YOUR_FAVOURITE_PERSON_HERE" prefix)
	 (string= irchat-current-channel rest))
    (irchat-Command-send-message (format "moi %s" prefix)))
   (t nil)))

(defun irchat-part-hook (prefix rest)
  (if (string= "#report" rest)
      t nil))

(setq irchat-join-hook (function irchat-join-hook))
(setq irchat-part-hook (function irchat-part-hook))

(defun irchat-namreply-hook (prefix rest)
  (if (string-match "[=*] \\([*#0-9+-][^ ]*\\) \\(.*\\)" rest)
      (let ((chnl (matching-substring rest 1))
	    (users (matching-substring rest 2)))
; we do not nuke @ here, it is info to users and should stay
; mta Mon Jan 21 23:58:24 EET 1991
	(if irchat-polling
	    nil
	  (if (irchat-enough-users users)
	      nil
	    t)))))

(defvar irchat-minnames 1)
(defun irchat-enough-users (users)
  (let ((so-far 0))
    (while (and (string-match " " users) (< so-far irchat-minnames))
      (progn 
	(setq users 
	      (substring users (+ 1 (string-match " " users))))
	(setq so-far (+ so-far 1))))
    (if (< so-far irchat-minnames)
	nil
      t)))
      

(setq irchat-namreply-hook (function irchat-namreply-hook))

;;(irchat-notice-hook "huu" "mta : BITMAP_START reuna #define reuna_width 8:#define reuna_height 8:static char reuna_bits[] = {: 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa};")
;;(irchat-notice-hook "huu" "mta : BITMAP_END reuna ")

(defun irchat-privmsg-hook (prefix rest)
  (if (and irchat-broadcast-partner (not irchat-chat-partner))
      (progn
	(if (eq prefix nil)
	    (setq prefix "")
	  (setq prefix (concat "<" prefix "> ")))
	(if (and (string= prefix "")
		 (string-match (format "^%s.*" (format irchat-format-string1)) rest))
	    nil
	  (progn 
	    (string-match "[^ ]* :\\(.*\\)" rest)
	    (irchat-send "PRIVMSG %s :%s%s" irchat-broadcast-partner prefix
			 (matching-substring rest 1))))
	nil)
    nil))

(defun irchat-msg-hook (prefix rest)
    (if (and irchat-broadcast-partner (not irchat-chat-partner))
	(progn
	  (if (eq prefix nil)
	      (setq prefix "")
	    (setq prefix (concat "<" prefix "> ")))
	  (if (and (string= prefix "")
		   (string-match (format "^%s.*" (format irchat-format-string1)) rest))
	      nil
	    (progn 
	      (string-match "[^ ]* :\\(.*\\)" rest)
	      (irchat-send "PRIVMSG %s :%s%s" irchat-broadcast-partner prefix
			   (matching-substring rest 1))))
	  nil)
      nil))
	    
(setq irchat-privmsg-hook (function irchat-privmsg-hook))
(setq irchat-msg-hook (function irchat-msg-hook))

