;;; $Id: irchat-300.el,v 1.3 1994/08/01 11:28:29 tmo Exp $
;;;
;;; see file irchat-copyright.el for change log and copyright info

(eval-when-compile
  (require 'irchat-inlines))

;;;
;;; 300 replies
;;;
(defun irchat-handle-300-msgs (number prefix rest)
  "Generic handler for 3?? messages. 
This is called if no specific handler exists"
  (if (string-match "[^ ]* \\([^ :]*\\) *\\([^ :]*\\) *:\\(.*\\)" rest)
      (let ((target1 (matching-substring rest 1))
	    (target2 (matching-substring rest 2))
	    (msg (matching-substring rest 3)))
	(cond ((string-equal target1 "")
	       (insert (format "*** %s" msg)))
	      ((string-equal target2 "")
	       (insert (format "*** %s (%s)" msg target1)))
	      (t
	       (insert (format "*** %s %s (%s)" target1 msg target2))))
	(newline))
    (message "IRCHAT: Strange %s reply" number)))


(defun irchat-handle-301-msg (prefix rest)
  "Handle the 301 RPL_AWAY."
  (if (string-match "^[^ ]+ \\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((who (matching-substring rest 1))
	    (iswhat (matching-substring rest 2)))
	(insert 
	 (format "*** %s is marked as being AWAY, but left the message:" who))
	(newline)
	(insert iswhat))
    (insert "IRCHAT: Strange 301 reply"))
  (newline))


(defun irchat-handle-302-msg (prefix rest)
  "Handle the 302 USERHOST."
  (while (string-match 
	  "^[^ ]* :[ ]*\\([^*=]+\\)\\([*]*\\)=\\([+-]\\)\\([^ ]+\\)" rest)
    (let ((nick (matching-substring rest 1))
	  (oper (matching-substring rest 2))
	  (away (matching-substring rest 3))
	  (who (matching-substring rest 4)))
      (insert (format "Nick %s is %s [%s, %s]\n"
		      nick who 
		      (concat 
		       (if (string= oper "")
			   "Not ")
		       "Operator")
		      (concat 
		       (if (string= away "+")
			   "Not ")
		       "AWAY")))
      (setq rest (concat " :" (substring rest (match-end 4) nil))))))


(defun irchat-handle-303-msg (prefix rest)
  "Handle the 303 ISON"
  (if (string-match "[^ ]+ :\\(.*\\)" rest)
      (if (string= (matching-substring rest 1) "")
	  (insert "No one you requested is on now.")
	(insert (format "Following people(s) are on: %s"
			(matching-substring rest 1))))
    (insert "IRCHAT: Strange 303 reply"))
  (newline))


(defun irchat-handle-305-msg (prefix rest)
  "Handle the 305 UNAWAY"
  (if (string-equal irchat-away-indicator "A")
      (progn
	(setq irchat-away-indicator "-")
	(irchat-maybe-poll)
	(if (string-match "[^:]:\\(.*\\)" rest)
	    (let ((msg (matching-substring rest 1)))
	      (insert (format "*** %s (%s)" msg (current-time-string))))
	  (insert "IRCHAT: Strange 305 reply"))
	(newline))))


(defun irchat-handle-306-msg (prefix rest)
  "Handle the 306 NOWAWAY"
  (setq irchat-away-indicator "A")
  (if (string-match "[^:]:\\(.*\\)" rest)
      (let ((msg (matching-substring rest 1)))
	(insert (format "*** %s (%s)" msg (current-time-string))))
    (insert "IRCHAT: Strange 306 reply"))
  (newline))


(defun irchat-handle-311-msg (prefix rest)
  "Handle the 311 WHOISUSER."
  (if (string-match "[^ ]+ \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) :\\(.*\\)" rest)
      (let ((nick (matching-substring rest 1))
	    (username (matching-substring rest 2))
	    (machine (matching-substring rest 3))
	    (channel (matching-substring rest 4))
	    (realname (matching-substring rest 5)))
	(insert (format "%s is %s (%s) at %s" nick username realname machine)))
    (insert "IRCHAT: Strange 311 reply"))
  (newline))


(defun irchat-handle-312-msg (prefix rest)
  "Handle the 312 WHOISSERVER."
  (if (string-match "^[^ ]+ \\(\\([^ ]+\\) \\)?\\([^ ]+\\) :\\(.*\\)" rest)
      (let ((server (matching-substring rest 3))
	    (real (matching-substring rest 4)))
	(insert (format "on via server %s (%s)" server real)))
    (insert "IRCHAT: Strange 312 reply"))
  (newline))


(defun irchat-handle-313-msg (prefix rest)
  "Handle the 313 WHOISOPERATOR."
  (if (string-match "^[^ ]+ \\([^ ]+\\) :\\(.*\\)" rest)
      (let ((who (matching-substring rest 1))
	    (iswhat (matching-substring rest 2)))
	(insert (format "STATUS: %s" iswhat)))
    (insert "IRCHAT: Strange 313 reply"))
  (newline))


(defun irchat-handle-316-msg (prefix rest)
  "Handle the 316 WHOISCHANOP."
  (if (string-match "^\\([^ ]+\\) :\\(.*\\)" rest)
      (let ((who (matching-substring rest 1))
	    (iswhat (matching-substring rest 2)))
	(insert (format "STATUS: %s" iswhat)))
    (if (string-match "^\\([^ ]+\\) \\([^ ]+\\) :\\(.*\\)" rest)
	(let ((who (matching-substring rest 2))
	      (iswhat (matching-substring rest 3)))
	  (insert (format "STATUS: %s" iswhat)))
      (insert "IRCHAT: Strange 316 reply")))
  (newline))


(defun irchat-handle-319-msg (prefix rest)
  "Handle the 319 reply (what channels user is on)."
  (if (string-match "^\\([^ ]+\\) \\([^ ]+\\) :\\(.*\\)" rest)
      (let ((who (matching-substring rest 2))
	    (isonchannels (matching-substring rest 3)))
	(insert (format "channels: %s\n" isonchannels)))))


(defun irchat-handle-314-msg (prefix rest)
  "Handle the 314 WHOWASUSER."
  (if (string-match "[^ ]+ \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) :\\(.*\\)" rest)
      (let ((nick (matching-substring rest 1))
	    (username (matching-substring rest 2))
	    (machine (matching-substring rest 3))
	    (channel (matching-substring rest 4))
	    (realname (matching-substring rest 5)))
	(message "")
	(insert (format "%s [%s] was %s (%s) at %s"
			nick
			(if (string= channel "*") "Priv" channel)
			username
			realname
			machine)))
    (message "IRCHAT: Strange 314 reply"))
  (newline))


(defun irchat-handle-315-msg (prefix rest)
  "Handle the 315 ENDOFWHO."
  nil)


(defun irchat-handle-317-msg (prefix rest)
  "Handle the 317 WHOISIDLE."
  (if (string-match "^[^ ]+ [^ ]+ \\([0-9]*\\) :\\(.*\\)" rest)
      (insert (format "IDLE for %s\n" (irchat-convert-seconds 
				       (matching-substring rest 1))))
    (if (string-match "^[^ ]+ \\([0-9]*\\) :\\(.*\\)" rest)
	(insert (format "IDLE for %s\n" (irchat-convert-seconds 
					 (matching-substring rest 1))))
      (if (string-match ; maybe older 2.6 or 2.5 server?
	   "^\\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) +\\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) :\\(.*\\)"
	   rest)
	  (let ((dofw (matching-substring rest 2))
		(month (matching-substring rest 3))
		(date (matching-substring rest 4))
		(time (matching-substring rest 5))
		(year (matching-substring rest 6)))
	    (insert (format "Last input received %s." time))
	    (newline))
	(message "IRCHAT: Strange 317 reply")))))


(defun irchat-handle-318-msg (prefix rest)
  "Handle the 318 ENDOFWHOIS."
  nil)


(defun irchat-handle-321-msg (prefix rest)
  "Handle the 321 LISTSTART. (first of names)"
  (insert
   (format "%-10s%6s  %s"
	   "Channel"
	   "Users"
	   "Topic"))
  (newline))


(defun irchat-handle-322-msg (prefix rest)
  "Handle the 322 LIST.(from NAMES)."
  (if (string-match "^\\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) :\\(.*\\)" rest)
      (let ((chnl (matching-substring rest 2))
	    (users (matching-substring rest 3))
	    (topic (matching-substring rest 4)))
	(if (or (string= irchat-channel-filter (downcase chnl))
		(string= irchat-channel-filter "")
		(and (string= irchat-channel-filter "0")
		     (string= chnl "*")))
	    (progn
	      (insert
	       (format "%-10s%6s  %s"
		       (if (string= chnl "*") "Priv"
			 chnl)
		       users
		       topic))
	      (newline))))
    (message "IRCHAT: Strange 322 reply")))


(defun irchat-handle-323-msg (prefix rest) 
  "Handle the 323 RPL_LISTEND. (end of names)"
  nil)


(defun irchat-handle-324-msg (prefix rest)
  "Handle the 324 CHANNELMODEIS."
  (if (string-match "[^ ]* \\([^ ]*\\) \\(.*\\)" rest)
      (let ((chnl (matching-substring rest 1))
	    (str (matching-substring rest 2)))
	(insert (format "*** Mode for %s is %s\n" chnl str)))
    (message (format "IRCHAT: Strange 324 reply '%s'" rest))))


(defun irchat-handle-331-msg (prefix rest)
  "Handle the 331 NOTOPIC"
  (insert "*** IRCHAT: No topic is set")
  (newline))


(defun irchat-handle-332-msg (prefix rest)
  "Handle the 332 TOPIC."
  (if (string-match "[^ ] +:\\(.*\\)" rest)
      (let ((topic (matching-substring rest 1)))
	(insert (format "*** Topic: %s" topic))
	(newline))
    (message "IRCHAT: Strange 332 message")))


(defun irchat-handle-341-msg (prefix rest)
  "Handle the 341 INVITING."
  (if (string-match "^\\([^ ]+\\) +\\([^ ]+\\) +\\([-#0-9+][^ ]*\\)" rest)
      (let ((who (matching-substring rest 1))
	    (nick (matching-substring rest 2))
	    (chnl (matching-substring rest 3)))
	(insert (format "*** %s: Inviting user %s to channel %s" who nick chnl))
	(newline))
    (message "Strange 341 message")))


(defun irchat-handle-351-msg (prefix rest)
  "Handle the 351 VERSION."
  (if (string-match "[^ ]+ \\([^ ]+\\) :*\\([^ ]+\\)[ :]*\\(.*\\)" rest)
      (let ((version (matching-substring rest 1))
	    (machine (matching-substring rest 2))
	    (comments (matching-substring rest 3)))
	(insert (format "*** Machine %s is running IRC version %s (%s)"
			machine version comments))
	(newline))
    (message "IRCHAT: Strange 351 reply")))


(defun irchat-handle-whoreply-msg (prefix rest)
  (irchat-handle-352-msg prefix rest))


(defun irchat-handle-352-msg (prefix rest)
  "Handle the 352 WHOREPLY."
  (if (string-match "\\([^ ]*\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) :[0-9]* ?\\(.*\\)" rest)
      (let ((chnl (matching-substring rest 1))
	    (nick (matching-substring rest 5))
	    (oper (matching-substring rest 6)))
	(insert (format "%3s %10s %9s <%s@%s>"
			oper ;; Kaizzu 06/03/90
			(if (string= chnl "*") "Priv" ; *WORK* needed
			  (if (string= chnl "0")
			      "Priv"
			    chnl))
			nick
			(matching-substring rest 2)
			(irchat-clean-hostname (matching-substring rest 3))))
	(indent-to-column 54 1)
	(insert (matching-substring rest 7))
	(newline))
    (message "IRCHAT: Strange 352 message")))


(defun irchat-handle-namreply-msg (prefix rest)
  (irchat-handle-353-msg prefix rest))


(defun irchat-handle-353-msg (prefix rest)
  "Handle the 353 (NAMREPLY) message.   If we are just polling the server,
don't display anything.  Check if someone we are waiting for has entered."
  (if (string-match "[^ =*@]?[=*@] \\([^ ]*\\) :\\(.*\\)" rest)
      (let ((chnl (matching-substring rest 1))
	    (users (matching-substring rest 2)))
	(if (> irchat-polling 0)
	    nil
	  (insert (format "%9s: %s" (if (string= chnl "*") "Priv" chnl)
			  users))
	  (newline))
	(irchat-scan-channels chnl)
	(irchat-update-thischannel chnl users))
    (message "IRCHAT: Strange 353 message")))


(defun irchat-handle-361-msg (prefix rest)
  "Handle the 361 KILLDONE."
  (if (string-match "[^ ]+ \\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((who (matching-substring rest 1))
	    (message (matching-substring rest 2)))
	(insert 
	 (format "You just KILLED %s. %s"
		 who
		 message))
	(newline))
    (message "IRCHAT: Strange 361 reply")))


(defun irchat-handle-364-msg (prefix rest)
  (if (string-match "^\\([^ ]+\\) +\\([^ ]*\\) +[^ ]* +:\\(.*\\)" rest)
      (progn
	(insert (matching-substring rest 2))
	(indent-to-column 30)
	(insert (matching-substring rest 3))
	(newline))
    (message "IRCHAT: Strange 364 message")))


(defun irchat-handle-365-msg (prefix rest)
  "Handle the 365 ENDOFLINKS."
  nil)


(defun irchat-handle-366-msg (prefix rest)
  "Handle the 366 ENDOFNAMES."
  (let ((level (- irchat-polling 1)))
    (setq irchat-polling (if (< level 0) 0 level))))


(defun irchat-handle-367-msg (prefix rest)
  "Handle the 367 BAN."
  (if (string-match "[^ ]* \\([^ ]*\\) \\([^ ]*\\)" rest)
      (let ((chnl (matching-substring rest 1))
	    (regexp (matching-substring rest 2)))
	(insert (format "*** %s has been banned on %s"
			regexp chnl))
	(newline))
    (message "IRCHAT: Strange 367 message")))


(defun irchat-handle-368-msg (prefix rest)
  "Handle the 368 ???????."
  nil)


(defun irchat-handle-369-msg (prefix rest)
  "Handle the 369 WHOWAS."
  nil)

(defun irchat-handle-371-msg (prefix rest) 
  "Handle the 371 INFO."
  (if (string-match "^\\([^ ]+\\) +:?\\(.*\\)" rest)
      (let ((msg (matching-substring rest 2)))
	(insert (format "*** %s" msg))
	(newline))
    (message "IRCHAT: Strange 371 message")))


(defun irchat-handle-372-msg (prefix rest)
  "Handle the 372 MOTD."
  (string-match "^\\([^ ]+\\) +:?\\(.*\\)" rest)
  (let ((msg (matching-substring rest 2)))
    (insert (format "*** %s" msg))
    (newline)))


(defun irchat-handle-381-msg (prefix rest)
  "Handle the 381 YOUREOPER. ."
  (if (string-match "^\\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((message (matching-substring rest 2)))
	(insert "OPER: " message)
	(newline))
    (message "IRCHAT: Strange 381 reply")))


(defun irchat-handle-382-msg (prefix rest) 
  "Handle the 382 REHASHING."
  (string-match "^\\([^ ]+\\) +:\\(.*\\)" rest)
  (let ((name (matching-substring rest 1))
	(msg (matching-substring rest 2)))
    (insert (format "*** %s: %s" name msg))
    (newline)))


(defun irchat-handle-391-msg (prefix rest)
  "Handle the 391 TIME."
  (if (string-match "^\\([^ ]+\\) +\\(.*\\)" rest)
      (let ((time (matching-substring rest 2)))
	(insert (format "*** Server time: %s" time))
	(newline))
    (message "IRCHAT: Strange 391 message")))

;;;
;;; eof
;;;

