/*---------------------------------------------------------------------------
Site.m -- Copyright (c) 1991 Rex Pruess
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or send
   electronic mail to the the author.
  
A "ns-servers" query to the default server should return a list of
other sites running the CSO Nameserver software.  A Site object is produced
for each site.  Each Site object holds the site, server, and domain
information for that Site.
  
Rex Pruess <Rex-Pruess@uiowa.edu>
  
$Header: /rpruess/apps/Ph/qiServers.subproj/RCS/Site.m,v 2.0 91/11/19 08:26:50 rpruess Exp $
-----------------------------------------------------------------------------
$Log:	Site.m,v $
Revision 2.0  91/11/19  08:26:50  rpruess
Revision 2.0 is the initial production release of Ph.

-----------------------------------------------------------------------------*/

/* Standard C header files */
#include <stdio.h>
#include <strings.h>
#include <sys/malloc.h>

/* Objective-C & Appkit header files */
#import <objc/List.h>

/* Application class header files */
#import "Site.h"

@implementation Site

/*---------------------------------------------------------------------------
Simple initialization; force entries to empty values for safety.
-----------------------------------------------------------------------------*/
- init
{
   [super init];

   site = NULL;
   server = NULL;
   domain = NULL;

   return self;
}

/*---------------------------------------------------------------------------
Methods to set the various fields.
-----------------------------------------------------------------------------*/
- setSite:(const char *)aSite
{
   site = malloc (strlen (aSite) + 1);
   strcpy (site, aSite);

   return self;
}

- setServer:(const char *)aServer
{
   server = malloc (strlen (aServer) + 1);
   strcpy (server, aServer);

   return self;
}

- setDomain:(const char *)aDomain
{
   domain = malloc (strlen (aDomain) + 1);
   strcpy (domain, aDomain);

   return self;
}

/*---------------------------------------------------------------------------
Methods to return the requested data.
-----------------------------------------------------------------------------*/
- (const char *)site
{
   return site;
}

- (const char *)server
{
   return server;
}

- (const char *)domain
{
   return domain;
}

@end
